/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.qamatic.mintleaf.DriverSource;
import org.qamatic.mintleaf.MintleafLogger;

public class JdbcDriverSource
implements DriverSource {
    private static final MintleafLogger logger = MintleafLogger.getLogger(JdbcDriverSource.class);
    protected Properties mvProperties;
    private ClassLoader driverClassLoader;
    private Driver driver;

    private static Driver createDriverInstance(ClassLoader driverClassLoader, String driverClassName, String url) throws SQLException {
        Driver driver = null;
        String message = "Unable to create JDBC driver '" + (driverClassName != null ? driverClassName : "auto-find") + "' for connect URL '" + url + "'";
        try {
            if (driverClassName == null) {
                driver = DriverManager.getDriver(url);
            } else {
                Class<?> driverClaz = JdbcDriverSource.findDriverClass(driverClassLoader, driverClassName);
                driver = (Driver)driverClaz.newInstance();
                if (!driver.acceptsURL(url)) {
                    throw new SQLException("No driver is found!");
                }
            }
        }
        catch (Exception t) {
            logger.error(message);
            throw new SQLException(message, t);
        }
        if (driver == null) {
            logger.error(message);
            throw new SQLException(message);
        }
        return driver;
    }

    private static Class<?> findDriverClass(ClassLoader driverClassLoader, String driverClassName) throws SQLException {
        Class<?> driverClaz;
        block5: {
            try {
                try {
                    if (driverClassLoader == null) {
                        driverClaz = Class.forName(driverClassName);
                        break block5;
                    }
                    driverClaz = Class.forName(driverClassName, true, driverClassLoader);
                }
                catch (ClassNotFoundException cnfe) {
                    driverClaz = Thread.currentThread().getContextClassLoader().loadClass(driverClassName);
                }
            }
            catch (Exception t) {
                String message = "Unable to load JDBC driver:" + driverClassName;
                logger.error(message);
                throw new SQLException(message, t);
            }
        }
        return driverClaz;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.getUsername(), this.getPassword());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDriver().connect(this.getUrl(), this.getProperties());
    }

    public synchronized ClassLoader getDriverClassLoader() {
        return this.driverClassLoader;
    }

    public synchronized void setDriverClassLoader(ClassLoader driverClassLoader) {
        this.driverClassLoader = driverClassLoader;
    }

    protected Properties getProperties() {
        if (this.mvProperties == null) {
            this.mvProperties = new Properties();
        }
        return this.mvProperties;
    }

    private synchronized Driver getDriver() throws SQLException {
        if (this.driver == null) {
            this.driver = JdbcDriverSource.createDriverInstance(this.getDriverClassLoader(), this.getDriverClassName(), this.getUrl());
        }
        return this.driver;
    }

    @Override
    public String getProperty(String propName) {
        return this.getProperties().getProperty(propName);
    }

    @Override
    public void setProperty(String propName, String value) {
        this.getProperties().setProperty(propName, value);
    }

    @Override
    public String getUrl() {
        return this.getProperty("url");
    }

    @Override
    public void setUrl(String jdbcUrl) {
        this.setProperty("url", jdbcUrl);
    }

    @Override
    public String getUsername() {
        return this.getProperty("user");
    }

    @Override
    public void setUsername(String userName) {
        this.setProperty("user", userName);
    }

    @Override
    public String getPassword() {
        return this.getProperty("password");
    }

    @Override
    public void setPassword(String password) {
        this.setProperty("password", password);
    }

    @Override
    public boolean isDebugEnabled() {
        return Boolean.parseBoolean(this.getProperty("debug"));
    }

    @Override
    public void setDebugEnabled(boolean devMode) {
        this.setProperty("debug", devMode + "");
    }

    @Override
    public String getDriverClassName() {
        return this.getProperty("driverClassName");
    }

    @Override
    public void setDriverClassName(String driverClassName) {
        this.setProperty("driverClassName", driverClassName);
    }

    public String toString() {
        return String.format("Connection Properties:\n %s \n", this.getProperties().toString());
    }

    static {
        DriverManager.getDrivers();
    }
}

