/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.qamatic.mintleaf.MetaDataCollection;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.Row;
import org.qamatic.mintleaf.RowListWrapper;

public class ObjectRowListWrapper<T extends Row>
implements RowListWrapper<T>,
List<T> {
    private final List<T> list;
    private MetaDataCollection metaDataCollection;

    public ObjectRowListWrapper(List<T> list, MetaDataCollection metaDataCollection) {
        this.metaDataCollection = metaDataCollection;
        this.list = list;
    }

    public ObjectRowListWrapper(MetaDataCollection metaDataCollection) {
        this.metaDataCollection = metaDataCollection;
        this.list = new ArrayList<T>();
    }

    public ObjectRowListWrapper() {
        this.list = new ArrayList<T>();
    }

    @Override
    public MetaDataCollection getMetaData() throws MintleafException {
        return this.metaDataCollection;
    }

    private void setMetaData(Row row) {
        if (this.metaDataCollection != null) {
            row.setMetaData(this.metaDataCollection);
        }
    }

    @Override
    public T getRow(int index) throws MintleafException {
        return (T)this.get(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T t) {
        this.setMetaData((Row)t);
        return this.list.add(t);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.list.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.list.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.remove(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public T get(int index) {
        Row row = (Row)this.list.get(index);
        this.setMetaData(row);
        return (T)row;
    }

    @Override
    public T set(int index, T element) {
        return (T)((Row)this.list.set(index, element));
    }

    @Override
    public void add(int index, T element) {
        element.setMetaData(this.metaDataCollection);
        this.list.add(index, element);
    }

    @Override
    public T remove(int index) {
        return (T)((Row)this.list.remove(index));
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ObjectListIterator<T>(this.list.listIterator(), this.metaDataCollection);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ObjectListIterator<T>(this.list.listIterator(index), this.metaDataCollection);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    private static final class ObjectListIterator<T extends Row>
    implements ListIterator<T> {
        private final ListIterator<T> listIterator;
        private final MetaDataCollection metaDataCollection;

        public ObjectListIterator(ListIterator<T> listIterator, MetaDataCollection metaDataCollection) {
            this.listIterator = listIterator;
            this.metaDataCollection = metaDataCollection;
        }

        @Override
        public void add(T t) {
            this.setMetaData((Row)t);
            this.listIterator.add(t);
        }

        @Override
        public boolean hasNext() {
            return this.listIterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.listIterator.hasPrevious();
        }

        @Override
        public T next() {
            Row t = (Row)this.listIterator.next();
            this.setMetaData(t);
            return (T)t;
        }

        @Override
        public int nextIndex() {
            return this.listIterator.nextIndex();
        }

        @Override
        public T previous() {
            Row t = (Row)this.listIterator.previous();
            this.setMetaData(t);
            return (T)t;
        }

        @Override
        public int previousIndex() {
            return this.listIterator.previousIndex();
        }

        @Override
        public void remove() {
            this.listIterator.remove();
        }

        @Override
        public void set(T t) {
            this.setMetaData((Row)t);
            this.listIterator.set(t);
        }

        private void setMetaData(Row row) {
            if (this.metaDataCollection != null) {
                row.setMetaData(this.metaDataCollection);
            }
        }
    }
}

