/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.qamatic.mintleaf.MetaDataCollection;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.ResultSetMetaDataCollection;
import org.qamatic.mintleaf.Row;
import org.qamatic.mintleaf.RowListWrapper;
import org.qamatic.mintleaf.core.ResultSetRowWrapper;

public class ResultSetRowListWrapper<T extends Row>
implements RowListWrapper<T> {
    private ResultSet resultSet;
    private MetaDataCollection resultSetMetaData;

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    @Override
    public T getRow(int index) throws MintleafException {
        throw new MintleafException("unsupported");
    }

    @Override
    public boolean isEmpty() {
        MintleafException.throwException("unsupported");
        return false;
    }

    @Override
    public void clear() {
        MintleafException.throwException("unsupported");
    }

    @Override
    public int size() {
        MintleafException.throwException("unsupported");
        return -1;
    }

    @Override
    public MetaDataCollection getMetaData() throws MintleafException {
        if (this.resultSetMetaData == null) {
            try {
                this.resultSetMetaData = new ResultSetMetaDataCollection(this.resultSet.getMetaData());
            }
            catch (SQLException e) {
                throw new MintleafException(e);
            }
        }
        return this.resultSetMetaData;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private ResultSet current;

            private ResultSet getNextRecord() {
                try {
                    if (ResultSetRowListWrapper.this.resultSet.next()) {
                        return ResultSetRowListWrapper.this.resultSet;
                    }
                }
                catch (SQLException e) {
                    MintleafException.throwException(e);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    this.current = this.getNextRecord();
                }
                return this.current != null;
            }

            @Override
            public T next() {
                ResultSet next = this.current;
                this.current = null;
                if (next == null && (next = this.getNextRecord()) == null) {
                    MintleafException.throwException("reached end of records, no more elements");
                }
                ResultSetRowWrapper t = new ResultSetRowWrapper(next);
                return t;
            }
        };
    }
}

