/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.qamatic.mintleaf.MetaDataCollection;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.Row;

public class ResultSetRowWrapper<T>
implements Row {
    private static final MintleafLogger logger = MintleafLogger.getLogger(ResultSetRowWrapper.class);
    private ResultSet resultSet;
    private ResultSetMetaData resultSetMetaData;

    public ResultSetRowWrapper() {
    }

    public ResultSetRowWrapper(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    @Override
    public String getValue(int columnIndex) throws MintleafException {
        try {
            if (this.resultSet.getObject(columnIndex) == null) {
                return "NULL";
            }
            return this.resultSet.getObject(columnIndex).toString();
        }
        catch (SQLException e) {
            throw new MintleafException(e);
        }
    }

    @Override
    public String getValue(String columnName) throws MintleafException {
        try {
            if (this.resultSet.getObject(columnName) == null) {
                return "NULL";
            }
            return this.resultSet.getObject(columnName).toString();
        }
        catch (SQLException e) {
            throw new MintleafException(e);
        }
    }

    @Override
    public int asInt(String columnName) {
        try {
            return this.resultSet.getInt(columnName);
        }
        catch (SQLException e) {
            MintleafException.throwException(e);
            return -1;
        }
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
    }

    @Override
    public ResultSetMetaData getMetaData() throws MintleafException {
        if (this.resultSetMetaData == null) {
            try {
                this.resultSetMetaData = this.resultSet.getMetaData();
            }
            catch (SQLException e) {
                throw new MintleafException(e);
            }
        }
        return this.resultSetMetaData;
    }

    @Override
    public void setMetaData(MetaDataCollection metaDataCollection) {
        this.resultSetMetaData = metaDataCollection;
    }
}

