/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.Executable;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.ParameterBinding;
import org.qamatic.mintleaf.RowListWrapper;
import org.qamatic.mintleaf.RowMatchListener;
import org.qamatic.mintleaf.SqlResultSet;
import org.qamatic.mintleaf.core.BindingParameterSets;
import org.qamatic.mintleaf.core.ResultSetRowListWrapper;
import org.qamatic.mintleaf.core.ResultSetRowWrapper;

public class SelectQuery
implements Executable<SqlResultSet> {
    private static final MintleafLogger logger = MintleafLogger.getLogger(SelectQuery.class);
    private ConnectionContext connectionContext;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;
    private String sql;
    private ParameterBinding parameterBinding;

    public SelectQuery(ConnectionContext connectionContext, String sql, ParameterBinding parameterBinding) {
        this.connectionContext = connectionContext;
        this.parameterBinding = parameterBinding;
        this.sql = sql;
    }

    private ResultSet getResultSet() throws MintleafException {
        if (this.resultSet == null) {
            try {
                this.preparedStatement = this.connectionContext.getConnection().prepareStatement(this.sql);
                if (this.resultSet == null) {
                    if (this.parameterBinding != null) {
                        this.parameterBinding.bindParameters(new BindingParameterSets(this.preparedStatement));
                    }
                    logger.info("executing select query: " + this.sql);
                    this.resultSet = this.preparedStatement.executeQuery();
                }
            }
            catch (MintleafException e) {
                logger.error("error fetching data", e);
                throw new MintleafException(e);
            }
            catch (SQLException e) {
                logger.error(e);
                throw new MintleafException(e);
            }
        }
        return this.resultSet;
    }

    @Override
    public void close() throws MintleafException {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            if (this.preparedStatement != null) {
                this.preparedStatement.close();
            }
            this.resultSet = null;
            this.preparedStatement = null;
        }
        catch (SQLException e) {
            logger.error("FluentJdbc close()", e);
            throw new MintleafException(e);
        }
    }

    @Override
    public SqlResultSet execute() throws MintleafException {
        return new SelectQueryWrapper(this);
    }

    private class SelectQueryWrapper
    implements SqlResultSet {
        private SelectQuery selectQuery;

        private SelectQueryWrapper(SelectQuery selectQuery2) {
            this.selectQuery = selectQuery2;
        }

        @Override
        public ResultSet getResultSet() throws MintleafException {
            return this.selectQuery.getResultSet();
        }

        @Override
        public void close() throws MintleafException {
            this.selectQuery.close();
        }

        @Override
        public ResultSet first() throws MintleafException {
            try {
                this.getResultSet().next();
                return this.getResultSet();
            }
            catch (SQLException e) {
                logger.error(e);
                throw new MintleafException(e);
            }
        }

        @Override
        public <T> void iterate(RowMatchListener<T> listener) throws MintleafException, MintleafException {
            try {
                int i = 0;
                while (this.getResultSet().next()) {
                    ResultSetRowWrapper row = new ResultSetRowWrapper(this.getResultSet());
                    if (listener.matches(row)) {
                        listener.eachRow(i++, row);
                    }
                    if (listener.canContinueRead(row)) continue;
                    break;
                }
            }
            catch (SQLException e) {
                logger.error(e);
                throw new MintleafException(e);
            }
        }

        @Override
        public RowListWrapper asRowListWrapper() throws MintleafException {
            ResultSetRowListWrapper rowListWrapper = new ResultSetRowListWrapper();
            rowListWrapper.setResultSet(this.getResultSet());
            return rowListWrapper;
        }
    }
}

