/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import org.qamatic.mintleaf.ChangeSet;
import org.qamatic.mintleaf.ChangeSetReader;
import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.MintleafReader;
import org.qamatic.mintleaf.core.BaseSqlScript;
import org.qamatic.mintleaf.core.SqlScriptFile;
import org.qamatic.mintleaf.readers.SqlStringReader;

public class SqlChangeSets
extends BaseSqlScript {
    private static final MintleafLogger logger = MintleafLogger.getLogger(SqlScriptFile.class);
    private ChangeSetReader changeSetReader;
    private String[] changeSetsToApply;

    public SqlChangeSets(ConnectionContext connectionContext, ChangeSetReader changeSetReader, String[] changeSetsToApply) {
        super(connectionContext);
        this.changeSetReader = changeSetReader;
        this.changeSetsToApply = changeSetsToApply;
    }

    @Override
    public void apply() throws MintleafException {
        this.changeSetReader.read();
        for (String changeSetName : this.changeSetsToApply) {
            if (this.changeSetReader.getChangeSets().containsKey(changeSetName.trim())) {
                final ChangeSet section = this.changeSetReader.getChangeSet(changeSetName.trim());
                BaseSqlScript script = new BaseSqlScript(this.connectionContext){

                    @Override
                    public MintleafReader getReader() {
                        SqlStringReader reader = new SqlStringReader(section.getChangeSetSource());
                        reader.setDelimiter(section.getDelimiter());
                        return reader;
                    }

                    @Override
                    public void close() throws MintleafException {
                    }
                };
                script.apply();
                continue;
            }
            logger.error("apply a changeset does not exist: " + changeSetName);
        }
        this.close();
    }

    @Override
    public void close() {
        try {
            this.connectionContext.close();
        }
        catch (Exception e) {
            MintleafException.throwException(e);
        }
    }

    @Override
    public MintleafReader getReader() {
        return this.changeSetReader;
    }
}

