/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core;

import java.sql.CallableStatement;
import java.sql.SQLException;
import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.Executable;
import org.qamatic.mintleaf.ExecutionResultListener;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.ParameterBinding;
import org.qamatic.mintleaf.core.CallableBindingParameterSets;

public class StoredProcedure
implements Executable<int[]> {
    private static final MintleafLogger logger = MintleafLogger.getLogger(StoredProcedure.class);
    private ConnectionContext connectionContext;
    private CallType callType;
    private ExecutionResultListener.Callable executionResultListener;
    private String procedureCall;
    private ParameterBinding.Callable parameterBinding;

    public StoredProcedure(ConnectionContext connectionContext, String procedureCall, CallType callType, ParameterBinding.Callable parameterBinding) {
        this.connectionContext = connectionContext;
        this.callType = callType;
        this.procedureCall = procedureCall;
        this.parameterBinding = parameterBinding;
        if (this.procedureCall == null) {
            this.procedureCall = "";
        }
        if (this.callType != CallType.CUSTOMCALL) {
            this.procedureCall = procedureCall.toUpperCase().trim();
        }
    }

    public String getSql() {
        if (this.callType != CallType.CUSTOMCALL && !this.procedureCall.startsWith("CALL ")) {
            this.procedureCall = String.format("{ %sCALL %s }", this.callType == CallType.FUNCTION ? "? = " : "", this.procedureCall);
        }
        return this.procedureCall;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int[] execute() throws MintleafException {
        logger.info(this.getSql());
        try (CallableStatement preparedStatement = this.connectionContext.getConnection().prepareCall(this.getSql());){
            CallableBindingParameterSets parameterSets = new CallableBindingParameterSets(preparedStatement);
            if (this.parameterBinding != null) {
                this.parameterBinding.bindParameters(parameterSets);
            }
            int[] result = new int[]{preparedStatement.execute() ? 1 : 0};
            if (this.executionResultListener != null) {
                this.executionResultListener.onAfterExecuteSql(parameterSets);
            }
            int[] nArray = result;
            return nArray;
        }
        catch (MintleafException e) {
            logger.error("error fetching data", e);
            throw new MintleafException(e);
        }
        catch (SQLException e) {
            logger.error(e);
            throw new MintleafException(e);
        }
    }

    public void setExecutionResultListener(ExecutionResultListener.Callable statementResultListener) {
        this.executionResultListener = statementResultListener;
    }

    public static enum CallType {
        PROC(-1),
        FUNCTION(4),
        CUSTOMCALL(-1);

        private int dataType;

        private CallType(int dataType) {
            this.dataType = dataType;
        }

        public int getReturnType() {
            return this.dataType;
        }

        public CallType returnsType(int type) {
            this.dataType = type;
            return this;
        }
    }
}

