/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core.stdqueries;

import java.util.regex.Pattern;
import org.qamatic.mintleaf.Column;
import org.qamatic.mintleaf.ColumnMetaDataCollection;
import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.core.stdqueries.StandardQueries;

public class H2Queries
extends StandardQueries {
    public H2Queries(ConnectionContext connectionContext) {
        super(connectionContext);
    }

    @Override
    public ColumnMetaDataCollection getMetaData(String objectName) throws MintleafException {
        ColumnMetaDataCollection metaData = new ColumnMetaDataCollection(objectName);
        if (objectName != null) {
            objectName = objectName.toUpperCase();
        }
        String[] splits = objectName.split(Pattern.quote("."));
        String sql = String.format("select * from information_schema.columns where TABLE_SCHEMA ='%s' and TABLE_NAME='%s'", splits[0], splits[1]);
        this.query(sql, (rowNum, rs) -> {
            metaData.add(new Column(){
                {
                    this.setColumnName(rs.asString("COLUMN_NAME"));
                    this.setNullable(rs.asString("IS_NULLABLE") != "NO");
                    this.setColumnSize(1);
                    this.setDatatype(rs.asInt("DATA_TYPE"));
                    this.setColumnSize(rs.asInt("CHARACTER_OCTET_LENGTH"));
                    if (!rs.asString("TYPE_NAME").equals("CHAR") && rs.asString("TYPE_NAME").equals("DECIMAL")) {
                        this.setColumnSize(rs.asInt("NUMERIC_PRECISION"));
                    }
                    this.setDecimalDigits(rs.asInt("NUMERIC_SCALE"));
                }
            });
            return (Column)metaData.get(metaData.size() - 1);
        });
        return metaData;
    }

    @Override
    public boolean isTableExists(String tableName) throws MintleafException {
        return this.getMetaData(tableName).size() != 0;
    }
}

