/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core.stdqueries;

import java.sql.SQLException;
import java.util.List;
import org.qamatic.mintleaf.Column;
import org.qamatic.mintleaf.ColumnMetaDataCollection;
import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.Executable;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.core.FluentJdbc;
import org.qamatic.mintleaf.core.stdqueries.StandardQueries;

public class OracleQueries
extends StandardQueries {
    private static final MintleafLogger logger = MintleafLogger.getLogger(OracleQueries.class);

    public OracleQueries(ConnectionContext connectionContext) {
        super(connectionContext);
    }

    @Override
    public boolean isSqlObjectExists(String objectName, String objectType, boolean ignoreValidity) throws MintleafException {
        String[] objectNames = OracleQueries.utilsSplitDottedObjectNames(objectName.toUpperCase());
        String validSql = ignoreValidity ? "" : "status='VALID' AND ";
        int cnt = this.queryInt("SELECT COUNT(*) FROM ALL_OBJECTS WHERE " + validSql + "OWNER = ? AND object_name = ? AND Object_Type = ?", parameterSets -> {
            parameterSets.setString(1, objectNames[0]);
            parameterSets.setString(2, objectNames[1]);
            parameterSets.setString(3, objectType);
        });
        return cnt != 0;
    }

    @Override
    public boolean isColumnExists(String tableName, String columnName) throws MintleafException {
        String[] objectNames = OracleQueries.utilsSplitDottedObjectNames(tableName.toUpperCase());
        int cnt = this.queryInt("SELECT COUNT(*) FROM ALL_TAB_COLUMNS WHERE OWNER = ? AND table_name = ? AND column_name = ?", parameterSets -> {
            parameterSets.setString(1, objectNames[0]);
            parameterSets.setString(2, objectNames[1]);
            parameterSets.setString(3, columnName.toUpperCase());
        });
        return cnt != 0;
    }

    @Override
    public boolean isTableExists(String tableName) throws MintleafException {
        return this.isSqlObjectExists(tableName, "TABLE", false);
    }

    @Override
    public boolean isDbOptionExists(String optionName) throws MintleafException {
        int cnt = this.queryInt("SELECT COUNT(*) FROM dba_server_registry WHERE comp_id=? and status=?", parameterSets -> {
            parameterSets.setString(1, optionName.toUpperCase());
            parameterSets.setString(2, "VALID");
        });
        return cnt != 0;
    }

    @Override
    public void truncateTable(String tableName) throws MintleafException {
        String[] objectNames = OracleQueries.utilsSplitDottedObjectNames(tableName.toUpperCase());
        String sql = String.format("truncate  table %s.%s", objectNames[0], objectNames[1]);
        try (Executable<int[]> executable = new FluentJdbc.Builder(this.connectionContext).withSql(sql).buildExecute();){
            executable.execute();
        }
    }

    @Override
    public boolean isUserExists(String userName) throws MintleafException {
        return this.queryInt("SELECT COUNT(*) FROM ALL_USERS WHERE username = upper(?)", parameterSets -> parameterSets.setString(1, userName)) != 0;
    }

    @Override
    public List<String> getSqlObjects(String objectType) throws MintleafException {
        return this.queryString(String.format("select object_name from user_objects where object_type='%s'", objectType), null, "object_name");
    }

    @Override
    public List<String> getPrimaryKeys(String ownerName, String tableName) throws MintleafException {
        String owner = "";
        if (ownerName != null) {
            owner = String.format(" and ucc.owner=Upper('%s')", ownerName);
        }
        String sql = String.format("select ucc.column_name as keyname from all_constraints uc, all_cons_columns ucc where uc.table_name = upper('%s') and uc.constraint_type = 'P' and (uc.constraint_name=ucc.constraint_name) and  uc.owner=ucc.owner %s", tableName, owner);
        return this.queryString(sql, null, "keyname");
    }

    @Override
    public boolean isPrivilegeExists(String granteeName, String privilegeName, String objectName) throws MintleafException {
        int cnt = this.queryInt("SELECT COUNT(*) FROM ALL_TAB_PRIVS WHERE grantee = ? AND table_name = ? AND privilege=?", parameterSets -> {
            parameterSets.setString(1, granteeName.toUpperCase());
            parameterSets.setString(2, objectName.toUpperCase());
            parameterSets.setString(3, privilegeName.toUpperCase());
        });
        return cnt != 0;
    }

    private String getSqlObjectMetaSql(String objectName) throws SQLException, MintleafException {
        String[] objectNames = OracleQueries.utilsSplitDottedObjectNames(objectName);
        StringBuilder sql = new StringBuilder(String.format("SELECT COLUMN_NAME,DATA_TYPE TYPE_NAME,DATA_LENGTH,DATA_PRECISION,DATA_SCALE,CHAR_LENGTH FROM ALL_TAB_COLUMNS WHERE \nOWNER = UPPER('%s') AND TABLE_NAME = UPPER('%s') ORDER BY COLUMN_ID", objectNames[0], objectNames[1]));
        String typeCheckSql = String.format("SELECT DECODE(OBJECT_TYPE, 'TYPE', 1, 0) ISTYPEOBJECT FROM ALL_OBJECTS WHERE OWNER = UPPER('%s') AND OBJECT_NAME = UPPER(\n'%s')", objectNames[0], objectNames[1]);
        this.query(typeCheckSql, (row, resultSet) -> {
            if (resultSet.asInt("ISTYPEOBJECT") == 1) {
                sql.setLength(0);
                sql.append(String.format("SELECT ATTR_NAME column_name,ATTR_TYPE_NAME TYPE_NAME,LENGTH DATA_LENGTH,PRECISION DATA_PRECISION,SCALE Data_Scale, \nLENGTH Char_Length FROM ALL_TYPE_ATTRS WHERE OWNER = UPPER('%s') AND TYPE_NAME = UPPER('%s') ORDER BY ATTR_NO ", objectNames[0], objectNames[1]));
            }
            return null;
        });
        return sql.toString();
    }

    @Override
    public ColumnMetaDataCollection getMetaData(String objectName) throws MintleafException {
        ColumnMetaDataCollection metaData = new ColumnMetaDataCollection(objectName);
        if (objectName != null) {
            objectName = objectName.toUpperCase();
        }
        String sql = null;
        try {
            sql = this.getSqlObjectMetaSql(objectName);
            this.query(sql, (row, rs) -> {
                metaData.add(new Column(){
                    {
                        this.setColumnName(rs.asString("COLUMN_NAME"));
                        this.setTypeName(rs.asString("TYPE_NAME"));
                        if (rs.asString("TYPE_NAME").equals("CHAR")) {
                            this.setColumnSize(rs.asInt("CHAR_LENGTH"));
                        } else if (rs.asString("TYPE_NAME").equals("NUMBER")) {
                            this.setColumnSize(rs.asInt("DATA_PRECISION"));
                            this.setDecimalDigits(rs.asInt("DATA_SCALE"));
                        } else {
                            this.setColumnSize(rs.asInt("DATA_LENGTH"));
                            this.setDecimalDigits(rs.asInt("DATA_PRECISION"));
                        }
                    }
                });
                return (Column)metaData.get(metaData.size() - 1);
            });
        }
        catch (SQLException e) {
            logger.error("error getting meta data", e);
            throw new MintleafException(e);
        }
        return metaData;
    }
}

