/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.core.stdqueries;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.DbQueryExtension;
import org.qamatic.mintleaf.DbType;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.ParameterBinding;
import org.qamatic.mintleaf.RowMatchListener;
import org.qamatic.mintleaf.SqlResultSet;
import org.qamatic.mintleaf.core.stdqueries.H2Queries;
import org.qamatic.mintleaf.core.stdqueries.MSSqlQueries;
import org.qamatic.mintleaf.core.stdqueries.MySqlQueries;
import org.qamatic.mintleaf.core.stdqueries.OracleQueries;

public class StandardQueries
implements DbQueryExtension {
    private static final MintleafLogger logger = MintleafLogger.getLogger(StandardQueries.class);
    private static final Map<String, Class<? extends StandardQueries>> registeredQueries = new HashMap<String, Class<? extends StandardQueries>>();
    protected final ConnectionContext connectionContext;

    public StandardQueries(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public static void registerQueryImplementation(String jdbcUrlPrefix, Class<? extends StandardQueries> dbQueryClaz) {
        registeredQueries.put(jdbcUrlPrefix, dbQueryClaz);
    }

    public static Class<? extends StandardQueries> getQueryImplementation(String url) {
        if (DbType.getDbType(url) == null) {
            return StandardQueries.class;
        }
        return registeredQueries.get(DbType.getDbType(url).getJdbcUrlPrefix());
    }

    public static String[] utilsSplitDottedObjectNames(String objectName) throws MintleafException {
        String[] objectNames = objectName.split(Pattern.quote("."));
        if (objectNames.length != 2) {
            throw new MintleafException(String.format("getMetaData expects objectName parameter to be <SCHEMA NAME>.<OBJECT NAME> for example HRDB.COUNTRIES.  Invalid value: %s", objectName));
        }
        return objectNames;
    }

    @Override
    public <T> List<T> query(String sql, ParameterBinding parameterBinding, RowMatchListener<T> listener) throws MintleafException {
        return this.connectionContext.query(sql, parameterBinding, listener);
    }

    @Override
    public int queryInt(String sql, ParameterBinding parameterBinding) throws MintleafException {
        Throwable throwable = null;
        try (SqlResultSet sqlResultSet = this.connectionContext.queryBuilder().withSql(sql).withParamValues(parameterBinding).buildSelect();){
            int n = sqlResultSet.first().getInt(1);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new MintleafException(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    static {
        StandardQueries.registerQueryImplementation(DbType.H2.getJdbcUrlPrefix(), H2Queries.class);
        StandardQueries.registerQueryImplementation(DbType.MSSQL.getJdbcUrlPrefix(), MSSqlQueries.class);
        StandardQueries.registerQueryImplementation(DbType.MYSQL.getJdbcUrlPrefix(), MySqlQueries.class);
        StandardQueries.registerQueryImplementation(DbType.ORACLE.getJdbcUrlPrefix(), OracleQueries.class);
    }
}

