/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.data;

import org.qamatic.mintleaf.MintleafException;

public class CompareColumnState {
    private int columnNumber = -1;
    private int rowNumber = -1;
    private int isSurplusRow;
    private String columnName;
    private Object columnValue;

    public CompareColumnState() {
        this.reset();
    }

    public String asString() throws MintleafException {
        return this.getColumnValue().toString();
    }

    public int asInt() throws MintleafException {
        return (Integer)this.getColumnValue();
    }

    public double asDouble() throws MintleafException {
        return (Double)this.getColumnValue();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String toString() {
        return this.getColumnValue() == null ? "null" : this.getColumnValue().toString();
    }

    public void reset() {
        this.setColumnNumber(-1);
        this.setRowNumber(-1);
        this.setIsSurplusRow(0);
    }

    public void reset(int rowNumber, int columnNumber, int isSurplusRow, Object columnValue) {
        this.setColumnNumber(columnNumber);
        this.setRowNumber(rowNumber);
        this.setIsSurplusRow(isSurplusRow);
        this.setColumnValue(columnValue);
    }

    public void reset(int rowNumber, int columnNumber, int isSurplusRow, String columnName, Object columnValue) {
        this.reset(columnNumber, rowNumber, isSurplusRow, columnValue);
        this.setColumnName(columnName);
    }

    public Object getColumnValue() {
        return this.columnValue;
    }

    public void setColumnValue(Object columnValue) {
        this.columnValue = columnValue;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public int getIsSurplusRow() {
        return this.isSurplusRow;
    }

    public void setIsSurplusRow(int isSurplusRow) {
        this.isSurplusRow = isSurplusRow;
    }

    public String toLog() {
        return String.format("RowNo:%d, ColumnNo:%d, Surplus:%d, Value:%s", this.getRowNumber(), this.getColumnNumber(), this.getIsSurplusRow(), this.toString());
    }
}

