/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.data;

import java.sql.SQLException;
import org.qamatic.mintleaf.ColumnMatcher;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.data.CompareColumnState;
import org.qamatic.mintleaf.data.CompareRowState;
import org.qamatic.mintleaf.data.ComparerListener;

public class OrderedColumnMatcher
implements ColumnMatcher {
    private int columnCountOffset = 0;

    @Override
    public void match(CompareRowState leftRowState, CompareRowState rightRowState, ComparerListener listener) throws MintleafException {
        if (listener == null) {
            return;
        }
        CompareColumnState sourceColumnState = this.createSourceColumnStateInstance();
        CompareColumnState targetColumnState = this.createTargetColumnStateInstance();
        int sourceColumnNumber = sourceColumnState.getColumnNumber();
        int targetColumnNumber = targetColumnState.getColumnNumber();
        try {
            if (leftRowState.Row != null && rightRowState.Row != null) {
                while (sourceColumnNumber < leftRowState.Row.getMetaData().getColumnCount() - 1 + this.columnCountOffset) {
                    sourceColumnState.reset(leftRowState.RowNumber, ++sourceColumnNumber, 0, leftRowState.Row.getValue(sourceColumnNumber));
                    targetColumnState.reset(rightRowState.RowNumber, ++targetColumnNumber, 0, rightRowState.Row.getValue(targetColumnNumber));
                    listener.OnColumnCompare(sourceColumnState, targetColumnState);
                }
                while (targetColumnNumber < rightRowState.Row.getMetaData().getColumnCount() - 1 + this.columnCountOffset) {
                    sourceColumnState.reset(-1, -1, -1, null);
                    targetColumnState.reset(rightRowState.RowNumber, ++targetColumnNumber, 0, rightRowState.Row.getValue(targetColumnNumber));
                    listener.OnColumnCompare(sourceColumnState, targetColumnState);
                }
            } else if (leftRowState.Row != null && rightRowState.Row == null) {
                while (sourceColumnNumber < leftRowState.Row.getMetaData().getColumnCount() - 1 + this.columnCountOffset) {
                    sourceColumnState.reset(leftRowState.RowNumber, ++sourceColumnNumber, 1, leftRowState.Row.getValue(sourceColumnNumber));
                    targetColumnState.reset(-1, -1, -1, null);
                    listener.OnColumnCompare(sourceColumnState, targetColumnState);
                }
            } else if (leftRowState.Row == null && rightRowState.Row != null) {
                while (targetColumnNumber < rightRowState.Row.getMetaData().getColumnCount() - 1 + this.columnCountOffset) {
                    sourceColumnState.reset(-1, -1, -1, null);
                    targetColumnState.reset(rightRowState.RowNumber, ++targetColumnNumber, 1, rightRowState.Row.getValue(targetColumnNumber));
                    listener.OnColumnCompare(sourceColumnState, targetColumnState);
                }
            }
        }
        catch (SQLException e) {
            throw new MintleafException(e);
        }
    }

    protected CompareColumnState createSourceColumnStateInstance() {
        return new CompareColumnState(){
            {
                this.setColumnNumber(OrderedColumnMatcher.this.getColumnCountOffset() - 1);
            }
        };
    }

    protected CompareColumnState createTargetColumnStateInstance() {
        return new CompareColumnState(){
            {
                this.setColumnNumber(OrderedColumnMatcher.this.getColumnCountOffset() - 1);
            }
        };
    }

    public int getColumnCountOffset() {
        return this.columnCountOffset;
    }

    public void setColumnCountOffset(int columnCountOffset) {
        this.columnCountOffset = columnCountOffset;
    }
}

