/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.data;

import java.util.Iterator;
import org.qamatic.mintleaf.ColumnMatcher;
import org.qamatic.mintleaf.DataComparer;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.Row;
import org.qamatic.mintleaf.RowListWrapper;
import org.qamatic.mintleaf.data.CompareRowState;
import org.qamatic.mintleaf.data.ComparerListener;
import org.qamatic.mintleaf.data.OrderedColumnMatcher;

public class OrderedListComparator
implements DataComparer {
    private RowListWrapper<? extends Row> sourceTable;
    private RowListWrapper<? extends Row> targetTable;
    private ComparerListener comparerListener;
    private ColumnMatcher columnMatcher;

    public OrderedListComparator(RowListWrapper<? extends Row> sourceTable, RowListWrapper<? extends Row> targetTable) {
        this.setSourceTable(sourceTable);
        this.setTargetTable(targetTable);
        this.setColumnMatcher(new OrderedColumnMatcher());
    }

    protected CompareRowState getRowStateInstance() {
        return new CompareRowState();
    }

    @Override
    public Boolean execute() throws MintleafException {
        this.assertBefore();
        if (this.comparerListener != null) {
            this.comparerListener.OnBeginCompare(this.sourceTable, this.targetTable);
        }
        CompareRowState sourceRowState = this.getRowStateInstance();
        sourceRowState.setMetaData(this.sourceTable.getMetaData());
        CompareRowState targetRowState = this.getRowStateInstance();
        targetRowState.setMetaData(this.targetTable.getMetaData());
        Iterator sourceIterator = this.sourceTable.iterator();
        Iterator targetIterator = this.targetTable.iterator();
        while (sourceIterator.hasNext()) {
            ++sourceRowState.RowNumber;
            if (targetIterator.hasNext()) {
                this.beforeRowCompare(sourceRowState, targetRowState);
                if (!sourceIterator.hasNext()) {
                    throw new MintleafException("source list does not have anymore elements to iterate thru");
                }
                sourceRowState.Row = (Row)sourceIterator.next();
                sourceRowState.IsSurplusRow = 0;
                ++targetRowState.RowNumber;
                targetRowState.Row = (Row)targetIterator.next();
                targetRowState.IsSurplusRow = 0;
                this.onRowCompare(sourceRowState, targetRowState);
                this.columnMatcher.match(sourceRowState, targetRowState, this.comparerListener);
                this.afterRowCompare(sourceRowState, targetRowState);
                continue;
            }
            this.beforeRowCompare(sourceRowState, targetRowState);
            if (!sourceIterator.hasNext()) {
                throw new MintleafException("source list does not have anymore elements to iterate thru");
            }
            sourceRowState.Row = (Row)sourceIterator.next();
            sourceRowState.IsSurplusRow = 1;
            targetRowState.Row = null;
            targetRowState.IsSurplusRow = -1;
            this.onRowCompare(sourceRowState, targetRowState);
            this.columnMatcher.match(sourceRowState, targetRowState, this.comparerListener);
            this.afterRowCompare(sourceRowState, targetRowState);
        }
        while (targetIterator.hasNext()) {
            this.beforeRowCompare(sourceRowState, targetRowState);
            sourceRowState.Row = null;
            sourceRowState.IsSurplusRow = -1;
            ++targetRowState.RowNumber;
            targetRowState.Row = (Row)targetIterator.next();
            targetRowState.IsSurplusRow = 1;
            this.onRowCompare(sourceRowState, targetRowState);
            this.columnMatcher.match(sourceRowState, targetRowState, this.comparerListener);
            this.afterRowCompare(sourceRowState, targetRowState);
        }
        if (this.comparerListener != null) {
            this.comparerListener.OnEndCompare(sourceRowState, targetRowState);
        }
        return true;
    }

    private void assertBefore() throws MintleafException {
        if (this.columnMatcher == null) {
            throw new MintleafException("RowMatcher must be set");
        }
        if (this.sourceTable == null) {
            throw new MintleafException("SourceTable is missing");
        }
        if (this.targetTable == null) {
            throw new MintleafException("TargetTable is missing");
        }
    }

    private void onRowCompare(CompareRowState sourceRowState, CompareRowState targetRowState) throws MintleafException {
        if (this.comparerListener != null) {
            this.comparerListener.OnRowCompare(sourceRowState, targetRowState);
        }
    }

    private void beforeRowCompare(CompareRowState sourceRowState, CompareRowState targetRowState) throws MintleafException {
        if (this.comparerListener != null) {
            this.comparerListener.onBeforeRowCompare(sourceRowState, targetRowState);
        }
    }

    private void afterRowCompare(CompareRowState sourceRowState, CompareRowState targetRowState) throws MintleafException {
        if (this.comparerListener != null) {
            this.comparerListener.onAfterRowCompare(sourceRowState, targetRowState);
        }
    }

    @Override
    public void setComparerListener(ComparerListener comparerListener) {
        this.comparerListener = comparerListener;
    }

    @Override
    public void setColumnMatcher(ColumnMatcher columnMatcher) {
        this.columnMatcher = columnMatcher;
    }

    @Override
    public RowListWrapper getSourceTable() {
        return this.sourceTable;
    }

    @Override
    public void setSourceTable(RowListWrapper<? extends Row> sourceTable) {
        this.sourceTable = sourceTable;
    }

    @Override
    public RowListWrapper getTargetTable() {
        return this.targetTable;
    }

    @Override
    public void setTargetTable(RowListWrapper<? extends Row> targetTable) {
        this.targetTable = targetTable;
    }
}

