/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.data;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.qamatic.mintleaf.ColumnMatcher;
import org.qamatic.mintleaf.MetaDataCollection;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.data.CompareColumnState;
import org.qamatic.mintleaf.data.CompareRowState;
import org.qamatic.mintleaf.data.ComparerListener;

public class SelectedColumnMatcher
implements ColumnMatcher {
    private String selectedColumnMaps;
    private List<String> sourceColumns;
    private List<String> targetColumns;
    private int[] sourceColumnsIndexes;
    private int[] targetColumnsIndexes;

    public SelectedColumnMatcher(String selectedColumnMaps) {
        this.selectedColumnMaps = selectedColumnMaps;
    }

    public List<String> getSourceColumns() {
        this.prepareColumns();
        return this.sourceColumns;
    }

    public List<String> getTargetColumns() {
        this.prepareColumns();
        return this.targetColumns;
    }

    private int[] getColumnIndexes(List<String> columns, MetaDataCollection metaDataCollection) {
        int[] indices = new int[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            indices[i] = metaDataCollection.getIndex(columns.get(i));
        }
        return indices;
    }

    @Override
    public void match(CompareRowState leftRowState, CompareRowState rightRowState, ComparerListener listener) throws MintleafException {
        block5: {
            CompareColumnState targetColumnState;
            CompareColumnState sourceColumnState;
            block6: {
                block4: {
                    if (listener == null) {
                        return;
                    }
                    sourceColumnState = this.createSourceColumnStateInstance();
                    targetColumnState = this.createTargetColumnStateInstance();
                    this.sourceColumnsIndexes = this.getColumnIndexes(this.getSourceColumns(), leftRowState.getMetaData());
                    this.targetColumnsIndexes = this.getColumnIndexes(this.getTargetColumns(), rightRowState.getMetaData());
                    if (leftRowState.Row == null || rightRowState.Row == null) break block4;
                    for (int i = 0; i < this.sourceColumns.size(); ++i) {
                        sourceColumnState.reset(leftRowState.RowNumber, this.sourceColumnsIndexes[i], 0, leftRowState.Row.getValue(this.sourceColumnsIndexes[i]));
                        targetColumnState.reset(rightRowState.RowNumber, this.targetColumnsIndexes[i], 0, rightRowState.Row.getValue(this.targetColumnsIndexes[i]));
                        listener.OnColumnCompare(sourceColumnState, targetColumnState);
                    }
                    break block5;
                }
                if (leftRowState.Row == null || rightRowState.Row != null) break block6;
                for (int i = 0; i < this.sourceColumns.size(); ++i) {
                    sourceColumnState.reset(leftRowState.RowNumber, this.sourceColumnsIndexes[i], 1, leftRowState.Row.getValue(this.sourceColumnsIndexes[i]));
                    targetColumnState.reset(-1, -1, -1, null);
                    listener.OnColumnCompare(sourceColumnState, targetColumnState);
                }
                break block5;
            }
            if (leftRowState.Row != null || rightRowState.Row == null) break block5;
            for (int i = 0; i < this.targetColumns.size(); ++i) {
                sourceColumnState.reset(-1, -1, -1, null);
                targetColumnState.reset(rightRowState.RowNumber, this.targetColumnsIndexes[i], 1, rightRowState.Row.getValue(this.targetColumnsIndexes[i]));
                listener.OnColumnCompare(sourceColumnState, targetColumnState);
            }
        }
    }

    protected CompareColumnState createSourceColumnStateInstance() {
        return new CompareColumnState();
    }

    protected CompareColumnState createTargetColumnStateInstance() {
        return new CompareColumnState();
    }

    private void prepareColumns() {
        if (this.sourceColumns != null) {
            return;
        }
        this.sourceColumns = new ArrayList<String>();
        this.targetColumns = new ArrayList<String>();
        String[] commaSplits = this.selectedColumnMaps.split(Pattern.quote(","));
        if (commaSplits.length <= 0) {
            MintleafException.throwException("selected column maps is empty, unable to proceed");
        }
        for (String sp : commaSplits) {
            String[] maps = sp.split(Pattern.quote("="));
            if (maps.length != 2) {
                MintleafException.throwException("selected column maps is not defined right. format sourcecolumn=targetcolumn");
            }
            this.sourceColumns.add(maps[0].trim());
            this.targetColumns.add(maps[1].trim());
        }
    }
}

