/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.readers;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafReader;
import org.qamatic.mintleaf.Row;
import org.qamatic.mintleaf.core.BaseReader;
import org.qamatic.mintleaf.readers.CsvRowWrapper;

public class CsvReader<T>
extends BaseReader
implements MintleafReader<T> {
    private Reader afileReader;

    public CsvReader(Reader afileReader) {
        this.afileReader = afileReader;
    }

    protected CSVParser getCSVParser() throws IOException {
        return new CSVParser(this.afileReader, CSVFormat.EXCEL.withHeader(new String[0]).withIgnoreEmptyLines());
    }

    @Override
    public T read() throws MintleafException {
        try {
            CSVRecord record;
            Row row;
            CSVParser parser = this.getCSVParser();
            int i = 0;
            Iterator iterator = parser.iterator();
            while (iterator.hasNext() && this.readRow(i++, row = this.createRowInstance(record = (CSVRecord)iterator.next()))) {
            }
        }
        catch (IOException e) {
            throw new MintleafException(e);
        }
        return null;
    }

    public Row createRowInstance(CSVRecord record) {
        return new CsvRowWrapper(record);
    }
}

