/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.readers;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.qamatic.mintleaf.Column;
import org.qamatic.mintleaf.ColumnMetaDataCollection;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.Row;
import org.qamatic.mintleaf.RowListWrapper;
import org.qamatic.mintleaf.readers.CsvRowWrapper;

public class CsvRowListWrapper<T extends Row>
implements RowListWrapper<T> {
    protected CSVParser parser;
    private Reader afileReader;
    private ColumnMetaDataCollection metaDataCollection = new ColumnMetaDataCollection("CSV");

    public CsvRowListWrapper(Reader afileReader) {
        this.afileReader = afileReader;
    }

    protected CSVParser getCSVParser() throws MintleafException {
        if (this.parser == null) {
            try {
                this.parser = new CSVParser(this.afileReader, CSVFormat.EXCEL.withHeader(new String[0]).withIgnoreEmptyLines());
            }
            catch (IOException e) {
                throw new MintleafException(e);
            }
        }
        return this.parser;
    }

    @Override
    public T getRow(int index) throws MintleafException {
        try {
            CsvRowWrapper t = new CsvRowWrapper((CSVRecord)this.getCSVParser().getRecords().get(index));
            t.setMetaData(this.getMetaData());
            return (T)t;
        }
        catch (IOException e) {
            throw new MintleafException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
        MintleafException.throwException("unsupported");
    }

    @Override
    public int size() {
        try {
            return this.getCSVParser().getRecords().size();
        }
        catch (IOException e) {
            MintleafException.throwException(e);
        }
        catch (MintleafException e) {
            MintleafException.throwException(e);
        }
        return 0;
    }

    @Override
    public ColumnMetaDataCollection getMetaData() throws MintleafException {
        return this.metaDataCollection;
    }

    private Iterator<CSVRecord> getIterator() throws MintleafException {
        if (this.metaDataCollection.size() == 0) {
            for (String columnName : this.getCSVParser().getHeaderMap().keySet()) {
                this.metaDataCollection.add(new Column(columnName));
            }
        }
        return this.getCSVParser().iterator();
    }

    @Override
    public Iterator<T> iterator() {
        try {
            return new CsvRowIterator(this.getIterator(), this.getMetaData());
        }
        catch (MintleafException e) {
            MintleafException.throwException(e);
            return null;
        }
    }

    private static final class CsvRowIterator<T extends Row>
    implements Iterator<T> {
        private final Iterator<CSVRecord> iterator;
        private final ColumnMetaDataCollection metaDataCollection;
        private CSVRecord current;

        public CsvRowIterator(Iterator<CSVRecord> iterator, ColumnMetaDataCollection metaDataCollection) {
            this.iterator = iterator;
            this.metaDataCollection = metaDataCollection;
        }

        private CSVRecord getNextRecord() {
            CSVRecord record;
            try {
                record = this.iterator.next();
            }
            catch (NoSuchElementException var2) {
                record = null;
            }
            return record;
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                this.current = this.getNextRecord();
            }
            return this.current != null;
        }

        @Override
        public T next() {
            CSVRecord next = this.current;
            this.current = null;
            if (next == null && (next = this.getNextRecord()) == null) {
                throw new NoSuchElementException("No more CSV records available");
            }
            CsvRowWrapper t = new CsvRowWrapper(next);
            t.setMetaData(this.metaDataCollection);
            return (T)t;
        }
    }
}

