/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.readers;

import java.sql.SQLException;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.MintleafReader;
import org.qamatic.mintleaf.SqlResultSet;
import org.qamatic.mintleaf.core.BaseReader;
import org.qamatic.mintleaf.core.ResultSetRowWrapper;

public class DbResultSetReader<T>
extends BaseReader
implements MintleafReader<T> {
    private static final MintleafLogger logger = MintleafLogger.getLogger(DbResultSetReader.class);
    private SqlResultSet resultSet;

    public DbResultSetReader(SqlResultSet resultSet) {
        this.resultSet = resultSet;
    }

    @Override
    public T read() throws MintleafException {
        int i = 0;
        try {
            while (this.resultSet.getResultSet().next()) {
                ResultSetRowWrapper dbRowWrapper = new ResultSetRowWrapper();
                dbRowWrapper.setResultSet(this.resultSet.getResultSet());
                if (this.readRow(i++, dbRowWrapper)) continue;
                break;
            }
        }
        catch (SQLException e) {
            throw new MintleafException(e);
        }
        return null;
    }

    @Override
    public void close() {
        try {
            this.resultSet.close();
        }
        catch (MintleafException e) {
            MintleafException.throwException(e);
        }
    }
}

