/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.readers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qamatic.mintleaf.ChangeSet;
import org.qamatic.mintleaf.ChangeSetReader;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.core.BaseReader;
import org.qamatic.mintleaf.readers.SqlChangeSetFileReader;
import org.qamatic.mintleaf.tools.FileFinder;

public class MultiChangeSetFileReader<T>
extends BaseReader
implements ChangeSetReader {
    private static final MintleafLogger logger = MintleafLogger.getLogger(MultiChangeSetFileReader.class);
    private final HashMap<String, ChangeSet> changeSets = new HashMap();
    private Map<String, String> userVariableMapping;
    private String[] paths;

    public MultiChangeSetFileReader(String[] paths) {
        this.paths = paths;
    }

    @Override
    public ChangeSet getChangeSet(String changeSetId) {
        return this.getChangeSets().get(changeSetId);
    }

    @Override
    public HashMap<String, ChangeSet> getChangeSets() {
        return this.changeSets;
    }

    @Override
    public String getDelimiter() {
        return null;
    }

    @Override
    public void setDelimiter(String delimStr) {
    }

    @Override
    public T read() throws MintleafException {
        for (String path : this.paths) {
            FileFinder fileFinder = new FileFinder(path);
            List<String> files = fileFinder.list();
            for (String file : files) {
                SqlChangeSetFileReader changeSetReader = new SqlChangeSetFileReader(file){

                    @Override
                    public HashMap<String, ChangeSet> getChangeSets() {
                        return MultiChangeSetFileReader.this.changeSets;
                    }
                };
                changeSetReader.setReadListener(this.getReadListener());
                changeSetReader.setUserVariableMapping(this.getUserVariableMapping());
                changeSetReader.read();
            }
        }
        return null;
    }

    @Override
    public Map<String, String> getUserVariableMapping() {
        if (this.userVariableMapping == null) {
            this.userVariableMapping = new HashMap<String, String>();
        }
        return this.userVariableMapping;
    }

    @Override
    public void setUserVariableMapping(Map userVariableMapping) {
        this.userVariableMapping = userVariableMapping;
    }
}

