/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.readers;

import java.io.InputStream;
import java.util.HashMap;
import org.qamatic.mintleaf.ChangeSet;
import org.qamatic.mintleaf.ChangeSetReader;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.configuration.ArgPatternHandler;
import org.qamatic.mintleaf.core.Readerline;
import org.qamatic.mintleaf.readers.SqlStreamReader;

public class SqlChangeSetFileReader<T>
extends SqlStreamReader
implements ChangeSetReader<T> {
    private static final MintleafLogger logger = MintleafLogger.getLogger(SqlChangeSetFileReader.class);
    private final HashMap<String, ChangeSet> changeSets = new HashMap();
    private ChangeSet currentChangeSet;

    public SqlChangeSetFileReader(InputStream stream) {
        super(stream);
    }

    public SqlChangeSetFileReader(String resource) {
        super(resource);
    }

    @Override
    public ChangeSet getChangeSet(String changeSetId) {
        return this.getChangeSets().get(changeSetId);
    }

    @Override
    public HashMap<String, ChangeSet> getChangeSets() {
        return this.changeSets;
    }

    @Override
    public T read() throws MintleafException {
        super.read();
        String sql = this.content.toString().trim();
        if (this.currentChangeSet != null && this.currentChangeSet.getId() != null && this.currentChangeSet.getId().length() != 0 && sql.length() != 0) {
            this.currentChangeSet.setChangeSetSource(sql);
            this.getChangeSets().put(this.currentChangeSet.getId(), this.currentChangeSet);
            if (this.getReadListener() != null) {
                this.getReadListener().eachRow(this.getChangeSets().size() - 1, this.currentChangeSet);
            }
        }
        return null;
    }

    @Override
    protected Readerline readLine() {
        return line -> {
            if (line.trim().contains("<ChangeSet") && ChangeSet.xmlToChangeSet(line) != null) {
                String sql;
                if (this.currentChangeSet == null) {
                    this.currentChangeSet = ChangeSet.xmlToChangeSet(line);
                }
                if ((sql = new ArgPatternHandler(this.content.toString().trim()).withUserProperties(this.getUserVariableMapping()).getText()).length() != 0) {
                    this.currentChangeSet.setChangeSetSource(sql);
                    this.getChangeSets().put(this.currentChangeSet.getId(), this.currentChangeSet);
                    if (this.getReadListener() != null) {
                        this.getReadListener().eachRow(this.getChangeSets().size() - 1, this.currentChangeSet);
                    }
                    this.currentChangeSet = ChangeSet.xmlToChangeSet(line);
                }
                this.content.setLength(0);
                return false;
            }
            this.content.append(line);
            this.content.append("\n");
            return true;
        };
    }

    @Override
    public String getDelimiter() {
        throw new UnsupportedOperationException("Not applicable");
    }

    @Override
    public void setDelimiter(String delimStr) {
        throw new UnsupportedOperationException("Not applicable");
    }
}

