/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.readers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.qamatic.mintleaf.ChangeSet;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.configuration.ArgPatternHandler;
import org.qamatic.mintleaf.core.BaseSqlReader;
import org.qamatic.mintleaf.core.Readerline;

public class SqlStreamReader<T>
extends BaseSqlReader<T> {
    private static final MintleafLogger logger = MintleafLogger.getLogger(SqlStreamReader.class);
    protected final StringBuilder content = new StringBuilder();
    protected InputStream inputStream;
    protected String resource;
    protected boolean skipLineFeeds;
    private int readCount;

    public SqlStreamReader(InputStream stream) {
        this.inputStream = stream;
    }

    public SqlStreamReader(String resource) {
        this.resource = resource;
    }

    protected InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = BaseSqlReader.getInputStreamFromFile(this.resource);
        }
        return this.inputStream;
    }

    @Override
    public T read() throws MintleafException {
        this.content.setLength(0);
        BufferedReader input = null;
        try {
            try {
                input = new BufferedReader(new InputStreamReader(this.getInputStream(), "UTF-8"));
                String line = null;
                while ((line = input.readLine()) != null) {
                    if (!this.skipLineFeeds && (line = line.trim()).length() == 0 || this.readLine().processInternal(line)) continue;
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        catch (IOException e) {
            logger.error(e);
            throw new MintleafException(e);
        }
        return null;
    }

    protected Readerline readLine() {
        return line -> {
            if (line.startsWith("show err") || line.startsWith("--") && !line.contains("--@")) {
                return false;
            }
            if (this.isDelimiter(line)) {
                String[] splits = line.split(this.getDelimiter());
                if (splits.length >= 1) {
                    this.content.append(splits[0]);
                }
                String sql = new ArgPatternHandler(this.content.toString().trim()).withUserProperties(this.getUserVariableMapping()).getText();
                if (this.getReadListener() != null && sql.length() != 0) {
                    this.getReadListener().eachRow(this.readCount++, new ChangeSet(this.readCount + "", this.getDelimiter(), sql));
                }
                this.content.setLength(0);
            } else {
                this.content.append(line);
                this.content.append("\n");
            }
            return true;
        };
    }
}

