/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.readers;

import org.qamatic.mintleaf.ChangeSet;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.configuration.ArgPatternHandler;
import org.qamatic.mintleaf.core.BaseSqlReader;

public class SqlStringReader<T>
extends BaseSqlReader<T> {
    private final String mvSqlSource;
    private int readCount;

    public SqlStringReader(String sqlSource) {
        this.mvSqlSource = sqlSource;
    }

    @Override
    public T read() throws MintleafException {
        String[] sqlLines;
        StringBuilder childContents = new StringBuilder();
        for (String line : sqlLines = this.mvSqlSource.split("\n")) {
            if ((line = line.trim()).startsWith("show err") || line.startsWith("--")) continue;
            if (this.isDelimiter(line)) {
                String[] splits = line.split(this.getDelimiter());
                if (splits.length >= 1) {
                    childContents.append(splits[0]);
                }
                String sql = new ArgPatternHandler(childContents.toString().trim()).withUserProperties(this.getUserVariableMapping()).getText();
                if (this.getReadListener() != null && sql.length() != 0) {
                    this.getReadListener().eachRow(this.readCount++, new ChangeSet(this.readCount + "", this.getDelimiter(), sql));
                }
                childContents.setLength(0);
                continue;
            }
            childContents.append(line);
            childContents.append("\n");
        }
        return null;
    }
}

