/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.readers;

import java.io.InputStream;
import org.qamatic.mintleaf.ChangeSet;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.configuration.ArgPatternHandler;
import org.qamatic.mintleaf.core.Readerline;
import org.qamatic.mintleaf.readers.SqlStreamReader;

public class TextContentStreamReader<T>
extends SqlStreamReader {
    private static final MintleafLogger logger = MintleafLogger.getLogger(TextContentStreamReader.class);

    public TextContentStreamReader(String resource) {
        super(resource);
    }

    public TextContentStreamReader(InputStream stream) {
        super(stream);
    }

    @Override
    public T read() throws MintleafException {
        this.skipLineFeeds = true;
        super.read();
        if (this.getReadListener() != null && this.content.length() != 0) {
            this.getReadListener().eachRow(0, new ChangeSet("0", this.getDelimiter(), this.content.toString()));
        }
        return null;
    }

    @Override
    protected Readerline readLine() {
        return line -> {
            this.content.append(line);
            return true;
        };
    }

    public String getContent() {
        ArgPatternHandler argPatternHandler = new ArgPatternHandler(this.content.toString());
        argPatternHandler.withUserProperties(this.getUserVariableMapping());
        return argPatternHandler.getText();
    }

    public String toString() {
        return this.getContent();
    }
}

