/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.Executable;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.ParameterBinding;
import org.qamatic.mintleaf.SqlResultSet;
import org.qamatic.mintleaf.tools.CsvExportFlavour;

public class CsvExporter
implements Executable<Boolean> {
    private ParameterBinding sqlaramValueBindings;
    private ConnectionContext sourceDb;
    private String sourceSql;
    private String targetCsvFile;

    public CsvExporter(ConnectionContext sourceDb, String sourceSql, String targetCsvFile) {
        this.sourceDb = sourceDb;
        this.sourceSql = sourceSql;
        this.targetCsvFile = targetCsvFile;
    }

    @Override
    public Boolean execute() throws MintleafException {
        try {
            File f = new File(this.targetCsvFile);
            try (SqlResultSet sqlResultSet = this.sourceDb.queryBuilder().withSql(this.sourceSql).withParamValues(this.sqlaramValueBindings).buildSelect();){
                this.createFlavour(f).export(sqlResultSet.getResultSet());
            }
            return true;
        }
        catch (IOException e) {
            throw new MintleafException(e);
        }
    }

    protected CsvExportFlavour createFlavour(File f) throws IOException {
        return new CsvExportFlavour(new FileWriter(f));
    }

    public void setSqlaramValueBindings(ParameterBinding sqlaramValueBindings) {
        this.sqlaramValueBindings = sqlaramValueBindings;
    }
}

