/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.tools;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.Executable;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.MintleafReader;
import org.qamatic.mintleaf.readers.CsvReader;
import org.qamatic.mintleaf.tools.SqlBatchInsertReadListener;

public class CsvImporter
extends SqlBatchInsertReadListener
implements Executable<Boolean> {
    private static final MintleafLogger logger = MintleafLogger.getLogger(CsvImporter.class);
    private String sourceCsvFile;
    private ConnectionContext targetDb;
    private String targetSqlTemplate;

    public CsvImporter(String sourceCsvFile, ConnectionContext targetDb, String targetSqlTemplate) {
        this.sourceCsvFile = sourceCsvFile;
        this.targetDb = targetDb;
        this.targetSqlTemplate = targetSqlTemplate;
    }

    @Override
    protected String getSql() {
        return this.targetSqlTemplate;
    }

    @Override
    public MintleafReader getReader() throws MintleafException {
        try {
            File f = new File(this.sourceCsvFile);
            if (!f.exists()) {
                logger.error("file not found " + this.sourceCsvFile);
                throw new MintleafException("file not found " + this.sourceCsvFile);
            }
            CsvReader reader = new CsvReader(new FileReader(f));
            reader.setReadListener(this);
            return reader;
        }
        catch (IOException e) {
            throw new MintleafException(e);
        }
    }

    @Override
    protected ConnectionContext getConnectionContext() {
        return this.targetDb;
    }
}

