/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.tools;

import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.Executable;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.MintleafReader;
import org.qamatic.mintleaf.ParameterBinding;
import org.qamatic.mintleaf.SqlResultSet;
import org.qamatic.mintleaf.readers.DbResultSetReader;
import org.qamatic.mintleaf.tools.SqlBatchInsertReadListener;

public class DbImporter
extends SqlBatchInsertReadListener
implements Executable<Boolean> {
    private static final MintleafLogger logger = MintleafLogger.getLogger(DbImporter.class);
    private ConnectionContext targetDb;
    private String targetSqlTemplate;
    private ConnectionContext sourceDb;
    private String sourceSql;
    private ParameterBinding sourceSqlParamValueBindings;
    private MintleafReader reader;

    public DbImporter(ConnectionContext sourceDb, String sourceSql, ConnectionContext targetDb, String targetSqlTemplate) {
        this.sourceDb = sourceDb;
        this.sourceSql = sourceSql;
        this.targetDb = targetDb;
        this.targetSqlTemplate = targetSqlTemplate;
    }

    @Override
    protected ConnectionContext getConnectionContext() {
        return this.sourceDb;
    }

    @Override
    protected String getSql() {
        return this.targetSqlTemplate;
    }

    @Override
    public MintleafReader getReader() {
        SqlResultSet sourceSqlResultSet = this.getConnectionContext().queryBuilder().withSql(this.sourceSql).withParamValues(this.sourceSqlParamValueBindings).buildSelect();
        DbResultSetReader reader = new DbResultSetReader(sourceSqlResultSet);
        reader.setReadListener(this);
        return reader;
    }

    public void setSourceSqlParamValueBindings(ParameterBinding sourceSqlParamValueBindings) {
        this.sourceSqlParamValueBindings = sourceSqlParamValueBindings;
    }
}

