/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.tools;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.qamatic.mintleaf.MintleafLogger;

public class FileFinder {
    private static final MintleafLogger logger = MintleafLogger.getLogger(FileFinder.class);
    private final PathMatcher matcher;
    private final String path;
    private final boolean regExMatch;

    public FileFinder(String path) {
        String[] pathSplits = path.split("/");
        this.regExMatch = path.contains("regex:");
        String wildCardName = this.regExMatch ? pathSplits[pathSplits.length - 1] : "glob:" + pathSplits[pathSplits.length - 1];
        this.path = path.replaceAll("\\Q" + pathSplits[pathSplits.length - 1] + "\\E", "");
        this.matcher = FileSystems.getDefault().getPathMatcher(wildCardName);
    }

    public List<String> list() {
        final ArrayList<String> files = new ArrayList<String>();
        try {
            Files.walkFileTree(Paths.get(this.path, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    Path name;
                    Path path = name = FileFinder.this.regExMatch ? file.toAbsolutePath() : file.getFileName();
                    if (name != null && FileFinder.this.matcher.matches(name)) {
                        files.add(file.toAbsolutePath().toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            logger.error(e);
        }
        return files;
    }
}

