/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qamatic.mintleaf.ConnectionContext;
import org.qamatic.mintleaf.Executable;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.MintleafReader;
import org.qamatic.mintleaf.ReadListener;
import org.qamatic.mintleaf.Row;

public abstract class SqlBatchInsertReadListener<T>
implements ReadListener<T> {
    private static final MintleafLogger logger = MintleafLogger.getLogger(SqlBatchInsertReadListener.class);
    final Pattern columnPattern = Pattern.compile("\\$(\\w+)\\$", 42);
    private Matcher columns;
    private List<String> batchSqls = new ArrayList<String>();

    protected abstract ConnectionContext getConnectionContext();

    protected abstract String getSql();

    public Boolean execute() throws MintleafException {
        this.columns = this.columnPattern.matcher(this.getSql());
        logger.info("importing using template:" + this.getSql());
        this.batchSqls.clear();
        Executable<int[]> batchCall = this.getConnectionContext().executeBatchSqls(this.batchSqls);
        try {
            this.getReader().read();
            this.getReader().close();
            batchCall.execute();
        }
        catch (Exception e) {
            throw new MintleafException(e);
        }
        return true;
    }

    public abstract MintleafReader getReader() throws MintleafException;

    @Override
    public T eachRow(int rowNum, Row row) throws MintleafException {
        StringBuffer buffer = new StringBuffer(this.getSql());
        this.columns.reset();
        while (this.columns.find()) {
            int idx = buffer.indexOf("$" + this.columns.group(1));
            buffer.replace(idx, idx + this.columns.group(1).length() + 2, row.asString(this.columns.group(1)));
        }
        this.batchSqls.add(buffer.toString());
        return null;
    }
}

