/*
 * Decompiled with CFR 0.152.
 */
package org.qamatic.mintleaf.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qamatic.mintleaf.MintleafException;
import org.qamatic.mintleaf.MintleafLogger;
import org.qamatic.mintleaf.ReadListener;
import org.qamatic.mintleaf.Row;

public class SqlTemplateBasedReadListener<T>
implements ReadListener<T> {
    private static final MintleafLogger logger = MintleafLogger.getLogger(SqlTemplateBasedReadListener.class);
    final Pattern columnPattern = Pattern.compile("\\$(\\w+)\\$", 42);
    private Matcher columns;
    private List<String> batchSqls = new ArrayList<String>();
    private String templateSql;

    public SqlTemplateBasedReadListener(String templateSql) {
        this.templateSql = templateSql;
        this.columns = this.columnPattern.matcher(this.templateSql);
    }

    public final List<String> getBatchSqls() {
        return this.batchSqls;
    }

    @Override
    public T eachRow(int rowNum, Row row) throws MintleafException {
        StringBuffer buffer = new StringBuffer(this.templateSql);
        this.columns.reset();
        while (this.columns.find()) {
            int idx = buffer.indexOf("$" + this.columns.group(1));
            buffer.replace(idx, idx + this.columns.group(1).length() + 2, row.asString(this.columns.group(1)));
        }
        this.batchSqls.add(buffer.toString());
        return null;
    }
}

