/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.probe;

import io.smallrye.common.constraint.Assert;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qbicc.context.DiagnosticContext;
import org.qbicc.context.Location;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.machine.object.ObjectFile;
import org.qbicc.machine.object.ObjectFileProvider;
import org.qbicc.machine.probe.ProbeUtil;
import org.qbicc.machine.probe.Qualifier;
import org.qbicc.machine.tool.CCompilerInvoker;
import org.qbicc.machine.tool.CToolChain;
import org.qbicc.machine.tool.CompilationFailureException;
import org.qbicc.machine.tool.ToolInvoker;
import org.qbicc.machine.tool.ToolMessageHandler;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.type.ArrayType;
import org.qbicc.type.BooleanType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.PointerType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;

public final class CProbe {
    private static final byte[] NO_BYTES = new byte[0];
    private final List<Step> items;
    private final List<Type> types;
    private final List<String> constants;
    private final Map<String, Type> constantTypes;
    private final List<String> functionNames;

    CProbe(Builder builder) {
        this.items = List.copyOf(builder.items);
        this.types = List.copyOf(builder.types);
        this.constants = List.copyOf(builder.constants);
        this.constantTypes = Map.copyOf(builder.constantTypes);
        this.functionNames = List.copyOf(builder.functionNames);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Result run(CToolChain toolChain, ObjectFileProvider objectFileProvider, final DiagnosticContext errorReporter) throws IOException {
        CCompilerInvoker inv = toolChain.newCompilerInvoker();
        StringBuilder b = new StringBuilder();
        for (Step item : this.items) {
            item.appendTo(b);
        }
        inv.setSource(InputSource.from((CharSequence)b));
        Path path = Files.createTempFile("qbicc-probe-", "." + objectFileProvider.getObjectType().objectSuffix(), new FileAttribute[0]);
        Closeable c = ProbeUtil.deleting(path);
        try {
            Result result;
            block22: {
                inv.setOutputPath(path);
                if (errorReporter != null) {
                    inv.setMessageHandler(new ToolMessageHandler(){

                        public void handleMessage(ToolInvoker invoker, ToolMessageHandler.Level level, String file, int line, int column, String message) {
                            if (level == ToolMessageHandler.Level.ERROR) {
                                errorReporter.error(Location.builder().setSourceFilePath(file).setLineNumber(line).build(), "%s: %s", new Object[]{invoker.getTool().getToolName(), message});
                            } else if (level == ToolMessageHandler.Level.WARNING) {
                                errorReporter.warning(Location.builder().setSourceFilePath(file).setLineNumber(line).build(), "%s: %s", new Object[]{invoker.getTool().getToolName(), message});
                            } else if (level == ToolMessageHandler.Level.INFO) {
                                errorReporter.note(Location.builder().setSourceFilePath(file).setLineNumber(line).build(), "%s: %s", new Object[]{invoker.getTool().getToolName(), message});
                            }
                        }
                    });
                }
                try {
                    inv.invoke();
                }
                catch (CompilationFailureException e) {
                    Result result2 = null;
                    if (c != null) {
                        c.close();
                    }
                    return result2;
                }
                ObjectFile objectFile = objectFileProvider.openObjectFile(path);
                try {
                    int size;
                    int cnt = this.constants.size();
                    ByteOrder byteOrder = objectFile.getByteOrder();
                    HashMap<String, ConstantInfo> constantInfos = new HashMap<String, ConstantInfo>(cnt);
                    for (int i = 0; i < cnt; ++i) {
                        String name = this.constants.get(i);
                        boolean defined = objectFile.getSymbolValueAsByte("cp_is_defined" + i) != 0;
                        size = (int)objectFile.getSymbolValueAsLong("cp_size" + i);
                        boolean signed = objectFile.getSymbolValueAsByte("cp_is_signed" + i) != 0;
                        boolean unsigned = objectFile.getSymbolValueAsByte("cp_is_unsigned" + i) != 0;
                        boolean floating = objectFile.getSymbolValueAsByte("cp_is_floating" + i) != 0;
                        boolean bool = objectFile.getSymbolValueAsByte("cp_is_bool" + i) != 0;
                        String symbol = objectFile.getRelocationSymbolForSymbolValue(name);
                        constantInfos.put(name, new ConstantInfo(defined, objectFile.getSymbolAsBytes("cp_value" + i, size), symbol, byteOrder, signed, unsigned, floating, bool));
                    }
                    cnt = this.functionNames.size();
                    HashMap<String, FunctionInfo> functionInfos = new HashMap<String, FunctionInfo>(cnt);
                    for (int i = 0; i < cnt; ++i) {
                        String name = this.functionNames.get(i);
                        size = (int)objectFile.getSymbolValueAsLong("fn_name_size" + i) - 1;
                        String stringValue = objectFile.getSymbolValueAsUtfString("fn_name" + i, size);
                        functionInfos.put(name, new FunctionInfo(stringValue));
                    }
                    cnt = this.types.size();
                    HashMap<Type, Type.Info> typeInfos = new HashMap<Type, Type.Info>(cnt);
                    HashMap<Type, Map<String, Type.Info>> memberInfos = new HashMap<Type, Map<String, Type.Info>>();
                    for (int i = 0; i < cnt; ++i) {
                        Type type = this.types.get(i);
                        long overallSize = objectFile.getSymbolValueAsLong("tp_overall_size" + i);
                        long overallAlign = objectFile.getSymbolValueAsLong("tp_overall_align" + i);
                        boolean signed = objectFile.getSymbolValueAsByte("tp_is_signed" + i) != 0;
                        boolean unsigned = objectFile.getSymbolValueAsByte("tp_is_unsigned" + i) != 0;
                        boolean floating = objectFile.getSymbolValueAsByte("tp_is_floating" + i) != 0;
                        Type.Info info = new Type.Info(overallSize, overallAlign, 0L, signed, unsigned, floating);
                        HashMap<String, Type.Info> memberInfo = new HashMap<String, Type.Info>(type.getMembers().size());
                        for (String memberName : type.getMembers()) {
                            long memberSize = objectFile.getSymbolValueAsLong("tp_sizeof_" + memberName + i);
                            long memberOffset = objectFile.getSymbolValueAsLong("tp_offsetof_" + memberName + i);
                            boolean memberSigned = objectFile.getSymbolValueAsByte("tp_is_signed_" + memberName + i) != 0;
                            boolean memberUnsigned = objectFile.getSymbolValueAsByte("tp_is_unsigned_" + memberName + i) != 0;
                            boolean memberFloating = objectFile.getSymbolValueAsByte("tp_is_floating_" + memberName + i) != 0;
                            memberInfo.put(memberName, new Type.Info(memberSize, 0L, memberOffset, memberSigned, memberUnsigned, memberFloating));
                        }
                        typeInfos.put(type, info);
                        memberInfos.put(type, memberInfo);
                    }
                    result = new Result(typeInfos, memberInfos, functionInfos, constantInfos, byteOrder);
                    if (objectFile == null) break block22;
                }
                catch (Throwable throwable) {
                    if (objectFile != null) {
                        try {
                            objectFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                objectFile.close();
            }
            return result;
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable3;
                    throwable3.addSuppressed(throwable);
                }
            }
        }
    }

    public static final class Builder {
        private final List<Step> items = new ArrayList<Step>();
        private final List<Type> types = new ArrayList<Type>();
        private final List<String> constants = new ArrayList<String>();
        private final Map<String, Type> constantTypes = new HashMap<String, Type>();
        private final List<String> functionNames = new ArrayList<String>();

        Builder() {
            this.include("<stddef.h>");
            this.include("<limits.h>");
        }

        public Builder include(String include) {
            if (include.startsWith("<") && include.endsWith(">")) {
                this.items.add(new Include(include.substring(1, include.length() - 1), false));
            } else {
                this.items.add(new Include(include, true));
            }
            return this;
        }

        public Builder define(String key) {
            this.items.add(new Define(key, null));
            return this;
        }

        public Builder define(String key, String value) {
            this.items.add(new Define(key, value));
            return this;
        }

        public Builder undef(String key) {
            this.items.add(new Undefine(key));
            return this;
        }

        public Builder line(int line, String file) {
            if (line > 0) {
                this.items.add(new Line(line, file));
            }
            return this;
        }

        public Builder line(int line) {
            return this.line(line, null);
        }

        public Builder probeType(Type type) {
            return this.probeType(type, null, 0);
        }

        public Builder probeType(Type type, String sourceFile, int line) {
            Assert.checkNotNullParam((String)"type", (Object)type);
            TypeStep typeStep = this.getTypeStepOf(type);
            int idx = this.types.size();
            ValueStep probeVal = this.deref(this.zeroPtrTo(typeStep));
            this.line(line, sourceFile);
            this.add(this.decl(NamedType.BOOL, "tp_is_signed", idx, this.isSigned(probeVal)));
            this.line(line, sourceFile);
            this.add(this.decl(NamedType.BOOL, "tp_is_unsigned", idx, this.isUnsigned(probeVal)));
            this.line(line, sourceFile);
            this.add(this.decl(NamedType.BOOL, "tp_is_floating", idx, this.isFloating(probeVal)));
            this.line(line, sourceFile);
            this.add(this.decl(NamedType.UNSIGNED_LONG, "tp_overall_size", idx, this.sizeof(typeStep)));
            this.line(line, sourceFile);
            this.add(this.decl(NamedType.UNSIGNED_LONG, "tp_overall_align", idx, this.alignof(typeStep)));
            for (String memberName : type.getMembers()) {
                this.line(line, sourceFile);
                ValueStep member = this.memberOf(typeStep, memberName);
                this.add(this.decl(NamedType.UNSIGNED_LONG, "tp_sizeof_" + memberName, idx, this.sizeof(member)));
                this.line(line, sourceFile);
                this.add(this.decl(NamedType.UNSIGNED_LONG, "tp_offsetof_" + memberName, idx, this.offsetOf(typeStep, memberName)));
                this.line(line, sourceFile);
                this.add(this.decl(NamedType.BOOL, "tp_is_signed_" + memberName, idx, this.isSigned(member)));
                this.line(line, sourceFile);
                this.add(this.decl(NamedType.BOOL, "tp_is_unsigned_" + memberName, idx, this.isUnsigned(member)));
                this.line(line, sourceFile);
                this.add(this.decl(NamedType.BOOL, "tp_is_floating_" + memberName, idx, this.isFloating(member)));
            }
            this.types.add(type);
            return this;
        }

        public Builder probeConstant(String name) {
            return this.probeConstant(name, null, 0);
        }

        public Builder probeConstant(String name, String sourceFile, int line) {
            return this.probeConstant(name, null, sourceFile, line);
        }

        public Builder probeConstant(String name, Type type, String sourceFile, int line) {
            Assert.checkNotNullParam((String)"name", (Object)name);
            int idx = this.constants.size();
            ValueStep symbol = this.identifier(name);
            this.if_(this.defined(symbol));
            this.line(line, sourceFile);
            this.add(this.decl(NamedType.BOOL, "cp_is_defined", idx, Number.ONE));
            TypeStep typeStep = this.typeof(symbol);
            this.else_();
            this.line(line, sourceFile);
            this.add(this.decl(NamedType.BOOL, "cp_is_defined", idx, Number.ZERO));
            this.endif();
            this.line(line, sourceFile);
            this.add(this.decl(typeStep, "cp_value", idx, type != null ? this.cast(symbol, typeStep) : symbol));
            this.line(line, sourceFile);
            this.add(this.decl(NamedType.UNSIGNED_LONG, "cp_size", idx, this.sizeof(symbol)));
            this.line(line, sourceFile);
            this.add(this.decl(NamedType.BOOL, "cp_is_signed", idx, this.isSigned(symbol)));
            this.line(line, sourceFile);
            this.add(this.decl(NamedType.BOOL, "cp_is_unsigned", idx, this.isUnsigned(symbol)));
            this.line(line, sourceFile);
            this.add(this.decl(NamedType.BOOL, "cp_is_floating", idx, this.isFloating(symbol)));
            this.line(line, sourceFile);
            this.add(this.decl(NamedType.BOOL, "cp_is_bool", idx, this.isBool(symbol)));
            this.constants.add(name);
            return this;
        }

        public Builder probeMacroFunctionName(String name, String sourceFile, int line) {
            Assert.checkNotNullParam((String)"name", (Object)name);
            int idx = this.functionNames.size();
            this.add(this.macro("QBICC_PASTE1", List.of("x"), "#x"));
            this.add(this.macro("QBICC_PASTE2", List.of("x"), "QBICC_PASTE1(x)"));
            Identifier fnName = new Identifier("fn_name" + idx);
            this.line(line, sourceFile);
            this.add(this.typedef(NamedType.CHAR, "char_array[]"));
            NamedType charArray = new NamedType("char_array");
            this.line(line, sourceFile);
            this.add(this.decl(charArray, "fn_name", idx, this.call("QBICC_PASTE2", this.call(name, null))));
            this.line(line, sourceFile);
            this.add(this.decl(NamedType.UNSIGNED_LONG, "fn_name_size", idx, this.sizeof(fnName)));
            this.functionNames.add(name);
            return this;
        }

        public CProbe build() {
            return new CProbe(this);
        }

        private TypeStep getTypeStepOf(Type type) {
            if (type.getQualifier() == Qualifier.NONE) {
                return this.namedType(type.getName());
            }
            if (type.getQualifier() == Qualifier.STRUCT) {
                return this.tagType(Tag.STRUCT, type.getName());
            }
            assert (type.getQualifier() == Qualifier.UNION);
            return this.tagType(Tag.UNION, type.getName());
        }

        Step add(Step step) {
            this.items.add(step);
            return step;
        }

        void if_(ValueStep cond) {
            this.items.add(new If(cond));
        }

        void elsif(ValueStep cond) {
            this.items.add(new ElsIf(cond));
        }

        void else_() {
            this.items.add(SimplePreProc.ELSE);
        }

        void endif() {
            this.items.add(SimplePreProc.ENDIF);
        }

        Step typedef(TypeStep type, String alias) {
            return new Typedef(type, alias);
        }

        Step decl(TypeStep type, String name, int idx, ValueStep value) {
            return new Decl(type, name, idx, value);
        }

        Step decl(TypeStep type, String name, ValueStep value) {
            return new Decl(type, name, -1, value);
        }

        Step macro(String key, List<String> arguments, String value) {
            return new Define(key, arguments, value);
        }

        <T extends Step> ListOf<T> listOf(List<T> items) {
            return new ListOf<T>(items);
        }

        TypeStep ptrTo(TypeStep type) {
            return new PtrTo(type);
        }

        TypeStep arrayOf(TypeStep type) {
            return new ArrayOf(type);
        }

        ValueStep addrOf(ValueStep value) {
            return new AddrOf(value);
        }

        ValueStep deref(ValueStep value) {
            return new Deref(value);
        }

        ValueStep cast(ValueStep value, TypeStep toType) {
            return new Cast(value, toType);
        }

        ValueStep number(int number) {
            return new Number(number);
        }

        TypeStep namedType(String name) {
            return new NamedType(name);
        }

        TypeStep tagType(Tag tag, String name) {
            return new TagType(tag, name);
        }

        ValueStep generic(ValueStep object, ListOf<AssocItem> assocList) {
            return new Generic(object, assocList);
        }

        ValueStep eq(ValueStep v1, ValueStep v2) {
            return new Eq(v1, v2);
        }

        ValueStep call(String name, Step arg) {
            return new SimpleCall(name, arg);
        }

        ValueStep memberOfPtr(ValueStep ptr, String name) {
            return new MemberOfPtr(ptr, name);
        }

        ValueStep offsetOf(TypeStep compound, String name) {
            return new OffsetOf(compound, name);
        }

        AssocItem assocItem(TypeStep type, ValueStep expr) {
            return new AssocItem(type, expr);
        }

        ValueStep isDefined(ValueStep expr) {
            return new IfDefined(expr);
        }

        ValueStep isDefined(ValueStep expr, ValueStep trueVal, ValueStep falseVal) {
            return new IfDefined(expr, trueVal, falseVal);
        }

        ValueStep zeroStruct() {
            return ZeroStruct.INSTANCE;
        }

        ValueStep identifier(String identifier) {
            return new Identifier(identifier);
        }

        TypeStep typeof(ValueStep object) {
            return new TypeOf(object);
        }

        ValueStep zeroPtrTo(TypeStep type) {
            return this.cast(Number.ZERO, this.ptrTo(type));
        }

        ValueStep memberOf(TypeStep type, String name) {
            return this.memberOfPtr(this.zeroPtrTo(type), name);
        }

        ValueStep sizeof(Step object) {
            return this.call("sizeof", object);
        }

        ValueStep alignof(Step object) {
            return this.call("_Alignof", object);
        }

        ValueStep defined(ValueStep expr) {
            return this.call("defined", expr);
        }

        ValueStep isFloating(ValueStep expr) {
            return this.generic(expr, this.listOf(List.of(this.assocItem(NamedType.FLOAT, Number.ONE), this.assocItem(NamedType.DOUBLE, Number.ONE), this.assocItem(NamedType.LONG_DOUBLE, Number.ONE), this.assocItem(NamedType.DEFAULT, Number.ZERO))));
        }

        ValueStep isUnsigned(ValueStep expr) {
            return this.generic(expr, this.listOf(List.of(this.assocItem(NamedType.CHAR, this.eq(Identifier.CHAR_MIN, Number.ZERO)), this.assocItem(NamedType.UNSIGNED_CHAR, Number.ONE), this.assocItem(NamedType.UNSIGNED_SHORT, Number.ONE), this.assocItem(NamedType.UNSIGNED_INT, Number.ONE), this.assocItem(NamedType.UNSIGNED_LONG, Number.ONE), this.assocItem(NamedType.UNSIGNED_LONG_LONG, Number.ONE), this.assocItem(NamedType.DEFAULT, Number.ZERO))));
        }

        ValueStep isSigned(ValueStep expr) {
            return this.generic(expr, this.listOf(List.of(this.assocItem(NamedType.CHAR, this.eq(Identifier.CHAR_MIN, Identifier.SCHAR_MIN)), this.assocItem(NamedType.SIGNED_CHAR, Number.ONE), this.assocItem(NamedType.SIGNED_SHORT, Number.ONE), this.assocItem(NamedType.SIGNED_INT, Number.ONE), this.assocItem(NamedType.SIGNED_LONG, Number.ONE), this.assocItem(NamedType.SIGNED_LONG_LONG, Number.ONE), this.assocItem(NamedType.DEFAULT, Number.ZERO))));
        }

        ValueStep isBool(ValueStep expr) {
            return this.generic(expr, this.listOf(List.of(this.assocItem(NamedType.BOOL, Number.ONE), this.assocItem(NamedType.DEFAULT, Number.ZERO))));
        }
    }

    static abstract class Step {
        Step() {
        }

        abstract StringBuilder appendTo(StringBuilder var1);

        final StringBuilder nl(StringBuilder b) {
            return b.append(System.lineSeparator());
        }
    }

    public static final class ConstantInfo {
        private final boolean defined;
        private final byte[] value;
        private final String symbol;
        private final ByteOrder byteOrder;
        private final boolean signed;
        private final boolean unsigned;
        private final boolean floating;
        private final boolean bool;

        ConstantInfo(boolean defined, byte[] value, String symbol, ByteOrder byteOrder, boolean signed, boolean unsigned, boolean floating, boolean bool) {
            this.defined = defined;
            this.value = value;
            this.symbol = symbol;
            this.byteOrder = byteOrder;
            this.signed = signed;
            this.unsigned = unsigned;
            this.floating = floating;
            this.bool = bool;
        }

        public boolean isDefined() {
            return this.defined;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public byte[] getValue() {
            return this.value;
        }

        public boolean hasSymbol() {
            return this.symbol != null;
        }

        public int getSize() {
            return this.value.length;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public int getValueAsInt() {
            return (int)this.getValueAsUnsignedLong();
        }

        public long getValueAsSignedLong() {
            ByteBuffer buf = ByteBuffer.wrap(this.value).order(this.byteOrder);
            if (buf.remaining() >= 8) {
                return buf.getLong();
            }
            if (buf.remaining() >= 4) {
                return buf.getInt();
            }
            if (buf.remaining() >= 2) {
                return buf.getShort();
            }
            if (buf.remaining() >= 1) {
                return buf.get();
            }
            return 0L;
        }

        public long getValueAsUnsignedLong() {
            ByteBuffer buf = ByteBuffer.wrap(this.value).order(this.byteOrder);
            if (buf.remaining() >= 8) {
                return buf.getLong();
            }
            if (buf.remaining() >= 4) {
                return (long)buf.getInt() & 0xFFFFFFFFL;
            }
            if (buf.remaining() >= 2) {
                return buf.getShort() & 0xFFFF;
            }
            if (buf.remaining() >= 1) {
                return buf.get() & 0xFF;
            }
            return 0L;
        }

        public Literal getValueAsLiteralOfType(TypeSystem ts, LiteralFactory lf, ValueType valueType) {
            if (valueType instanceof SignedIntegerType) {
                SignedIntegerType sit = (SignedIntegerType)valueType;
                return lf.literalOf((IntegerType)sit, this.getValueAsSignedLong());
            }
            if (valueType instanceof UnsignedIntegerType) {
                UnsignedIntegerType uit = (UnsignedIntegerType)valueType;
                return lf.literalOf((IntegerType)uit, this.getValueAsUnsignedLong());
            }
            if (valueType instanceof BooleanType) {
                return lf.literalOf(this.getValueAsUnsignedLong() != 0L);
            }
            if (valueType instanceof ArrayType) {
                ArrayType at = (ArrayType)valueType;
                return lf.literalOf(at, this.value);
            }
            if (valueType instanceof PointerType) {
                PointerType pt = (PointerType)valueType;
                if (this.hasSymbol()) {
                    throw new UnsupportedOperationException("TODO: pointer values with a symbol base");
                }
                return lf.bitcastLiteral((Literal)lf.literalOf((IntegerType)pt.getSameSizedSignedInteger(), this.getValueAsSignedLong()), (WordType)pt);
            }
            ValueType naturalType = this.getValueType(ts);
            if (naturalType != valueType) {
                return this.getValueAsLiteralOfType(ts, lf, naturalType);
            }
            throw new IllegalArgumentException("Invalid constant type");
        }

        public Literal getValueAsLiteral(TypeSystem ts, LiteralFactory lf) {
            return this.getValueAsLiteralOfType(ts, lf, this.getValueType(ts));
        }

        public ValueType getValueType(TypeSystem ts) {
            int size = this.value.length;
            if (this.signed) {
                if (size == 1) {
                    return ts.getSignedInteger8Type();
                }
                if (size == 2) {
                    return ts.getSignedInteger16Type();
                }
                if (size == 4) {
                    return ts.getSignedInteger32Type();
                }
                if (size == 8) {
                    return ts.getSignedInteger64Type();
                }
            } else if (this.unsigned) {
                if (size == 1) {
                    return ts.getUnsignedInteger8Type();
                }
                if (size == 2) {
                    return ts.getUnsignedInteger16Type();
                }
                if (size == 4) {
                    return ts.getUnsignedInteger32Type();
                }
                if (size == 8) {
                    return ts.getUnsignedInteger64Type();
                }
            } else if (this.floating) {
                if (size == 4) {
                    return ts.getFloat32Type();
                }
                if (size == 8) {
                    return ts.getFloat64Type();
                }
            } else {
                if (this.bool) {
                    return ts.getBooleanType();
                }
                return ts.getArrayType((ValueType)ts.getUnsignedInteger8Type(), (long)size);
            }
            throw new IllegalArgumentException("Unable to determine type of constant");
        }
    }

    public static final class FunctionInfo {
        private final String resolvedName;

        FunctionInfo(String resolvedName) {
            this.resolvedName = resolvedName;
        }

        public String getResolvedName() {
            Pattern namePattern = Pattern.compile("([a-zA-Z_][a-zA-Z_0-9]*)[(][)]");
            Matcher matcher = namePattern.matcher(this.resolvedName);
            if (!matcher.matches()) {
                return null;
            }
            return matcher.group(1);
        }
    }

    public static final class Type {
        private final String name;
        private final Qualifier qualifier;
        private final List<String> members;
        private final int hashCode;

        Type(Builder builder) {
            this.name = (String)Assert.checkNotNullParam((String)"builder.name", (Object)builder.name);
            this.qualifier = builder.qualifier;
            List<String> members = builder.members;
            this.members = members != null ? List.copyOf(builder.members) : List.of();
            this.hashCode = Objects.hash(new Object[]{this.name, this.qualifier, members});
        }

        public String getName() {
            return this.name;
        }

        public Qualifier getQualifier() {
            return this.qualifier;
        }

        public List<String> getMembers() {
            return this.members;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            return obj instanceof Type && this.equals((Type)obj);
        }

        public boolean equals(Type other) {
            return this == other || other != null && this.hashCode == other.hashCode && this.name.equals(other.name) && this.qualifier == other.qualifier && this.members.equals(other.members);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String name;
            private Qualifier qualifier = Qualifier.NONE;
            private List<String> members;

            Builder() {
            }

            public String getName() {
                return this.name;
            }

            public Builder setName(String name) {
                this.name = (String)Assert.checkNotNullParam((String)"name", (Object)name);
                return this;
            }

            public Qualifier getQualifier() {
                return this.qualifier;
            }

            public Builder setQualifier(Qualifier qualifier) {
                this.qualifier = (Qualifier)((Object)Assert.checkNotNullParam((String)"qualifier", (Object)((Object)qualifier)));
                return this;
            }

            public Builder addMember(String name) {
                List<String> members = this.members;
                if (members == null) {
                    this.members = members = new ArrayList<String>();
                }
                members.add(name);
                return this;
            }

            public Type build() {
                return new Type(this);
            }
        }

        public static final class Info {
            private final long size;
            private final long align;
            private final long offset;
            private final boolean signed;
            private final boolean unsigned;
            private final boolean floating;

            Info(long size, long align, long offset, boolean signed, boolean unsigned, boolean floating) {
                this.size = size;
                this.align = align;
                this.offset = offset;
                this.signed = signed;
                this.unsigned = unsigned;
                this.floating = floating;
            }

            public long getSize() {
                return this.size;
            }

            public long getAlign() {
                return this.align;
            }

            public long getOffset() {
                return this.offset;
            }

            public boolean isSigned() {
                return this.signed;
            }

            public boolean isUnsigned() {
                return this.unsigned;
            }

            public boolean isFloating() {
                return this.floating;
            }
        }
    }

    public static final class Result {
        private final Map<Type, Type.Info> typeInfos;
        private final Map<Type, Map<String, Type.Info>> memberInfos;
        private final Map<String, FunctionInfo> functionInfos;
        private final Map<String, ConstantInfo> constantInfos;
        private final ByteOrder byteOrder;

        Result(Map<Type, Type.Info> typeInfos, Map<Type, Map<String, Type.Info>> memberInfos, Map<String, FunctionInfo> functionInfos, Map<String, ConstantInfo> constantInfos, ByteOrder byteOrder) {
            this.typeInfos = typeInfos;
            this.memberInfos = memberInfos;
            this.functionInfos = functionInfos;
            this.constantInfos = constantInfos;
            this.byteOrder = byteOrder;
        }

        public Type.Info getTypeInfo(Type type) throws NoSuchElementException {
            Type.Info info = this.typeInfos.get(type);
            if (info == null) {
                throw new NoSuchElementException();
            }
            return info;
        }

        public Type.Info getTypeInfoOfMember(Type type, String memberName) throws NoSuchElementException {
            Map<String, Type.Info> map = this.memberInfos.get(type);
            if (map == null) {
                throw new NoSuchElementException();
            }
            Type.Info info = map.get(memberName);
            if (info == null) {
                throw new NoSuchElementException();
            }
            return info;
        }

        public FunctionInfo getFunctionInfo(String funcName) throws NoSuchElementException {
            FunctionInfo val = this.functionInfos.get(funcName);
            if (val == null) {
                throw new NoSuchElementException();
            }
            return val;
        }

        public ConstantInfo getConstantInfo(String constant) throws NoSuchElementException {
            ConstantInfo val = this.constantInfos.get(constant);
            if (val == null) {
                throw new NoSuchElementException();
            }
            return val;
        }

        public ByteOrder getByteOrder() {
            return this.byteOrder;
        }
    }

    static abstract class SubProbe
    extends Step {
        SubProbe() {
        }
    }

    static final class Decl
    extends Step {
        private final TypeStep type;
        private final String name;
        private final int index;
        private final ValueStep value;

        Decl(TypeStep type, String name, int index, ValueStep value) {
            this.type = type;
            this.name = name;
            this.index = index;
            this.value = value;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            this.type.appendTo(b).append(' ').append(this.name);
            if (this.index >= 0) {
                b.append(this.index);
            }
            if (this.type instanceof ArrayOf) {
                b.append("[]");
            }
            return this.nl(this.value.appendTo(b.append(' ').append('=').append(' ')).append(';'));
        }
    }

    static final class Typedef
    extends Step {
        private final TypeStep type;
        private final String alias;

        public Typedef(TypeStep type, String alias) {
            this.type = type;
            this.alias = alias;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.nl(this.type.appendTo(b.append("typedef").append(' ')).append(' ').append(this.alias).append(';'));
        }
    }

    static final class IfDefined
    extends ValueStep {
        private final ValueStep value;
        private final ValueStep trueVal;
        private final ValueStep falseVal;

        IfDefined(ValueStep value) {
            this(value, Number.ONE, Number.ZERO);
        }

        IfDefined(ValueStep value, ValueStep trueVal, ValueStep falseVal) {
            this.value = value;
            this.trueVal = trueVal;
            this.falseVal = falseVal;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            this.nl(b);
            b.append('#').append("if").append(' ').append("defined").append('(');
            this.value.appendTo(b);
            b.append(')');
            this.nl(b);
            this.trueVal.appendTo(b);
            this.nl(b);
            b.append('#').append("else");
            this.nl(b);
            this.falseVal.appendTo(b);
            this.nl(b);
            b.append('#').append("endif");
            this.nl(b);
            return b;
        }
    }

    static final class OffsetOf
    extends ValueStep {
        private final TypeStep type;
        private final String memberName;

        OffsetOf(TypeStep type, String memberName) {
            this.type = type;
            this.memberName = memberName;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.type.appendTo(b.append("offsetof").append('(')).append(',').append(this.memberName).append(')');
        }
    }

    static final class ZeroStruct
    extends ValueStep {
        static final ZeroStruct INSTANCE = new ZeroStruct();

        private ZeroStruct() {
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return b.append('{').append('0').append('}');
        }
    }

    static final class MemberOfPtr
    extends ValueStep {
        private final ValueStep value;
        private final String memberName;

        MemberOfPtr(ValueStep value, String memberName) {
            this.value = value;
            this.memberName = memberName;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.value.appendTo(b.append('(')).append("->").append(this.memberName).append(')');
        }
    }

    static final class Deref
    extends ValueStep {
        private final ValueStep value;

        Deref(ValueStep value) {
            this.value = value;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.value.appendTo(b.append('*').append('(')).append(')');
        }
    }

    static final class AddrOf
    extends ValueStep {
        private final ValueStep value;

        AddrOf(ValueStep value) {
            this.value = value;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.value.appendTo(b.append('&').append('(')).append(')');
        }
    }

    static final class TypeOf
    extends TypeStep {
        private final ValueStep value;

        TypeOf(ValueStep value) {
            this.value = value;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.value.appendTo(b.append("typeof").append('(')).append(')');
        }
    }

    static final class SimpleCall
    extends ValueStep {
        private final String name;
        private final Step value;

        SimpleCall(String name, Step value) {
            this.name = name;
            this.value = value;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            if (this.value == null) {
                return b.append(this.name).append('(').append(')');
            }
            return this.value.appendTo(b.append(this.name).append('(')).append(')');
        }
    }

    static final class Eq
    extends ValueStep {
        private final ValueStep v1;
        private final ValueStep v2;

        Eq(ValueStep v1, ValueStep v2) {
            this.v1 = v1;
            this.v2 = v2;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.v2.appendTo(this.v1.appendTo(b).append(' ').append("==").append(' '));
        }
    }

    static final class Generic
    extends ValueStep {
        private final ValueStep object;
        private final ListOf<AssocItem> items;

        Generic(ValueStep object, ListOf<AssocItem> items) {
            this.object = object;
            this.items = items;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.items.appendTo(this.object.appendTo(b.append("_Generic").append('(')).append(',')).append(')');
        }
    }

    static final class Cast
    extends ValueStep {
        private final ValueStep value;
        private final TypeStep toType;

        Cast(ValueStep value, TypeStep toType) {
            this.value = value;
            this.toType = toType;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.value.appendTo(this.toType.appendTo(b.append('(').append('(')).append(')')).append(')');
        }
    }

    static final class Identifier
    extends ValueStep {
        static final Identifier CHAR_MIN = new Identifier("CHAR_MIN");
        static final Identifier SCHAR_MIN = new Identifier("SCHAR_MIN");
        private final String name;

        Identifier(String name) {
            this.name = name;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return b.append(this.name);
        }
    }

    static final class Number
    extends ValueStep {
        static final Number ZERO = new Number(0L);
        static final Number ONE = new Number(1L);
        static final Number M_ONE = new Number(-1L);
        private final long val;

        Number(long val) {
            this.val = val;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return b.append(this.val);
        }
    }

    static abstract class ValueStep
    extends Step {
        ValueStep() {
        }
    }

    static final class ArrayOf
    extends TypeStep {
        private final TypeStep type;

        ArrayOf(TypeStep type) {
            this.type = type;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.type.appendTo(b).append(' ').append('[').append(']');
        }
    }

    static final class PtrTo
    extends TypeStep {
        private final TypeStep type;

        PtrTo(TypeStep type) {
            this.type = type;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.type.appendTo(b).append(' ').append('*');
        }
    }

    static enum Tag {
        STRUCT,
        UNION,
        ENUM;

        private final String str = this.name().toLowerCase(Locale.ROOT);

        public String toString() {
            return this.str;
        }
    }

    static final class TagType
    extends TypeStep {
        private final Tag tag;
        private final String name;

        TagType(Tag tag, String name) {
            this.tag = tag;
            this.name = name;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return b.append((Object)this.tag).append(' ').append(this.name);
        }
    }

    static final class NamedType
    extends TypeStep {
        static final NamedType DEFAULT = new NamedType("default");
        static final NamedType VOID = new NamedType("void");
        static final NamedType BOOL = new NamedType("_Bool");
        static final NamedType FLOAT = new NamedType("float");
        static final NamedType DOUBLE = new NamedType("double");
        static final NamedType LONG_DOUBLE = new NamedType("long double");
        static final NamedType CHAR = new NamedType("char");
        static final NamedType UNSIGNED_CHAR = new NamedType("unsigned char");
        static final NamedType UNSIGNED_SHORT = new NamedType("unsigned short");
        static final NamedType UNSIGNED_INT = new NamedType("unsigned int");
        static final NamedType UNSIGNED_LONG = new NamedType("unsigned long");
        static final NamedType UNSIGNED_LONG_LONG = new NamedType("unsigned long long");
        static final NamedType SIGNED_CHAR = new NamedType("signed char");
        static final NamedType SIGNED_SHORT = new NamedType("signed short");
        static final NamedType SIGNED_INT = new NamedType("signed int");
        static final NamedType SIGNED_LONG = new NamedType("signed long");
        static final NamedType SIGNED_LONG_LONG = new NamedType("signed long long");
        private final String name;

        NamedType(String name) {
            this.name = name;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return b.append(this.name);
        }
    }

    static abstract class TypeStep
    extends Step {
        TypeStep() {
        }
    }

    static final class AssocItem
    extends Step {
        private final Step type;
        private final ValueStep expr;

        AssocItem(Step type, ValueStep expr) {
            this.type = type;
            this.expr = expr;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.expr.appendTo(this.type.appendTo(b).append(':').append(' '));
        }
    }

    static final class ListOf<T extends Step>
    extends Step {
        private final List<T> steps;

        ListOf(List<T> steps) {
            this.steps = steps;
        }

        @SafeVarargs
        static <T extends Step> ListOf<T> steps(T ... step) {
            return new ListOf<T>(List.of(step));
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            Iterator<T> iterator = this.steps.iterator();
            if (iterator.hasNext()) {
                ((Step)iterator.next()).appendTo(b);
                while (iterator.hasNext()) {
                    ((Step)iterator.next()).appendTo(b.append(','));
                }
            }
            return b;
        }
    }

    static final class SimplePreProc
    extends PreProc {
        static final SimplePreProc ELSE = new SimplePreProc("else");
        static final SimplePreProc ENDIF = new SimplePreProc("endif");
        private final String keyWord;

        SimplePreProc(String keyWord) {
            this.keyWord = keyWord;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.nl(b.append('#').append(this.keyWord));
        }
    }

    static final class ElsIf
    extends PreProc {
        private final ValueStep cond;

        ElsIf(ValueStep cond) {
            this.cond = cond;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.nl(this.cond.appendTo(b.append('#').append("elsif").append(' ')));
        }
    }

    static final class If
    extends PreProc {
        private final ValueStep cond;

        If(ValueStep cond) {
            this.cond = cond;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.nl(this.cond.appendTo(b.append('#').append("if").append(' ')));
        }
    }

    static final class Line
    extends PreProc {
        private final int line;
        private final String file;

        Line(int line, String file) {
            this.line = line;
            this.file = file;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            b.append('#').append("line").append(' ').append(this.line);
            if (this.file != null) {
                b.append(' ').append('\"').append(this.file).append('\"');
            }
            return this.nl(b);
        }
    }

    static final class Undefine
    extends PreProc {
        private final String key;

        Undefine(String key) {
            this.key = key;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            b.append('#').append("if").append(' ').append("defined").append('(').append(this.key).append(')');
            this.nl(b);
            b.append('#').append("undef").append(' ').append(this.key);
            this.nl(b);
            b.append('#').append("endif");
            return this.nl(b);
        }
    }

    static final class Define
    extends PreProc {
        private final String key;
        private final List<String> arguments;
        private final String value;

        Define(String key, String value) {
            this(key, List.of(), value);
        }

        Define(String key, List<String> arguments, String value) {
            this.key = key;
            this.arguments = arguments;
            this.value = value;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            b.append('#').append("if").append(' ').append("defined").append('(').append(this.key).append(')');
            this.nl(b);
            b.append('#').append("undef").append(' ').append(this.key);
            this.nl(b);
            b.append('#').append("endif");
            this.nl(b);
            b.append('#').append("define").append(' ').append(this.key);
            Iterator<String> iterator = this.arguments.iterator();
            if (iterator.hasNext()) {
                b.append('(');
                b.append(iterator.next());
                while (iterator.hasNext()) {
                    b.append(',');
                    b.append(iterator.next());
                }
                b.append(')');
            }
            if (this.value != null && !this.value.isEmpty()) {
                b.append(' ').append(this.value);
            }
            return this.nl(b);
        }
    }

    static final class Include
    extends PreProc {
        private final String name;
        private final boolean quotes;

        Include(String name, boolean quotes) {
            this.name = name;
            this.quotes = quotes;
        }

        @Override
        StringBuilder appendTo(StringBuilder b) {
            return this.nl(b.append('#').append("include").append(' ').append(this.quotes ? (char)'\"' : '<').append(this.name).append(this.quotes ? (char)'\"' : '>'));
        }
    }

    static abstract class PreProc
    extends Step {
        PreProc() {
        }
    }
}

