/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.tool.llvm;

import io.smallrye.common.constraint.Assert;
import java.nio.file.Path;
import java.util.List;
import org.qbicc.machine.arch.Platform;
import org.qbicc.tool.llvm.AbstractLlvmInvoker;
import org.qbicc.tool.llvm.LlcInvoker;
import org.qbicc.tool.llvm.LlcOptLevel;
import org.qbicc.tool.llvm.LlvmToolChain;
import org.qbicc.tool.llvm.LlvmToolChainImpl;
import org.qbicc.tool.llvm.OutputFormat;
import org.qbicc.tool.llvm.RelocationModel;

final class LlcInvokerImpl
extends AbstractLlvmInvoker
implements LlcInvoker {
    private LlcOptLevel optLevel = LlcOptLevel.O2;
    private OutputFormat outputFormat = OutputFormat.OBJ;
    private RelocationModel relocationModel = RelocationModel.Static;

    LlcInvokerImpl(LlvmToolChainImpl tool, Path path) {
        super(tool, path);
    }

    @Override
    public LlvmToolChain getTool() {
        return super.getTool();
    }

    @Override
    public void setOptimizationLevel(LlcOptLevel level) {
        this.optLevel = (LlcOptLevel)((Object)Assert.checkNotNullParam((String)"level", (Object)((Object)level)));
    }

    @Override
    public LlcOptLevel getOptimizationLevel() {
        return this.optLevel;
    }

    @Override
    public void setOutputFormat(OutputFormat outputFormat) {
        this.outputFormat = (OutputFormat)((Object)Assert.checkNotNullParam((String)"outputFormat", (Object)((Object)outputFormat)));
    }

    @Override
    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    @Override
    public void setRelocationModel(RelocationModel relocationModel) {
        this.relocationModel = (RelocationModel)((Object)Assert.checkNotNullParam((String)"relocationModel", (Object)((Object)relocationModel)));
    }

    @Override
    public RelocationModel getRelocationModel() {
        return this.relocationModel;
    }

    @Override
    void addArguments(List<String> cmd) {
        Platform platform = this.getTool().getPlatform();
        cmd.add("-mtriple=" + platform.getCpu().toString() + "-" + platform.getOs().toString() + "-" + platform.getAbi().toString());
        cmd.add("--relocation-model=" + this.relocationModel.value);
        cmd.add("-" + this.optLevel.name());
        cmd.add("--filetype=" + this.outputFormat.toOptionString());
        if (platform.getCpu().getCpuWordSize() == 8) {
            cmd.add("--dwarf64");
        }
        cmd.add("--dwarf-version=4");
    }
}

