/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.tool.llvm;

import io.smallrye.common.version.VersionScheme;
import java.nio.file.Path;
import org.qbicc.machine.arch.Platform;
import org.qbicc.tool.llvm.LlcInvoker;
import org.qbicc.tool.llvm.LlcInvokerImpl;
import org.qbicc.tool.llvm.LlvmToolChain;
import org.qbicc.tool.llvm.OptInvoker;
import org.qbicc.tool.llvm.OptInvokerImpl;

final class LlvmToolChainImpl
implements LlvmToolChain {
    private final Path llcPath;
    private final Path optPath;
    private final Platform platform;
    private final String version;

    LlvmToolChainImpl(Path llcPath, Path optPath, Platform platform, String version) {
        this.llcPath = llcPath;
        this.optPath = optPath;
        this.platform = platform;
        this.version = version;
    }

    @Override
    public LlcInvoker newLlcInvoker() {
        return new LlcInvokerImpl(this, this.llcPath);
    }

    @Override
    public OptInvoker newOptInvoker() {
        return new OptInvokerImpl(this, this.optPath);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public String getVersion() {
        return this.version;
    }

    public int compareVersionTo(String version) {
        return VersionScheme.BASIC.compare(this.version, version);
    }
}

