/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.tool.llvm;

import io.smallrye.common.constraint.Assert;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.qbicc.machine.arch.Platform;
import org.qbicc.tool.llvm.AbstractLlvmInvoker;
import org.qbicc.tool.llvm.LlvmToolChain;
import org.qbicc.tool.llvm.LlvmToolChainImpl;
import org.qbicc.tool.llvm.OptInvoker;
import org.qbicc.tool.llvm.OptPass;

final class OptInvokerImpl
extends AbstractLlvmInvoker
implements OptInvoker {
    private List<OptPass> passes = new ArrayList<OptPass>();

    OptInvokerImpl(LlvmToolChainImpl tool, Path path) {
        super(tool, path);
    }

    @Override
    public LlvmToolChain getTool() {
        return super.getTool();
    }

    @Override
    void addArguments(List<String> cmd) {
        Platform platform = this.getTool().getPlatform();
        cmd.add("-mtriple=" + platform.getCpu().toString() + "-" + platform.getOs().toString() + "-" + platform.getAbi().toString());
        for (OptPass pass : this.passes) {
            cmd.add("-" + pass.name);
        }
    }

    @Override
    public void addOptimizationPass(OptPass pass) {
        this.passes.add((OptPass)((Object)Assert.checkNotNullParam((String)"pass", (Object)((Object)pass))));
    }
}

