/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.llvm;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayList;
import java.util.List;
import org.qbicc.machine.arch.Platform;
import org.qbicc.plugin.llvm.ReferenceStrategy;

public final class LLVMConfiguration {
    private final Platform platform;
    private final int majorVersion;
    private final boolean pie;
    private final boolean statepointEnabled;
    private final boolean emitIr;
    private final boolean emitAssembly;
    private final boolean compileOutput;
    private final boolean opaquePointers;
    private final List<String> llcOptions;
    private final ReferenceStrategy referenceStrategy;

    LLVMConfiguration(Builder builder) {
        this.platform = (Platform)Assert.checkNotNullParam((String)"builder.platform", (Object)builder.platform);
        this.majorVersion = builder.majorVersion;
        this.pie = builder.pie;
        this.statepointEnabled = builder.statepointEnabled;
        this.emitIr = builder.emitIr;
        this.emitAssembly = builder.emitAssembly;
        List<String> builderLlcOptions = builder.llcOptions;
        this.llcOptions = builderLlcOptions == null ? List.of() : List.copyOf(builder.llcOptions);
        this.compileOutput = builder.compileOutput;
        this.opaquePointers = builder.opaquePointers;
        this.referenceStrategy = builder.referenceStrategy;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public boolean isWasm() {
        return this.getPlatform().isWasm();
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public boolean isPie() {
        return this.pie;
    }

    public boolean isStatepointEnabled() {
        return this.statepointEnabled;
    }

    public boolean isEmitIr() {
        return this.emitIr;
    }

    public boolean isEmitAssembly() {
        return this.emitAssembly;
    }

    public boolean isCompileOutput() {
        return this.compileOutput;
    }

    public boolean isOpaquePointers() {
        return this.opaquePointers;
    }

    public List<String> getLlcOptions() {
        return this.llcOptions;
    }

    public ReferenceStrategy getReferenceStrategy() {
        return this.referenceStrategy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Platform platform;
        private int majorVersion = 12;
        private boolean pie = true;
        private boolean statepointEnabled = true;
        private boolean emitIr;
        private boolean emitAssembly;
        private boolean compileOutput;
        private boolean opaquePointers;
        private List<String> llcOptions;
        private ReferenceStrategy referenceStrategy = ReferenceStrategy.POINTER_AS1;

        Builder() {
        }

        public Platform getPlatform() {
            return this.platform;
        }

        public Builder setPlatform(Platform platform) {
            Assert.checkNotNullParam((String)"platform", (Object)platform);
            this.platform = platform;
            return this;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public Builder setMajorVersion(int majorVersion) {
            this.majorVersion = majorVersion;
            if (majorVersion >= 16) {
                this.opaquePointers = true;
            }
            return this;
        }

        public boolean isPie() {
            return this.pie;
        }

        public Builder setPie(boolean pie) {
            this.pie = pie;
            return this;
        }

        public boolean isStatepointEnabled() {
            return this.statepointEnabled;
        }

        public Builder setStatepointEnabled(boolean statepointEnabled) {
            this.statepointEnabled = statepointEnabled;
            return this;
        }

        public boolean isEmitIr() {
            return this.emitIr;
        }

        public Builder setEmitIr(boolean emitIr) {
            this.emitIr = emitIr;
            return this;
        }

        public boolean isEmitAssembly() {
            return this.emitAssembly;
        }

        public Builder setEmitAssembly(boolean emitAssembly) {
            this.emitAssembly = emitAssembly;
            return this;
        }

        public boolean isCompileOutput() {
            return this.compileOutput;
        }

        public Builder setCompileOutput(boolean compileOutput) {
            this.compileOutput = compileOutput;
            return this;
        }

        public boolean isOpaquePointers() {
            return this.opaquePointers;
        }

        public Builder setOpaquePointers(boolean opaquePointers) {
            if (this.majorVersion < 16) {
                this.opaquePointers = opaquePointers;
            }
            return this;
        }

        public Builder addLlcOption(String option) {
            Assert.checkNotNullParam((String)"option", (Object)option);
            if (this.llcOptions == null) {
                this.llcOptions = new ArrayList<String>();
            }
            this.llcOptions.add(option);
            return this;
        }

        public Builder addLlcOptions(List<String> options) {
            Assert.checkNotNullParam((String)"options", options);
            if (this.llcOptions == null) {
                this.llcOptions = new ArrayList<String>();
            }
            this.llcOptions.addAll(options);
            return this;
        }

        public ReferenceStrategy getReferenceStrategy() {
            return this.referenceStrategy;
        }

        public Builder setReferenceStrategy(ReferenceStrategy referenceStrategy) {
            this.referenceStrategy = referenceStrategy;
            return this;
        }

        public LLVMConfiguration build() {
            return new LLVMConfiguration(this);
        }
    }
}

