/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.llvm;

import io.smallrye.common.constraint.Assert;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.qbicc.context.CompilationContext;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.Module;
import org.qbicc.machine.llvm.ModuleFlagBehavior;
import org.qbicc.machine.llvm.Types;
import org.qbicc.machine.llvm.Values;
import org.qbicc.machine.llvm.debuginfo.DICompositeType;
import org.qbicc.machine.llvm.debuginfo.DIDerivedType;
import org.qbicc.machine.llvm.debuginfo.DIEncoding;
import org.qbicc.machine.llvm.debuginfo.DIFlags;
import org.qbicc.machine.llvm.debuginfo.DISubprogram;
import org.qbicc.machine.llvm.debuginfo.DITag;
import org.qbicc.machine.llvm.debuginfo.DebugEmissionKind;
import org.qbicc.machine.llvm.debuginfo.MetadataNode;
import org.qbicc.machine.llvm.debuginfo.MetadataTuple;
import org.qbicc.object.Data;
import org.qbicc.object.Function;
import org.qbicc.object.ProgramModule;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.layout.Layout;
import org.qbicc.plugin.layout.LayoutInfo;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.ArrayType;
import org.qbicc.type.BooleanType;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.FloatType;
import org.qbicc.type.FunctionType;
import org.qbicc.type.InvokableType;
import org.qbicc.type.MethodType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.Type;
import org.qbicc.type.TypeType;
import org.qbicc.type.UnresolvedType;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.VoidType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.FunctionElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.MemberElement;
import org.qbicc.type.definition.element.MethodElement;

final class LLVMModuleDebugInfo {
    private final Module module;
    private final CompilationContext ctxt;
    private final LLValue diCompileUnit;
    private final Map<ExecutableElement, MethodDebugInfo> methods = new HashMap<ExecutableElement, MethodDebugInfo>();
    private final Map<Type, LLValue> types = new HashMap<Type, LLValue>();
    private final Map<LocationKey, LLValue> locations = new HashMap<LocationKey, LLValue>();
    private final Map<String, LLValue> files = new HashMap<String, LLValue>();
    private final LLValue file;
    private final MetadataTuple globals;

    LLVMModuleDebugInfo(ProgramModule programModule, Module module, CompilationContext ctxt) {
        Object fileName;
        String dirName;
        this.module = module;
        this.ctxt = ctxt;
        module.addFlag(ModuleFlagBehavior.Warning, "Debug Info Version", Types.i32, Values.intConstant((int)3));
        module.addFlag(ModuleFlagBehavior.Warning, "Dwarf Version", Types.i32, Values.intConstant((int)4));
        module.metadataTuple("llvm.ident").elem(null, module.metadataTuple().elem(null, Values.metadataString((String)"qbicc")).asRef());
        DefinedTypeDefinition typeDefinition = programModule.getTypeDefinition();
        String fullPath = typeDefinition.getInternalName() + ".java";
        int idx = fullPath.lastIndexOf(47);
        if (idx == -1) {
            dirName = "";
            fileName = fullPath;
        } else {
            dirName = fullPath.substring(0, idx);
            fileName = fullPath.substring(idx + 1);
        }
        this.file = module.diFile((String)fileName, dirName).asRef();
        this.globals = module.metadataTuple();
        this.diCompileUnit = module.diCompileUnit("DW_LANG_C_plus_plus", this.file, DebugEmissionKind.FullDebug).producer("qbicc").globals(this.globals.asRef()).asRef();
    }

    private String getFriendlyName(ExecutableElement element) {
        StringBuilder b = new StringBuilder();
        b.append(element.getEnclosingType().getInternalName().replace('/', '.'));
        b.append('.');
        if (element instanceof InitializerElement) {
            b.append("<clinit>");
        } else if (element instanceof ConstructorElement) {
            b.append("<init>");
        } else if (element instanceof MethodElement) {
            b.append(((MethodElement)element).getName());
        } else if (element instanceof FunctionElement) {
            b.append(((FunctionElement)element).getName());
        } else {
            throw new UnsupportedOperationException("Unrecognized element " + element.toString());
        }
        return b.toString();
    }

    public LLValue createSourceFile(Element element) {
        String sourceFileNameFull = element.getSourceFileName();
        LLValue file = this.files.get(sourceFileNameFull);
        if (file != null) {
            return file;
        }
        String sourceFileName = sourceFileNameFull;
        String sourceFileDirectory = "";
        if (sourceFileName != null) {
            String typeName = element.getEnclosingType().getInternalName();
            int typeNamePackageEnd = typeName.lastIndexOf(47);
            if (typeNamePackageEnd != -1) {
                sourceFileDirectory = typeName.substring(0, typeNamePackageEnd);
            }
        } else {
            sourceFileName = "<unknown>";
        }
        file = this.module.diFile(sourceFileName, sourceFileDirectory).asRef();
        this.files.put(sourceFileNameFull, file);
        return file;
    }

    private MethodDebugInfo createDebugInfoForFunction(ExecutableElement element) {
        Function exactFunction = this.ctxt.getExactFunctionIfExists(element);
        LLValue type = this.getType((Type)exactFunction.getValueType());
        int line = element.getMinimumLineNumber();
        DISubprogram diSubprogram = this.module.diSubprogram(this.getFriendlyName(element), type, this.diCompileUnit).location(this.createSourceFile((Element)element), line, line);
        if (exactFunction != null) {
            diSubprogram.linkageName(exactFunction.getName());
        }
        MethodDebugInfo debugInfo = new MethodDebugInfo(diSubprogram.asRef());
        this.methods.put(element, debugInfo);
        return debugInfo;
    }

    public DISubprogram createThunkSubprogram(Function function) {
        LLValue type = this.getType((Type)function.getSymbolType());
        int line = function.getOriginalElement().getMinimumLineNumber();
        return this.module.diSubprogram(function.getName(), type, this.diCompileUnit).location(this.createSourceFile((Element)function.getOriginalElement()), line, line).linkageName(function.getName());
    }

    public MethodDebugInfo getDebugInfoForFunction(ExecutableElement element) {
        MethodDebugInfo debugInfo = this.methods.get(element);
        if (debugInfo == null) {
            debugInfo = this.createDebugInfoForFunction(element);
        }
        return debugInfo;
    }

    private LLValue registerType(Type type, MetadataNode debugInfo) {
        LLValue ref = debugInfo.asRef();
        this.types.put(type, ref);
        return ref;
    }

    private LLValue createBasicType(ValueType type, DIEncoding encoding) {
        return this.registerType((Type)type, (MetadataNode)this.module.diBasicType(encoding, type.getSize() * 8L, type.getAlign() * 8).name(type.toFriendlyString()));
    }

    private LLValue createPointerType(ValueType type, Type toType) {
        LLValue toTypeDbg = null;
        if (!(toType instanceof VoidType)) {
            toTypeDbg = this.getType(toType);
        }
        return this.registerType((Type)type, (MetadataNode)this.module.diDerivedType(DITag.PointerType, type.getSize() * 8L, type.getAlign() * 8).baseType(toTypeDbg));
    }

    private MetadataTuple populateCompoundType(CompoundType type, DICompositeType diType, Set<CompoundType.Member> excludeMembers) {
        MetadataTuple elements = this.module.metadataTuple();
        diType.elements(elements.asRef());
        for (CompoundType.Member m : type.getMembers()) {
            if (excludeMembers.contains(m)) continue;
            ValueType mt = m.getType();
            elements.elem(null, this.module.diDerivedType(DITag.Member, mt.getSize() * 8L, mt.getAlign() * 8).name(m.getName()).baseType(this.getType((Type)mt)).offset((long)m.getOffset() * 8L).asRef());
        }
        return elements;
    }

    private LLValue createCompoundType(CompoundType type) {
        DICompositeType diType = this.module.diCompositeType(DITag.StructureType, type.getSize() * 8L, type.getAlign() * 8).name(type.toFriendlyString());
        LLValue result = this.registerType((Type)type, (MetadataNode)diType);
        this.populateCompoundType(type, diType, Set.of());
        return result;
    }

    private LLValue createFunctionType(FunctionType type) {
        MetadataTuple types = this.module.metadataTuple();
        LLValue result = this.registerType((Type)type, (MetadataNode)this.module.diSubroutineType(types.asRef()));
        if (type.getReturnType() instanceof VoidType) {
            types.elem(null, null);
        } else {
            types.elem(null, this.getType((Type)type.getReturnType()));
        }
        for (int i = 0; i < type.getParameterCount(); ++i) {
            types.elem(null, this.getType((Type)type.getParameterType(i)));
        }
        return result;
    }

    private LLValue createPhysicalObjectType(PhysicalObjectType type, LayoutInfo instanceLayoutInfo, CompoundType compoundType) {
        Set<Object> exclude;
        ClassObjectType cot;
        DICompositeType diType = this.module.diCompositeType(DITag.ClassType, compoundType.getSize() * 8L, compoundType.getAlign() * 8).name(type.toFriendlyString());
        if (!(type instanceof ClassObjectType) || (cot = (ClassObjectType)type).getDefinition().isPublic()) {
            diType.flags(EnumSet.of(DIFlags.Public));
        }
        LLValue result = this.registerType((Type)type, (MetadataNode)diType);
        if (type.hasSuperClass()) {
            ClassObjectType superType = type.getSuperClassType();
            CompoundType superCompoundType = Layout.get((CompilationContext)this.ctxt).getInstanceLayoutInfo(superType.getDefinition()).getCompoundType();
            exclude = Set.of((CompoundType.Member[])superCompoundType.getMembers().toArray(CompoundType.Member[]::new));
        } else {
            exclude = Set.of();
        }
        MetadataTuple elements = this.module.metadataTuple();
        diType.elements(elements.asRef());
        for (FieldElement fieldElement : instanceLayoutInfo.getFieldsMap().keySet()) {
            CompoundType.Member member = instanceLayoutInfo.getMember(fieldElement);
            if (exclude.contains(member)) continue;
            ValueType mt = fieldElement.getType();
            DIFlags access = fieldElement.isPublic() ? DIFlags.Public : (fieldElement.isPrivate() ? DIFlags.Private : (fieldElement.isProtected() ? DIFlags.Protected : null));
            DIDerivedType derivedType = this.module.diDerivedType(DITag.Member, mt.getSize() * 8L, mt.getAlign() * 8).name(member.getName()).baseType(this.getType((Type)mt)).offset((long)member.getOffset() * 8L);
            if (access != null) {
                derivedType.flags(EnumSet.of(access));
            }
            elements.elem(null, derivedType.asRef());
        }
        if (type.hasSuperClass()) {
            ClassObjectType superType = type.getSuperClassType();
            CompoundType superCompoundType = Layout.get((CompilationContext)this.ctxt).getInstanceLayoutInfo(superType.getDefinition()).getCompoundType();
            LLValue superDiType = this.getType((Type)superType);
            elements.elem(null, this.module.diDerivedType(DITag.Inheritance, superCompoundType.getSize() * 8L, superCompoundType.getAlign() * 8).baseType(superDiType).offset(0L).flags(EnumSet.of(DIFlags.Public, DIFlags.SingleInheritance)).asRef());
        }
        return result;
    }

    private LLValue createClassObjectType(ClassObjectType type) {
        LayoutInfo instanceLayoutInfo = Layout.get((CompilationContext)this.ctxt).getInstanceLayoutInfo(type.getDefinition());
        CompoundType compoundType = instanceLayoutInfo.getCompoundType();
        return this.createPhysicalObjectType((PhysicalObjectType)type, instanceLayoutInfo, compoundType);
    }

    private LLValue createArrayObjectType(ArrayObjectType type) {
        LayoutInfo instanceLayoutInfo = Layout.get((CompilationContext)this.ctxt).getInstanceLayoutInfo(CoreClasses.get((CompilationContext)this.ctxt).getArrayContentField((ObjectType)type).getEnclosingType());
        CompoundType compoundType = instanceLayoutInfo.getCompoundType();
        return this.createPhysicalObjectType((PhysicalObjectType)type, instanceLayoutInfo, compoundType);
    }

    private LLValue createArrayType(ArrayType type) {
        DICompositeType derivedType = this.module.diCompositeType(DITag.ArrayType, type.getSize() * 8L, type.getAlign() * 8);
        LLValue result = this.registerType((Type)type, (MetadataNode)derivedType);
        derivedType.baseType(this.getType((Type)type.getElementType())).elements(this.module.metadataTuple().elem(null, this.module.diSubrange(type.getElementCount()).asRef()).asRef());
        return result;
    }

    private LLValue createFallbackType(Type type) {
        long size = 0L;
        int align = 1;
        if (type instanceof ValueType) {
            size = ((ValueType)type).getSize();
            align = ((ValueType)type).getAlign();
        }
        return this.registerType(type, (MetadataNode)this.module.diCompositeType(DITag.StructureType, size, align).name(type.toFriendlyString()).flags(EnumSet.of(DIFlags.FwdDecl)));
    }

    private LLValue createType(Type type) {
        if (type instanceof ArrayType) {
            return this.createArrayType((ArrayType)type);
        }
        if (type instanceof ArrayObjectType) {
            return this.createArrayObjectType((ArrayObjectType)type);
        }
        if (type instanceof BooleanType) {
            return this.createBasicType((ValueType)((BooleanType)type), DIEncoding.Boolean);
        }
        if (type instanceof ClassObjectType) {
            return this.createClassObjectType((ClassObjectType)type);
        }
        if (type instanceof CompoundType) {
            return this.createCompoundType((CompoundType)type);
        }
        if (type instanceof FloatType) {
            return this.createBasicType((ValueType)((FloatType)type), DIEncoding.Float);
        }
        if (type instanceof FunctionType) {
            return this.createFunctionType((FunctionType)type);
        }
        if (type instanceof MethodType) {
            MethodType mt = (MethodType)type;
            return this.createType((Type)this.ctxt.getFunctionTypeForInvokableType((InvokableType)mt));
        }
        if (type instanceof PointerType) {
            return this.createPointerType((ValueType)((PointerType)type), (Type)((PointerType)type).getPointeeType());
        }
        if (type instanceof ReferenceType) {
            return this.createPointerType((ValueType)((ReferenceType)type), (Type)((ReferenceType)type).getUpperBound());
        }
        if (type instanceof UnresolvedType) {
            UnresolvedType ut = (UnresolvedType)type;
            return this.createPointerType((ValueType)ut, (Type)ut.getTypeSystem().getVoidType().getPointer());
        }
        if (type instanceof SignedIntegerType) {
            return this.createBasicType((ValueType)((SignedIntegerType)type), DIEncoding.Signed);
        }
        if (type instanceof TypeType) {
            return this.createBasicType((ValueType)((TypeType)type), DIEncoding.Unsigned);
        }
        if (type instanceof UnsignedIntegerType) {
            return this.createBasicType((ValueType)((UnsignedIntegerType)type), DIEncoding.Unsigned);
        }
        this.ctxt.warning("LLVM: Unhandled type %s for debug info generation", new Object[]{type.toFriendlyString()});
        return this.createFallbackType(type);
    }

    public LLValue getType(Type type) {
        LLValue debugInfo = this.types.get(type);
        if (debugInfo == null) {
            debugInfo = this.createType(type);
        }
        return debugInfo;
    }

    public LLValue createDeduplicatedLocation(int line, int column, LLValue scope, LLValue inlinedAt) {
        Assert.checkNotNullParam((String)"scope", (Object)scope);
        LocationKey key = new LocationKey(line, column, scope, inlinedAt);
        LLValue location = this.locations.get(key);
        if (location != null) {
            return location;
        }
        location = this.module.diLocation(line, column, scope, inlinedAt).asRef();
        this.locations.put(key, location);
        return location;
    }

    public LLValue getDebugInfoForGlobal(Data data, MemberElement element) {
        ValueType valueType;
        String name = data.getName();
        if (element instanceof FieldElement) {
            FieldElement fe = (FieldElement)element;
            valueType = fe.getType();
        } else {
            valueType = data.getValueType();
        }
        LLValue type = this.getType((Type)valueType);
        int align = valueType.getAlign();
        LLValue sourceFile = this.createSourceFile((Element)element);
        LLValue var_ = this.module.diGlobalVariable(name, type, this.diCompileUnit, sourceFile, 1, align).isDefinition().asRef();
        LLValue expr = this.module.diGlobalVariableExpression(var_, Values.diExpression().asValue()).asRef();
        this.globals.elem(null, expr);
        return expr;
    }

    static final class MethodDebugInfo {
        private final LLValue subprogram;

        MethodDebugInfo(LLValue diSubprogram) {
            this.subprogram = diSubprogram;
        }

        public LLValue getSubprogram() {
            return this.subprogram;
        }

        public LLValue getScope(int bci) {
            return this.subprogram;
        }
    }

    static final class LocationKey {
        private final int line;
        private final int column;
        private final LLValue scope;
        private final LLValue inlinedAt;

        LocationKey(int line, int column, LLValue scope, LLValue inlinedAt) {
            this.line = line;
            this.column = column;
            this.scope = scope;
            this.inlinedAt = inlinedAt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocationKey that = (LocationKey)o;
            return this.line == that.line && this.column == that.column && this.scope.equals(that.scope) && Objects.equals(this.inlinedAt, that.inlinedAt);
        }

        public int hashCode() {
            return Objects.hash(this.line, this.column, this.scope, this.inlinedAt);
        }
    }
}

