/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.llvm;

import io.smallrye.common.constraint.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Location;
import org.qbicc.graph.Node;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.ArrayLiteral;
import org.qbicc.graph.literal.BitCastLiteral;
import org.qbicc.graph.literal.BooleanLiteral;
import org.qbicc.graph.literal.ByteArrayLiteral;
import org.qbicc.graph.literal.CompoundLiteral;
import org.qbicc.graph.literal.ElementOfLiteral;
import org.qbicc.graph.literal.FloatLiteral;
import org.qbicc.graph.literal.FunctionLiteral;
import org.qbicc.graph.literal.GlobalVariableLiteral;
import org.qbicc.graph.literal.IntegerLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralVisitor;
import org.qbicc.graph.literal.MemberOfLiteral;
import org.qbicc.graph.literal.NullLiteral;
import org.qbicc.graph.literal.OffsetFromLiteral;
import org.qbicc.graph.literal.ProgramObjectLiteral;
import org.qbicc.graph.literal.TypeLiteral;
import org.qbicc.graph.literal.UndefinedLiteral;
import org.qbicc.graph.literal.ValueConvertLiteral;
import org.qbicc.graph.literal.ZeroInitializerLiteral;
import org.qbicc.machine.llvm.Array;
import org.qbicc.machine.llvm.Function;
import org.qbicc.machine.llvm.FunctionAttributes;
import org.qbicc.machine.llvm.IdentifiedType;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.Module;
import org.qbicc.machine.llvm.ParameterAttributes;
import org.qbicc.machine.llvm.Struct;
import org.qbicc.machine.llvm.StructType;
import org.qbicc.machine.llvm.Types;
import org.qbicc.machine.llvm.Values;
import org.qbicc.machine.llvm.impl.LLVM;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.llvm.LLVMConfiguration;
import org.qbicc.plugin.llvm.LLVMModuleGenerator;
import org.qbicc.plugin.llvm.ReferenceStrategy;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.ArrayType;
import org.qbicc.type.BlockType;
import org.qbicc.type.BooleanType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.FloatType;
import org.qbicc.type.FunctionType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.InvokableType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.Type;
import org.qbicc.type.UnresolvedType;
import org.qbicc.type.ValueType;
import org.qbicc.type.VariadicType;
import org.qbicc.type.VoidType;
import org.qbicc.type.WordType;

final class LLVMModuleNodeVisitor
implements LiteralVisitor<Void, LLValue> {
    static final LLValue i8_ptr = Types.ptrTo((LLValue)Types.i8);
    static final LLValue i8_ptr_as1 = Types.ptrTo((LLValue)Types.i8, (int)1);
    static final LLValue ptr_as1 = Types.ptr((int)1);
    final LLVMModuleGenerator generator;
    final Module module;
    final CompilationContext ctxt;
    final LLVMConfiguration config;
    final boolean opaquePointers;
    final Map<Type, LLValue> types = new HashMap<Type, LLValue>();
    final Map<CompoundType, Map<CompoundType.Member, LLValue>> structureOffsets = new HashMap<CompoundType, Map<CompoundType.Member, LLValue>>();
    final Map<Value, LLValue> globalValues = new HashMap<Value, LLValue>();
    final Map<FunctionType, LLValue> statepointDecls = new HashMap<FunctionType, LLValue>();
    final Map<String, LLValue> statepointDeclsByName = new HashMap<String, LLValue>();
    final Map<FunctionType, LLValue> statepointTypes = new HashMap<FunctionType, LLValue>();
    final Map<ValueType, LLValue> resultDecls = new HashMap<ValueType, LLValue>();
    final Map<String, LLValue> resultDeclsByName = new HashMap<String, LLValue>();
    final Map<ValueType, LLValue> resultDeclTypes = new HashMap<ValueType, LLValue>();
    final LLValue refType;

    LLVMModuleNodeVisitor(LLVMModuleGenerator generator, Module module, CompilationContext ctxt, LLVMConfiguration config) {
        this.generator = generator;
        this.module = module;
        this.ctxt = ctxt;
        this.config = config;
        this.opaquePointers = config.isOpaquePointers();
        IdentifiedType identifiedType = module.identifiedType("ref");
        this.refType = identifiedType.type(switch (config.getReferenceStrategy()) {
            default -> throw new IncompatibleClassChangeError();
            case ReferenceStrategy.POINTER -> {
                if (this.opaquePointers) {
                    yield Types.ptr;
                }
                yield i8_ptr;
            }
            case ReferenceStrategy.POINTER_AS1 -> this.opaquePointers ? ptr_as1 : i8_ptr_as1;
        }).asTypeRef();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    LLValue map(Type type) {
        LLValue res = this.types.get(type);
        if (res != null) {
            return res;
        }
        if (type instanceof VoidType) {
            res = Types.void_;
        } else if (type instanceof FunctionType) {
            FunctionType fnType = (FunctionType)type;
            int cnt = fnType.getParameterCount();
            ArrayList<LLValue> argTypes = cnt == 0 ? List.of() : new ArrayList<LLValue>(cnt);
            boolean variadic = false;
            for (int i = 0; i < cnt; ++i) {
                ValueType parameterType = fnType.getParameterType(i);
                if (parameterType instanceof VariadicType) {
                    if (i < cnt - 1) {
                        throw new IllegalStateException("Variadic type as non-final parameter type");
                    }
                    variadic = true;
                    continue;
                }
                argTypes.add(this.map((Type)parameterType));
            }
            res = Types.function((LLValue)this.map((Type)fnType.getReturnType()), argTypes, (boolean)variadic);
        } else if (type instanceof BooleanType) {
            res = Types.i1;
        } else if (type instanceof FloatType) {
            int bytes = (int)((FloatType)type).getSize();
            if (bytes == 4) {
                res = Types.float32;
            } else {
                if (bytes != 8) throw Assert.unreachableCode();
                res = Types.float64;
            }
        } else if (type instanceof InvokableType) {
            InvokableType it = (InvokableType)type;
            res = this.map((Type)this.ctxt.getFunctionTypeForInvokableType(it));
        } else if (type instanceof PointerType) {
            ValueType pointeeType = ((PointerType)type).getPointeeType();
            res = this.opaquePointers ? Types.ptr : (pointeeType instanceof VoidType ? i8_ptr : Types.ptrTo((LLValue)this.map((Type)pointeeType)));
        } else if (type instanceof ReferenceType || type instanceof UnresolvedType) {
            res = this.refType;
        } else if (type instanceof WordType) {
            int bytes = (int)((WordType)type).getSize();
            if (bytes == 1) {
                res = Types.i8;
            } else if (bytes == 2) {
                res = Types.i16;
            } else if (bytes == 4) {
                res = Types.i32;
            } else {
                if (bytes != 8) throw Assert.unreachableCode();
                res = Types.i64;
            }
        } else if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            ValueType elementType = arrayType.getElementType();
            long size = arrayType.getElementCount();
            res = Types.array((int)((int)size), (LLValue)this.map((Type)elementType));
        } else if (type instanceof CompoundType) {
            CompoundType compoundType = (CompoundType)type;
            HashMap<CompoundType.Member, LLValue> offsets = new HashMap<CompoundType.Member, LLValue>();
            boolean isIdentified = !compoundType.isAnonymous();
            this.structureOffsets.putIfAbsent(compoundType, offsets);
            IdentifiedType identifiedType = null;
            if (isIdentified) {
                Object name;
                String compoundName = compoundType.getName();
                if (compoundType.getTag() == CompoundType.Tag.NONE) {
                    outputName = "type." + compoundName;
                    name = LLVM.needsQuotes((String)compoundName) ? LLVM.quoteString((String)outputName) : outputName;
                } else {
                    outputName = compoundType.getTag() + "." + compoundName;
                    name = LLVM.needsQuotes((String)compoundName) ? LLVM.quoteString((String)outputName) : outputName;
                }
                identifiedType = this.module.identifiedType((String)name);
                this.types.put(type, identifiedType.asTypeRef());
            }
            StructType struct = Types.structType((boolean)isIdentified);
            int index = 0;
            for (CompoundType.Member member : compoundType.getPaddedMembers()) {
                ValueType memberType = member.getType();
                struct.member(this.map((Type)memberType), member.getName());
                offsets.put(member, Values.intConstant((int)index));
                ++index;
            }
            if (isIdentified) {
                identifiedType.type((LLValue)struct);
                res = identifiedType.asTypeRef();
            } else {
                res = struct;
            }
        } else {
            if (!(type instanceof BlockType)) throw new IllegalStateException("Can't map Type(" + type.toString() + ")");
            res = Types.label;
        }
        this.types.put(type, res);
        return res;
    }

    LLValue map(CompoundType compoundType, CompoundType.Member member) {
        this.map((Type)compoundType);
        return this.structureOffsets.get(compoundType).get(member);
    }

    LLValue map(Literal value) {
        LLValue mapped = this.globalValues.get(value);
        if (mapped != null) {
            return mapped;
        }
        mapped = (LLValue)value.accept((LiteralVisitor)this, null);
        this.globalValues.put((Value)value, mapped);
        return mapped;
    }

    public LLValue visit(Void param, ArrayLiteral node) {
        List values = node.getValues();
        Array array = Values.array((LLValue)this.map((Type)node.getType().getElementType()));
        for (int i = 0; i < values.size(); ++i) {
            array.item(this.map((Literal)values.get(i)));
        }
        return array;
    }

    public LLValue visit(Void param, BitCastLiteral node) {
        LLValue toType;
        LLValue input = this.map(node.getValue());
        ValueType inputType = node.getValue().getType();
        WordType outputType = node.getType();
        if (this.config.isOpaquePointers() && (inputType instanceof PointerType && outputType instanceof PointerType || inputType instanceof ReferenceType && outputType instanceof ReferenceType)) {
            return input;
        }
        LLValue fromType = this.map((Type)inputType);
        if (fromType.equals(toType = this.map((Type)outputType))) {
            return input;
        }
        return Values.bitcastConstant((LLValue)input, (LLValue)fromType, (LLValue)toType);
    }

    public LLValue visit(Void param, ValueConvertLiteral node) {
        WordType outputType;
        LLValue toType;
        LLValue input = this.map(node.getValue());
        ValueType inputType = node.getValue().getType();
        LLValue fromType = this.map((Type)inputType);
        if (fromType.equals(toType = this.map((Type)(outputType = node.getType())))) {
            return input;
        }
        if (inputType instanceof IntegerType && outputType instanceof PointerType) {
            return Values.inttoptrConstant((LLValue)input, (LLValue)fromType, (LLValue)toType);
        }
        if (inputType instanceof PointerType && outputType instanceof IntegerType) {
            return Values.ptrtointConstant((LLValue)input, (LLValue)fromType, (LLValue)toType);
        }
        if (inputType instanceof ReferenceType && outputType instanceof PointerType) {
            switch (this.config.getReferenceStrategy()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case POINTER: {
                    throw new IllegalStateException("Cast found with pointer ref strategy");
                }
                case POINTER_AS1: 
            }
            return Values.addrspacecastConstant((LLValue)input, (LLValue)fromType, (LLValue)toType);
        }
        if (inputType instanceof PointerType && outputType instanceof ReferenceType) {
            switch (this.config.getReferenceStrategy()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case POINTER: {
                    throw new IllegalStateException("Cast found with pointer ref strategy");
                }
                case POINTER_AS1: 
            }
            return Values.addrspacecastConstant((LLValue)input, (LLValue)fromType, (LLValue)toType);
        }
        return this.visitAny(param, (Literal)node);
    }

    public LLValue visit(Void param, ByteArrayLiteral node) {
        return Values.byteArray((byte[])node.getValues());
    }

    public LLValue visit(Void param, CompoundLiteral node) {
        CompoundType type = node.getType();
        Map values = node.getValues();
        Struct struct = Values.struct();
        for (CompoundType.Member member : type.getPaddedMembers()) {
            Literal literal = (Literal)values.get(member);
            ValueType memberType = member.getType();
            if (literal == null) {
                struct.item(this.map((Type)memberType), Values.zeroinitializer);
                continue;
            }
            struct.item(this.map((Type)memberType), this.map(literal));
        }
        return struct;
    }

    public LLValue visit(Void param, ElementOfLiteral node) {
        Literal innermost = this.innermostGepValue((Literal)node);
        PointerType ptrType = (PointerType)innermost.getType(PointerType.class);
        return Values.gepConstant((LLValue)this.map((Type)ptrType.getPointeeType()), (LLValue)this.map((Type)ptrType), (LLValue)this.map(innermost), (LLValue[])this.buildGepLiteralArgs((Literal)node, 0));
    }

    public LLValue visit(Void param, FloatLiteral node) {
        if (node.getType().getMinBits() == 32) {
            return Values.floatConstant((float)node.floatValue());
        }
        return Values.floatConstant((double)node.doubleValue());
    }

    public LLValue visit(Void unused, FunctionLiteral literal) {
        return Values.global((String)literal.getExecutable().getName());
    }

    public LLValue visit(Void unused, GlobalVariableLiteral node) {
        return Values.global((String)node.getVariableElement().getName());
    }

    public LLValue visit(Void param, IntegerLiteral node) {
        return Values.intConstant((long)node.longValue());
    }

    public LLValue visit(Void unused, MemberOfLiteral node) {
        Literal innermost = this.innermostGepValue((Literal)node);
        PointerType ptrType = (PointerType)innermost.getType(PointerType.class);
        return Values.gepConstant((LLValue)this.map((Type)ptrType.getPointeeType()), (LLValue)this.map((Type)ptrType), (LLValue)this.map(innermost), (LLValue[])this.buildGepLiteralArgs((Literal)node, 0));
    }

    public LLValue visit(Void param, NullLiteral node) {
        return Values.NULL;
    }

    public LLValue visit(Void unused, OffsetFromLiteral node) {
        Literal innermost = this.innermostGepValue((Literal)node);
        PointerType ptrType = (PointerType)innermost.getType(PointerType.class);
        return Values.gepConstant((LLValue)this.map((Type)ptrType.getPointeeType()), (LLValue)this.map((Type)ptrType), (LLValue)this.map(innermost), (LLValue[])this.buildGepLiteralArgs((Literal)node, 0));
    }

    public LLValue visit(Void param, ProgramObjectLiteral node) {
        return Values.global((String)node.getProgramObject().getName());
    }

    public LLValue visit(Void param, ZeroInitializerLiteral node) {
        return Values.zeroinitializer;
    }

    public LLValue visit(Void param, BooleanLiteral node) {
        return node.booleanValue() ? Values.TRUE : Values.FALSE;
    }

    public LLValue visit(Void param, UndefinedLiteral node) {
        return Values.UNDEF;
    }

    public LLValue visit(Void param, TypeLiteral node) {
        int typeId;
        ValueType type = node.getValue();
        if (type instanceof ArrayObjectType) {
            typeId = CoreClasses.get((CompilationContext)this.ctxt).getArrayContentField((ObjectType)((ArrayObjectType)type)).getEnclosingType().load().getTypeId();
        } else if (type instanceof ObjectType) {
            typeId = ((ObjectType)type).getDefinition().load().getTypeId();
        } else if (type instanceof WordType) {
            typeId = ((WordType)type).asPrimitive().getTypeId();
        } else if (type instanceof VoidType) {
            typeId = ((VoidType)type).asPrimitive().getTypeId();
        } else {
            this.ctxt.error("llvm: cannot lower type literal %s", new Object[]{node});
            return Values.intConstant((int)0);
        }
        if (typeId <= 0) {
            this.ctxt.error("llvm: type %s has invalid type ID %d", new Object[]{type, typeId});
        }
        return Values.intConstant((int)typeId);
    }

    public LLValue visitAny(Void unused, Literal literal) {
        this.ctxt.error(Location.builder().setNode((Node)literal).build(), "llvm: Unrecognized literal type %s", new Object[]{literal.getClass()});
        return LLVM.FALSE;
    }

    private LLValue[] buildGepLiteralArgs(Literal lit, int index) {
        if (lit instanceof ElementOfLiteral) {
            ElementOfLiteral eol = (ElementOfLiteral)lit;
            LLValue[] array = this.buildGepLiteralArgs(eol.getArrayPointer(), index + 2);
            int length = array.length;
            array[length - index - 2] = this.map((Type)eol.getIndex().getType());
            array[length - index - 1] = this.map(eol.getIndex());
            return array;
        }
        if (lit instanceof MemberOfLiteral) {
            MemberOfLiteral mol = (MemberOfLiteral)lit;
            LLValue[] array = this.buildGepLiteralArgs(mol.getStructurePointer(), index + 2);
            int length = array.length;
            array[length - index - 2] = Types.i32;
            array[length - index - 1] = this.map((CompoundType)mol.getPointeeType(CompoundType.class), mol.getMember());
            return array;
        }
        if (lit instanceof OffsetFromLiteral) {
            OffsetFromLiteral ofl = (OffsetFromLiteral)lit;
            LLValue[] array = new LLValue[index + 2];
            array[0] = this.map((Type)ofl.getOffset().getType());
            array[1] = this.map(ofl.getOffset());
            return array;
        }
        LLValue[] array = new LLValue[index + 2];
        array[0] = Types.i32;
        array[1] = Values.ZERO;
        return array;
    }

    private Literal innermostGepValue(Literal lit) {
        if (lit instanceof ElementOfLiteral) {
            ElementOfLiteral eol = (ElementOfLiteral)lit;
            return this.innermostGepValue(eol.getArrayPointer());
        }
        if (lit instanceof MemberOfLiteral) {
            MemberOfLiteral mol = (MemberOfLiteral)lit;
            return this.innermostGepValue(mol.getStructurePointer());
        }
        if (lit instanceof OffsetFromLiteral) {
            OffsetFromLiteral ofl = (OffsetFromLiteral)lit;
            return ofl.getBasePointer();
        }
        return lit;
    }

    public LLValue mapStatepointType(FunctionType functionType) {
        LLValue statepointType = this.statepointTypes.get(functionType);
        if (statepointType == null) {
            statepointType = Types.function((LLValue)Types.token, List.of(Types.i64, Types.i32, this.map((Type)functionType.getPointer()), Types.i32, Types.i32), (boolean)true);
            this.statepointTypes.put(functionType, statepointType);
        }
        return statepointType;
    }

    public LLValue generateStatepointDecl(FunctionType functionType) {
        LLValue statepointDecl = this.statepointDecls.get(functionType);
        if (statepointDecl == null) {
            StringBuilder b = new StringBuilder(64);
            b.append("llvm.experimental.gc.statepoint.");
            this.mapTypeSuffix(b, (ValueType)functionType.getPointer());
            String name = b.toString();
            statepointDecl = this.statepointDeclsByName.get(name);
            if (statepointDecl == null) {
                Function decl = this.module.declare(name);
                decl.param(Types.i64).immarg();
                decl.param(Types.i32).immarg();
                Function.Parameter param = decl.param(this.map((Type)functionType.getPointer()));
                if (this.generator.getLlvmMajor() >= 15) {
                    param.attribute(ParameterAttributes.elementtype((LLValue)this.map((Type)functionType)));
                }
                decl.param(Types.i32).immarg();
                decl.param(Types.i32).immarg();
                decl.variadic();
                decl.returns(Types.token);
                statepointDecl = decl.asGlobal();
                this.statepointDeclsByName.put(name, statepointDecl);
            }
            this.statepointDecls.put(functionType, statepointDecl);
        }
        return statepointDecl;
    }

    private void mapTypeSuffix(StringBuilder b, ValueType type) {
        if (type instanceof BooleanType) {
            b.append("i1");
        } else if (type instanceof IntegerType) {
            IntegerType it = (IntegerType)type;
            b.append('i').append(it.getMinBits());
        } else if (type instanceof PointerType) {
            PointerType pt = (PointerType)type;
            b.append("p0");
            ValueType pointeeType = pt.getPointeeType();
            if (this.opaquePointers && !(pointeeType instanceof InvokableType)) {
                return;
            }
            this.mapTypeSuffix(b, pointeeType);
        } else if (type instanceof ReferenceType || type instanceof UnresolvedType) {
            b.append(this.opaquePointers ? "p1" : "p1i8");
        } else if (type instanceof FloatType) {
            FloatType ft = (FloatType)type;
            b.append('f').append(ft.getMinBits());
        } else if (type instanceof VoidType) {
            b.append("isVoid");
        } else if (type instanceof WordType) {
            WordType wt = (WordType)type;
            b.append('i').append(wt.getMinBits());
        } else if (type instanceof CompoundType) {
            Object name;
            CompoundType ct = (CompoundType)type;
            b.append("s_");
            String compoundName = ct.getName();
            if (ct.getTag() == CompoundType.Tag.NONE) {
                String outputName = "type." + compoundName;
                name = LLVM.needsQuotes((String)compoundName) ? LLVM.quoteString((String)outputName) : outputName;
            } else {
                String outputName = ct.getTag() + "." + compoundName;
                name = LLVM.needsQuotes((String)compoundName) ? LLVM.quoteString((String)outputName) : outputName;
            }
            b.append((String)name);
            b.append('s');
        } else if (!(type instanceof VariadicType)) {
            if (type instanceof FunctionType) {
                FunctionType ft = (FunctionType)type;
                b.append("f_");
                this.mapTypeSuffix(b, ft.getReturnType());
                for (ValueType parameterType : ft.getParameterTypes()) {
                    this.mapTypeSuffix(b, parameterType);
                }
                b.append('f');
            } else {
                throw new IllegalStateException("Unexpected type " + type);
            }
        }
    }

    public LLValue generateStatepointResultDecl(ValueType returnType) {
        LLValue resultDecl = this.resultDecls.get(returnType);
        if (resultDecl == null) {
            StringBuilder b = new StringBuilder(64);
            b.append("llvm.experimental.gc.result.");
            this.mapTypeSuffix(b, returnType);
            String name = b.toString();
            resultDecl = this.resultDeclsByName.get(name);
            if (resultDecl == null) {
                Function decl = this.module.declare(b.toString());
                decl.param(Types.token);
                decl.returns(this.map((Type)returnType));
                decl.attribute(FunctionAttributes.nounwind).attribute(FunctionAttributes.readnone);
                resultDecl = decl.asGlobal();
                this.resultDeclsByName.put(name, resultDecl);
            }
            this.resultDecls.put(returnType, resultDecl);
        }
        return resultDecl;
    }

    public LLValue generateStatepointResultDeclType(ValueType returnType) {
        LLValue resultDeclType = this.resultDeclTypes.get(returnType);
        if (resultDeclType == null) {
            resultDeclType = Types.function((LLValue)this.map((Type)returnType), List.of(Types.token), (boolean)false);
            this.resultDeclTypes.put(returnType, resultDeclType);
        }
        return resultDeclType;
    }
}

