/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.llvm;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Location;
import org.qbicc.driver.Driver;
import org.qbicc.machine.tool.ToolMessageHandler;
import org.qbicc.plugin.linker.Linker;
import org.qbicc.tool.llvm.LlvmObjCopyInvoker;
import org.qbicc.tool.llvm.LlvmToolChain;

public final class LLVMStripStackMapStage
implements Consumer<CompilationContext> {
    @Override
    public void accept(CompilationContext context) {
        ArrayList list = new ArrayList(Linker.get((CompilationContext)context).getObjectFilePathsInLinkOrder());
        Iterator iterator = list.iterator();
        context.runParallelTask(ctxt -> {
            LlvmObjCopyInvoker smrInvoker = LLVMStripStackMapStage.createStackMapRemovingInvoker(ctxt);
            if (smrInvoker == null) {
                return;
            }
            while (true) {
                Path item;
                Iterator iterator2 = iterator;
                synchronized (iterator2) {
                    if (!iterator.hasNext()) {
                        return;
                    }
                    item = (Path)iterator.next();
                }
                smrInvoker.setObjectFilePath(item);
                try {
                    smrInvoker.invoke();
                    continue;
                }
                catch (IOException e) {
                    context.error(Location.builder().setSourceFilePath(item.toString()).build(), "`llvm-objcopy` invocation has failed: %s", new Object[]{e.toString()});
                    continue;
                }
                break;
            }
        });
    }

    private static LlvmObjCopyInvoker createStackMapRemovingInvoker(CompilationContext context) {
        LlvmToolChain llvmToolChain = (LlvmToolChain)context.getAttachment(Driver.LLVM_TOOL_KEY);
        if (llvmToolChain == null) {
            context.error("No LLVM tool chain is available", new Object[0]);
            return null;
        }
        LlvmObjCopyInvoker objCopyInvoker = llvmToolChain.newLlvmObjCopyInvoker();
        objCopyInvoker.setMessageHandler(ToolMessageHandler.reporting((CompilationContext)context));
        objCopyInvoker.removeSection(context.getPlatform().getObjectType().formatSectionName("llvm_stackmaps", new String[]{"llvm_stackmaps"}));
        return objCopyInvoker;
    }
}

