/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reachability;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmReferenceArray;
import org.qbicc.interpreter.VmStaticFieldBaseObject;
import org.qbicc.interpreter.VmString;
import org.qbicc.plugin.layout.Layout;
import org.qbicc.plugin.layout.LayoutInfo;
import org.qbicc.plugin.reachability.ReachabilityAnalysis;
import org.qbicc.pointer.Pointer;
import org.qbicc.pointer.StaticMethodPointer;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InvokableElement;
import org.qbicc.type.definition.element.StaticFieldElement;

class BuildtimeHeapAnalyzer {
    private final Map<VmObject, Boolean> visited = Collections.synchronizedMap(new IdentityHashMap());

    BuildtimeHeapAnalyzer() {
    }

    void clear() {
        this.visited.clear();
    }

    void traceHeap(CompilationContext ctxt, ReachabilityAnalysis analysis, StaticFieldElement f, ExecutableElement currentElement) {
        Value v;
        if (f.isStatic() && f.getType() instanceof ReferenceType && !f.isThreadLocal() && f.getRunTimeInitializer() == null && (v = f.getEnclosingType().load().getInitialValue((FieldElement)f)) instanceof ObjectLiteral) {
            VmObject vo = ((ObjectLiteral)v).getValue();
            this.traceHeap(ctxt, analysis, vo, currentElement);
        }
    }

    void traceHeap(CompilationContext ctxt, ReachabilityAnalysis analysis, VmObject root, ExecutableElement rootElement) {
        if (this.visited.containsKey(root)) {
            return;
        }
        this.visited.put(root, Boolean.TRUE);
        ArrayDeque<VmObject> worklist = new ArrayDeque<VmObject>();
        worklist.add(root);
        Layout interpreterLayout = Layout.get((CompilationContext)ctxt);
        while (!worklist.isEmpty()) {
            VmObject cur = (VmObject)worklist.pop();
            if (cur instanceof VmStaticFieldBaseObject) continue;
            PhysicalObjectType ot = cur.getObjectType();
            if (ot instanceof ClassObjectType && !(cur instanceof VmString)) {
                LoadedTypeDefinition concreteType = cur.getObjectType().getDefinition().load();
                analysis.processBuildtimeInstantiatedObjectType(concreteType, rootElement);
                LayoutInfo memLayout = interpreterLayout.getInstanceLayoutInfo((DefinedTypeDefinition)concreteType);
                for (CompoundType.Member im : memLayout.getCompoundType().getMembers()) {
                    Pointer pointer;
                    if (im.getType() instanceof ReferenceType) {
                        VmObject child = cur.getMemory().loadRef((long)im.getOffset(), (ReadAccessMode)AccessModes.SinglePlain);
                        if (child == null || this.visited.containsKey(child)) continue;
                        worklist.add(child);
                        this.visited.put(child, Boolean.TRUE);
                        continue;
                    }
                    if (!(im.getType() instanceof PointerType) || !((pointer = cur.getMemory().loadPointer((long)im.getOffset(), (ReadAccessMode)AccessModes.SinglePlain)) instanceof StaticMethodPointer)) continue;
                    StaticMethodPointer smp = (StaticMethodPointer)pointer;
                    analysis.processReachableExactInvocation((InvokableElement)smp.getStaticMethod(), rootElement);
                }
                if (!(cur instanceof VmClass)) continue;
                VmClass vc = (VmClass)cur;
                analysis.processReachableType(vc.getTypeDefinition(), rootElement);
                continue;
            }
            if (!(ot instanceof ReferenceArrayObjectType)) continue;
            analysis.processArrayElementType(((ReferenceArrayObjectType)ot).getLeafElementType());
            for (VmObject e : ((VmReferenceArray)cur).getArray()) {
                if (e == null || this.visited.containsKey(e)) continue;
                worklist.add(e);
                this.visited.put(e, Boolean.TRUE);
            }
        }
    }
}

