/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reachability;

import java.util.List;
import java.util.function.Predicate;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Locatable;
import org.qbicc.plugin.core.ConditionEvaluation;
import org.qbicc.plugin.reachability.ReachabilityRoots;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.ValueType;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.ArrayAnnotationValue;
import org.qbicc.type.annotation.ClassAnnotationValue;
import org.qbicc.type.annotation.StringAnnotationValue;
import org.qbicc.type.definition.ConstructorResolver;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.MethodResolver;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;

public class ReachabilityAnnotationTypeBuilder
implements DefinedTypeDefinition.Builder.Delegating {
    private final DefinedTypeDefinition.Builder delegate;
    private final ReachabilityRoots roots;
    private final ClassContext classCtxt;
    private final CompilationContext ctxt;
    private final ClassTypeDescriptor autoQueued;
    private final ClassTypeDescriptor reflectivelyAccessed;
    private final ClassTypeDescriptor reflectivelyAccesses;

    public ReachabilityAnnotationTypeBuilder(ClassContext classCtxt, DefinedTypeDefinition.Builder delegate) {
        this.delegate = delegate;
        this.classCtxt = classCtxt;
        this.ctxt = classCtxt.getCompilationContext();
        this.roots = ReachabilityRoots.get(this.ctxt);
        this.autoQueued = ClassTypeDescriptor.synthesize((ClassContext)classCtxt, (String)"org/qbicc/runtime/AutoQueued");
        this.reflectivelyAccessed = ClassTypeDescriptor.synthesize((ClassContext)classCtxt, (String)"org/qbicc/runtime/ReflectivelyAccessed");
        this.reflectivelyAccesses = ClassTypeDescriptor.synthesize((ClassContext)classCtxt, (String)"org/qbicc/runtime/ReflectivelyAccesses");
    }

    public DefinedTypeDefinition.Builder getDelegate() {
        return this.delegate;
    }

    public void setInvisibleAnnotations(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            ConditionEvaluation conditionEvaluation;
            if (!annotation.getDescriptor().equals(this.reflectivelyAccesses) || !(conditionEvaluation = ConditionEvaluation.get((CompilationContext)this.ctxt)).evaluateConditions(this.classCtxt, (Locatable)this, annotation)) continue;
            ArrayAnnotationValue array = (ArrayAnnotationValue)annotation.getValue("value");
            int cnt = array.getElementCount();
            for (int j = 0; j < cnt; ++j) {
                Annotation element = (Annotation)array.getValue(j);
                TypeDescriptor clazz = ((ClassAnnotationValue)element.getValue("clazz")).getDescriptor();
                String method = ((StringAnnotationValue)element.getValue("method")).getString();
                try {
                    int idx;
                    Predicate<List> checkParams;
                    ValueType vt = this.classCtxt.resolveTypeFromDescriptor(clazz, TypeParameterContext.EMPTY, TypeSignature.synthesize((ClassContext)this.classCtxt, (TypeDescriptor)clazz));
                    if (!(vt instanceof ClassObjectType)) continue;
                    ClassObjectType ct = (ClassObjectType)vt;
                    LoadedTypeDefinition ltd = ct.getDefinition().load();
                    ArrayAnnotationValue ap = (ArrayAnnotationValue)element.getValue("params");
                    if (ap == null) {
                        checkParams = args -> true;
                    } else {
                        TypeDescriptor[] params = new TypeDescriptor[ap.getElementCount()];
                        for (int i = 0; i < params.length; ++i) {
                            params[i] = ((ClassAnnotationValue)ap.getValue(i)).getDescriptor();
                        }
                        checkParams = args -> {
                            if (args.size() != params.length) {
                                return false;
                            }
                            for (int i = 0; i < params.length; ++i) {
                                if (((TypeDescriptor)args.get(i)).equals(params[i])) continue;
                                return false;
                            }
                            return true;
                        };
                    }
                    if (method.equals("<init>")) {
                        idx = ltd.findSingleConstructorIndex(ce -> checkParams.test(ce.getDescriptor().getParameterTypes()));
                        if (idx != -1) {
                            this.roots.registerReflectiveConstructor(ltd.getConstructor(idx));
                            continue;
                        }
                        this.ctxt.warning("@RA Annotation not processed on %s. No match for %s.%s", new Object[]{this.getLocation(), clazz, method});
                        continue;
                    }
                    idx = ltd.findSingleMethodIndex(me -> me.nameEquals(method) && checkParams.test(me.getDescriptor().getParameterTypes()));
                    if (idx != -1) {
                        this.roots.registerReflectiveMethod(ltd.getMethod(idx));
                        continue;
                    }
                    this.ctxt.warning("RA Annotation not processed on %s. No match for %s.%s", new Object[]{this.getLocation(), clazz, method});
                    continue;
                }
                catch (Exception e) {
                    this.ctxt.warning((Throwable)e, "RA Annotation not processed in %s. No unique match for  %s.%s", new Object[]{this.getLocation(), clazz, method});
                }
            }
        }
        this.getDelegate().setInvisibleAnnotations(annotations);
    }

    public void addMethod(final MethodResolver resolver, int index, String name, MethodDescriptor descriptor) {
        super.addMethod(new MethodResolver(){

            public MethodElement resolveMethod(int index, DefinedTypeDefinition enclosing, MethodElement.Builder builder) {
                MethodElement methodElement = resolver.resolveMethod(index, enclosing, builder);
                for (Annotation annotation : methodElement.getInvisibleAnnotations()) {
                    if (annotation.getDescriptor().equals(ReachabilityAnnotationTypeBuilder.this.autoQueued)) {
                        ReachabilityAnnotationTypeBuilder.this.roots.registerAutoQueuedElement((ExecutableElement)methodElement);
                        continue;
                    }
                    if (!annotation.getDescriptor().equals(ReachabilityAnnotationTypeBuilder.this.reflectivelyAccessed)) continue;
                    ReachabilityAnnotationTypeBuilder.this.roots.registerReflectiveMethod(methodElement);
                }
                return methodElement;
            }
        }, index, name, descriptor);
    }

    public void addField(final FieldResolver resolver, int index, String name, TypeDescriptor descriptor) {
        super.addField(new FieldResolver(){

            public FieldElement resolveField(int index, DefinedTypeDefinition enclosing, FieldElement.Builder builder) {
                FieldElement fieldElement = resolver.resolveField(index, enclosing, builder);
                for (Annotation annotation : fieldElement.getInvisibleAnnotations()) {
                    if (!annotation.getDescriptor().equals(ReachabilityAnnotationTypeBuilder.this.reflectivelyAccessed)) continue;
                    ReachabilityAnnotationTypeBuilder.this.roots.registerReflectiveField(fieldElement);
                }
                return fieldElement;
            }
        }, index, name, descriptor);
    }

    public void addConstructor(final ConstructorResolver resolver, int index, MethodDescriptor descriptor) {
        super.addConstructor(new ConstructorResolver(){

            public ConstructorElement resolveConstructor(int index, DefinedTypeDefinition enclosing, ConstructorElement.Builder builder) {
                ConstructorElement constructorElement = resolver.resolveConstructor(index, enclosing, builder);
                for (Annotation annotation : constructorElement.getInvisibleAnnotations()) {
                    if (annotation.getDescriptor().equals(ReachabilityAnnotationTypeBuilder.this.autoQueued)) {
                        ReachabilityAnnotationTypeBuilder.this.roots.registerAutoQueuedElement((ExecutableElement)constructorElement);
                        continue;
                    }
                    if (!annotation.getDescriptor().equals(ReachabilityAnnotationTypeBuilder.this.reflectivelyAccessed)) continue;
                    ReachabilityAnnotationTypeBuilder.this.roots.registerReflectiveConstructor(constructorElement);
                }
                return constructorElement;
            }
        }, index, descriptor);
    }
}

