/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reachability;

import java.util.HashSet;
import org.qbicc.context.CompilationContext;
import org.qbicc.facts.Fact;
import org.qbicc.facts.Facts;
import org.qbicc.graph.Action;
import org.qbicc.graph.ActionVisitor;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.ClassOf;
import org.qbicc.graph.CmpAndSwap;
import org.qbicc.graph.ConstructorElementHandle;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.ExactMethodElementHandle;
import org.qbicc.graph.Field;
import org.qbicc.graph.FunctionElementHandle;
import org.qbicc.graph.InitCheck;
import org.qbicc.graph.InterfaceMethodElementHandle;
import org.qbicc.graph.Load;
import org.qbicc.graph.MultiNewArray;
import org.qbicc.graph.New;
import org.qbicc.graph.NewReferenceArray;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.OrderedNode;
import org.qbicc.graph.ReadModifyWrite;
import org.qbicc.graph.StaticField;
import org.qbicc.graph.StaticMethodElementHandle;
import org.qbicc.graph.Store;
import org.qbicc.graph.Terminator;
import org.qbicc.graph.TerminatorVisitor;
import org.qbicc.graph.Value;
import org.qbicc.graph.ValueHandle;
import org.qbicc.graph.ValueHandleVisitor;
import org.qbicc.graph.ValueVisitor;
import org.qbicc.graph.VirtualMethodElementHandle;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.graph.literal.PointerLiteral;
import org.qbicc.graph.literal.TypeLiteral;
import org.qbicc.plugin.coreclasses.RuntimeMethodFinder;
import org.qbicc.plugin.reachability.FieldReachabilityFacts;
import org.qbicc.plugin.reachability.ReachabilityAnalysis;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.pointer.InstanceMethodPointer;
import org.qbicc.pointer.ReferenceAsPointer;
import org.qbicc.pointer.RootPointer;
import org.qbicc.pointer.StaticFieldPointer;
import org.qbicc.pointer.StaticMethodPointer;
import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.InterfaceObjectType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FunctionElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.InvokableElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.definition.element.StaticMethodElement;

public class ReachabilityBlockBuilder
extends DelegatingBasicBlockBuilder
implements ValueHandleVisitor<Void, Void> {
    private final CompilationContext ctxt;

    public ReachabilityBlockBuilder(CompilationContext ctxt, BasicBlockBuilder delegate) {
        super(delegate);
        this.ctxt = ctxt;
    }

    public void finish() {
        BasicBlock entryBlock = this.getFirstBlock();
        entryBlock.getTerminator().accept((TerminatorVisitor)new ReachabilityVisitor(), (Object)new ReachabilityContext(this.ctxt, this.getDelegate().getCurrentElement()));
        super.finish();
    }

    static final class ReachabilityVisitor
    implements NodeVisitor<ReachabilityContext, Void, Void, Void, Void>,
    RootPointer.Visitor<ReachabilityContext, Void> {
        ReachabilityVisitor() {
        }

        public Void visitUnknown(ReachabilityContext param, Action node) {
            this.visitUnknown(param, (Node)node);
            return null;
        }

        public Void visitUnknown(ReachabilityContext param, Value node) {
            this.visitUnknown(param, (Node)node);
            return null;
        }

        public Void visitUnknown(ReachabilityContext param, ValueHandle node) {
            this.visitUnknown(param, (Node)node);
            return null;
        }

        public Void visitUnknown(ReachabilityContext param, Terminator node) {
            if (this.visitUnknown(param, (Node)node)) {
                int cnt = node.getSuccessorCount();
                for (int i = 0; i < cnt; ++i) {
                    node.getSuccessor(i).getTerminator().accept((TerminatorVisitor)this, (Object)param);
                }
                for (Value v : node.getOutboundValues().values()) {
                    v.accept((ValueVisitor)this, (Object)param);
                }
            }
            return null;
        }

        boolean visitUnknown(ReachabilityContext param, Node node) {
            if (param.visited.add(node)) {
                if (node.hasValueHandleDependency()) {
                    node.getValueHandle().accept((ValueHandleVisitor)this, (Object)param);
                }
                int cnt = node.getValueDependencyCount();
                for (int i = 0; i < cnt; ++i) {
                    node.getValueDependency(i).accept((ValueVisitor)this, (Object)param);
                }
                if (node instanceof OrderedNode) {
                    OrderedNode on = (OrderedNode)node;
                    Node dependency = on.getDependency();
                    if (dependency instanceof Action) {
                        Action a = (Action)dependency;
                        a.accept((ActionVisitor)this, (Object)param);
                    } else if (dependency instanceof Value) {
                        Value v = (Value)dependency;
                        v.accept((ValueVisitor)this, (Object)param);
                    } else if (dependency instanceof Terminator) {
                        Terminator t = (Terminator)dependency;
                        t.accept((TerminatorVisitor)this, (Object)param);
                    } else if (dependency instanceof ValueHandle) {
                        ValueHandle vh = (ValueHandle)dependency;
                        vh.accept((ValueHandleVisitor)this, (Object)param);
                    }
                }
                return true;
            }
            return false;
        }

        public Void visit(ReachabilityContext param, ObjectLiteral value) {
            param.analysis.processReachableObject(value.getValue(), param.currentElement);
            return null;
        }

        public Void visit(ReachabilityContext param, PointerLiteral value) {
            RootPointer pointer = value.getPointer().getRootPointer();
            pointer.accept((RootPointer.Visitor)this, (Object)param);
            return null;
        }

        public Void visit(ReachabilityContext param, TypeLiteral value) {
            ValueType valueType = value.getValue();
            if (valueType instanceof ClassObjectType) {
                ClassObjectType cot = (ClassObjectType)valueType;
                param.analysis.processReachableType(cot.getDefinition().load(), param.currentElement);
            } else {
                valueType = value.getValue();
                if (valueType instanceof InterfaceObjectType) {
                    InterfaceObjectType iot = (InterfaceObjectType)valueType;
                    param.analysis.processReachableType(iot.getDefinition().load(), param.currentElement);
                } else {
                    valueType = value.getValue();
                    if (valueType instanceof ReferenceArrayObjectType) {
                        ReferenceArrayObjectType aot = (ReferenceArrayObjectType)valueType;
                        param.analysis.processArrayElementType(aot.getLeafElementType());
                    }
                }
            }
            return null;
        }

        public Void visit(ReachabilityContext reachabilityContext, InstanceMethodPointer pointer) {
            InstanceMethodElement target = pointer.getInstanceMethod();
            reachabilityContext.analysis.processReachableExactInvocation((InvokableElement)target, reachabilityContext.currentElement);
            return null;
        }

        public Void visit(ReachabilityContext param, ReferenceAsPointer pointer) {
            param.analysis.processReachableObject(pointer.getReference(), param.currentElement);
            return null;
        }

        public Void visit(ReachabilityContext param, StaticFieldPointer pointer) {
            StaticFieldElement f = pointer.getStaticField();
            param.analysis.processReachableStaticFieldAccess(f, param.currentElement);
            return null;
        }

        public Void visit(ReachabilityContext param, StaticMethodPointer pointer) {
            StaticMethodElement target = pointer.getStaticMethod();
            param.analysis.processReachableExactInvocation((InvokableElement)target, param.currentElement);
            return null;
        }

        public Void visit(ReachabilityContext param, ConstructorElementHandle node) {
            if (this.visitUnknown(param, (Node)node)) {
                ConstructorElement target = node.getExecutable();
                param.analysis.processReachableExactInvocation((InvokableElement)target, param.currentElement);
                if (!(target.getEnclosingType().load().isAbstract() || param.currentElement instanceof ConstructorElement && (!(param.currentElement instanceof ConstructorElement) || param.currentElement.getEnclosingType().load().getSuperClass() != null && param.currentElement.getEnclosingType().load().getSuperClass().equals(target.getEnclosingType())))) {
                    param.analysis.processInstantiatedClass(target.getEnclosingType().load(), false, param.currentElement);
                }
            }
            return null;
        }

        public Void visit(ReachabilityContext param, FunctionElementHandle node) {
            if (this.visitUnknown(param, (Node)node)) {
                FunctionElement target = node.getExecutable();
                param.analysis.processReachableExactInvocation((InvokableElement)target, param.currentElement);
            }
            return null;
        }

        public Void visit(ReachabilityContext param, ExactMethodElementHandle node) {
            if (this.visitUnknown(param, (Node)node)) {
                param.analysis.processReachableExactInvocation((InvokableElement)node.getExecutable(), param.currentElement);
            }
            return null;
        }

        public Void visit(ReachabilityContext param, VirtualMethodElementHandle node) {
            if (this.visitUnknown(param, (Node)node)) {
                param.analysis.processReachableDispatchedInvocation(node.getExecutable(), param.currentElement);
            }
            return null;
        }

        public Void visit(ReachabilityContext param, InterfaceMethodElementHandle node) {
            if (this.visitUnknown(param, (Node)node)) {
                param.analysis.processReachableDispatchedInvocation(node.getExecutable(), param.currentElement);
            }
            return null;
        }

        public Void visit(ReachabilityContext param, StaticMethodElementHandle node) {
            if (this.visitUnknown(param, (Node)node)) {
                MethodElement target = node.getExecutable();
                param.analysis.processReachableExactInvocation((InvokableElement)target, param.currentElement);
            }
            return null;
        }

        public Void visit(ReachabilityContext param, New node) {
            if (this.visitUnknown(param, (Node)node)) {
                LoadedTypeDefinition ltd = node.getClassObjectType().getDefinition().load();
                param.analysis.processInstantiatedClass(ltd, false, param.currentElement);
            }
            return null;
        }

        public Void visit(ReachabilityContext param, NewReferenceArray node) {
            if (this.visitUnknown(param, (Node)node)) {
                param.analysis.processArrayElementType(node.getArrayType().getLeafElementType());
            }
            return null;
        }

        public Void visit(ReachabilityContext param, MultiNewArray node) {
            ArrayObjectType arrayObjectType;
            if (this.visitUnknown(param, (Node)node) && (arrayObjectType = node.getArrayType()) instanceof ReferenceArrayObjectType) {
                ReferenceArrayObjectType at = (ReferenceArrayObjectType)arrayObjectType;
                param.analysis.processArrayElementType(at.getLeafElementType());
            }
            return null;
        }

        public Void visit(ReachabilityContext param, StaticField node) {
            if (this.visitUnknown(param, (Node)node)) {
                StaticFieldElement f = node.getVariableElement();
                param.analysis.processReachableStaticFieldAccess(f, param.currentElement);
            }
            return null;
        }

        public Void visit(ReachabilityContext param, InitCheck node) {
            if (this.visitUnknown(param, (Node)node)) {
                param.analysis.processReachableRuntimeInitializer(node.getInitializerElement(), param.currentElement);
                MethodElement run = RuntimeMethodFinder.get((CompilationContext)param.ctxt).getMethod("org/qbicc/runtime/main/Once", "run");
                param.analysis.processReachableDispatchedInvocation(run, param.currentElement);
            }
            return null;
        }

        public Void visit(ReachabilityContext param, ClassOf node) {
            if (this.visitUnknown(param, (Node)node)) {
                MethodElement methodElement = RuntimeMethodFinder.get((CompilationContext)param.ctxt).getMethod("getClassFromTypeId");
                param.analysis.processReachableExactInvocation((InvokableElement)methodElement, param.currentElement);
            }
            return null;
        }

        public Void visit(ReachabilityContext param, Load node) {
            ValueHandle valueHandle;
            if (this.visitUnknown(param, (Node)node) && (valueHandle = node.getValueHandle()) instanceof Field) {
                Field f = (Field)valueHandle;
                Facts.get((CompilationContext)param.ctxt).discover((Object)f.getVariableElement(), (Fact)FieldReachabilityFacts.IS_READ);
            }
            return null;
        }

        public Void visit(ReachabilityContext param, Store node) {
            ValueHandle valueHandle;
            if (this.visitUnknown(param, (Node)node) && (valueHandle = node.getValueHandle()) instanceof Field) {
                Field f = (Field)valueHandle;
                Facts.get((CompilationContext)param.ctxt).discover((Object)f.getVariableElement(), (Fact)FieldReachabilityFacts.IS_WRITTEN);
            }
            return null;
        }

        public Void visit(ReachabilityContext param, CmpAndSwap node) {
            ValueHandle valueHandle;
            if (this.visitUnknown(param, (Node)node) && (valueHandle = node.getValueHandle()) instanceof Field) {
                Field f = (Field)valueHandle;
                Facts.get((CompilationContext)param.ctxt).discover((Object)f.getVariableElement(), (Fact)FieldReachabilityFacts.IS_READ, (Fact)FieldReachabilityFacts.IS_WRITTEN);
            }
            return null;
        }

        public Void visit(ReachabilityContext param, ReadModifyWrite node) {
            ValueHandle valueHandle;
            if (this.visitUnknown(param, (Node)node) && (valueHandle = node.getValueHandle()) instanceof Field) {
                Field f = (Field)valueHandle;
                Facts.get((CompilationContext)param.ctxt).discover((Object)f.getVariableElement(), (Fact)FieldReachabilityFacts.IS_READ, (Fact)FieldReachabilityFacts.IS_WRITTEN);
            }
            return null;
        }
    }

    static final class ReachabilityContext {
        final CompilationContext ctxt;
        private final ExecutableElement currentElement;
        private final ReachabilityAnalysis analysis;
        final HashSet<Node> visited = new HashSet();

        ReachabilityContext(CompilationContext ctxt, ExecutableElement currentElement) {
            this.ctxt = ctxt;
            this.currentElement = currentElement;
            this.analysis = ReachabilityInfo.get(ctxt).getAnalysis();
        }
    }
}

