/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reachability;

import org.qbicc.context.CompilationContext;
import org.qbicc.facts.Condition;
import org.qbicc.facts.Fact;
import org.qbicc.facts.Facts;
import org.qbicc.facts.core.ExecutableReachabilityFacts;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.ReadAccessMode;
import org.qbicc.interpreter.VmObject;
import org.qbicc.plugin.reachability.InstanceMethodReachabilityFacts;
import org.qbicc.plugin.reachability.ObjectReachabilityFacts;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.plugin.reachability.TypeReachabilityFacts;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.definition.element.InstanceMethodElement;

public final class ReachabilityFactsSetup {
    private ReachabilityFactsSetup() {
    }

    public static void setupAdd(CompilationContext ctxt) {
        Facts facts = Facts.get((CompilationContext)ctxt);
        ReachabilityFactsSetup.setupReachability(facts);
    }

    public static void setupAnalyze(CompilationContext ctxt) {
        Facts facts = Facts.get((CompilationContext)ctxt);
        ReachabilityFactsSetup.setupReachability(facts);
        ReachabilityFactsSetup.setupValidate(facts);
    }

    public static void setupLower(CompilationContext ctxt) {
        Facts facts = Facts.get((CompilationContext)ctxt);
        ReachabilityFactsSetup.setupReachability(facts);
        ReachabilityFactsSetup.setupValidate(facts);
    }

    public static void setupGenerate(CompilationContext ctxt) {
        Facts facts = Facts.get((CompilationContext)ctxt);
        ReachabilityFactsSetup.setupReachability(facts);
        ReachabilityFactsSetup.setupValidate(facts);
    }

    private static void setupReachability(Facts facts) {
        facts.registerAction(Condition.when((Fact)TypeReachabilityFacts.IS_INSTANTIATED), ReachabilityFactsSetup::markEachMethodAsInstantiated);
        facts.registerAction(Condition.when((Fact)InstanceMethodReachabilityFacts.IS_PROVISIONALLY_INVOKED), ReachabilityFactsSetup::markEnclosingTypeAsProvisionallyInvoked);
        facts.registerAction(Condition.when((Fact)InstanceMethodReachabilityFacts.IS_PROVISIONALLY_DISPATCH_INVOKED), ReachabilityFactsSetup::markEnclosingTypeAsProvisionallyDispatched);
        facts.registerAction(Condition.whenAll((Fact)InstanceMethodReachabilityFacts.EXACT_RECEIVER_IS_ON_HEAP, (Fact)InstanceMethodReachabilityFacts.IS_PROVISIONALLY_INVOKED), ReachabilityFactsSetup::markAsInvoked);
        facts.registerAction(Condition.whenAll((Fact)InstanceMethodReachabilityFacts.DISPATCH_RECEIVER_IS_ON_HEAP, (Fact)InstanceMethodReachabilityFacts.IS_PROVISIONALLY_DISPATCH_INVOKED), ReachabilityFactsSetup::markAsDispatchInvoked);
        facts.registerAction(Condition.when((Fact)ObjectReachabilityFacts.IS_REACHABLE), ReachabilityFactsSetup::markObjectTypeDefAsOnHeap);
        facts.registerAction(Condition.when((Fact)ExecutableReachabilityFacts.IS_INVOKED), ReachabilityFactsSetup::markEnclosingAsInstantiatedIfCtor);
        facts.registerAction(Condition.when((Fact)TypeReachabilityFacts.HAS_CLASS), (ltd, f) -> ReachabilityInfo.get(f.getCompilationContext()).getAnalysis().processReachableType((LoadedTypeDefinition)ltd, null));
    }

    private static void setupValidate(Facts facts) {
        facts.registerAction(Condition.when((Fact)ExecutableReachabilityFacts.IS_INVOKED), ReachabilityFactsSetup::validateWasInvoked);
    }

    private static void validateWasInvoked(ExecutableElement me, Facts facts) {
        if (!facts.hadFact((Object)me, (Fact)ExecutableReachabilityFacts.IS_INVOKED)) {
            facts.getCompilationContext().error((Element)me, "Element cannot become reachable after being unreachable in the previous phase", new Object[0]);
        }
    }

    private static void markEachMethodAsInstantiated(LoadedTypeDefinition ltd, Facts facts) {
        ltd.forEachNonStaticMethod((Object)facts, ReachabilityFactsSetup::markMethodWithOnHeapReceiver);
    }

    private static void markMethodWithOnHeapReceiver(Facts facts, InstanceMethodElement me) {
        facts.discover((Object)me, (Fact)InstanceMethodReachabilityFacts.EXACT_RECEIVER_IS_ON_HEAP);
    }

    private static void markEnclosingTypeAsProvisionallyInvoked(InstanceMethodElement me, Facts facts) {
        facts.discover((Object)me.getEnclosingType().load(), (Fact)TypeReachabilityFacts.ELEMENT_IS_PROVISIONALLY_INVOKED);
    }

    private static void markEnclosingTypeAsProvisionallyDispatched(InstanceMethodElement me, Facts facts) {
        facts.discover((Object)me.getEnclosingType().load(), (Fact)TypeReachabilityFacts.ELEMENT_IS_PROVISIONALLY_DISPATCH_INVOKED);
    }

    private static void markAsInvoked(InstanceMethodElement me, Facts facts) {
        facts.discover((Object)me, (Fact)ExecutableReachabilityFacts.IS_INVOKED);
    }

    private static void markAsDispatchInvoked(InstanceMethodElement me, Facts facts) {
        facts.discover((Object)me, (Fact)InstanceMethodReachabilityFacts.IS_DISPATCH_INVOKED);
    }

    private static void markEnclosingAsInstantiatedIfCtor(ExecutableElement e, Facts facts) {
        if (e instanceof ConstructorElement) {
            ConstructorElement ce = (ConstructorElement)e;
            LoadedTypeDefinition type = ce.getEnclosingType().load();
            CompilationContext ctxt = type.getContext().getCompilationContext();
            Facts facts1 = Facts.get((CompilationContext)ctxt);
            facts1.discover((Object)type, (Fact)TypeReachabilityFacts.IS_INSTANTIATED);
        }
    }

    private static void markObjectTypeDefAsOnHeap(VmObject obj, Facts facts) {
        facts.discover((Object)obj.getVmClass().getTypeDefinition(), (Fact)TypeReachabilityFacts.IS_ON_HEAP);
        PhysicalObjectType objectType = obj.getObjectType();
        LoadedTypeDefinition def = objectType.getDefinition().load();
        int fc = def.getFieldCount();
        for (int i = 0; i < fc; ++i) {
            VmObject nested;
            InstanceFieldElement fe;
            FieldElement fieldElement = def.getField(i);
            if (!(fieldElement instanceof InstanceFieldElement) || !((fe = (InstanceFieldElement)fieldElement).getType() instanceof ReferenceType) || (nested = obj.getMemory().loadRef(fe.getOffset(), (ReadAccessMode)AccessModes.SinglePlain)) == null) continue;
            facts.discover((Object)nested, (Fact)ObjectReachabilityFacts.IS_REACHABLE);
        }
    }
}

