/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reachability;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.StaticFieldElement;

public class ReachabilityRoots {
    private static final AttachmentKey<ReachabilityRoots> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final Set<LoadedTypeDefinition> reflectiveClasses = ConcurrentHashMap.newKeySet();
    private final Set<ExecutableElement> reflectiveMethods = ConcurrentHashMap.newKeySet();
    private final Set<FieldElement> reflectiveFields = ConcurrentHashMap.newKeySet();
    private final Set<ExecutableElement> autoQueuedMethods = ConcurrentHashMap.newKeySet();
    private final Set<ExecutableElement> dispatchTableMethods = ConcurrentHashMap.newKeySet();

    private ReachabilityRoots(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static ReachabilityRoots get(CompilationContext ctxt) {
        ReachabilityRoots appearing;
        ReachabilityRoots info = (ReachabilityRoots)ctxt.getAttachment(KEY);
        if (info == null && (appearing = (ReachabilityRoots)ctxt.putAttachmentIfAbsent(KEY, (Object)(info = new ReachabilityRoots(ctxt)))) != null) {
            info = appearing;
        }
        return info;
    }

    public void reportStats() {
        ReachabilityInfo.LOGGER.debugf("  Auto-queued methods:           %s", this.autoQueuedMethods.size());
        ReachabilityInfo.LOGGER.debugf("  Reflectively accessed classes: %s", this.reflectiveClasses.size());
        ReachabilityInfo.LOGGER.debugf("  Reflectively accessed methods: %s", this.reflectiveMethods.size());
        ReachabilityInfo.LOGGER.debugf("  Reflectively accessed fields:  %s", this.reflectiveFields.size());
    }

    public void registerReflectiveClass(LoadedTypeDefinition ltd) {
        this.reflectiveClasses.add(ltd);
    }

    public boolean registerReflectiveMethod(MethodElement e) {
        boolean added = this.reflectiveMethods.add((ExecutableElement)e);
        if (added) {
            this.ctxt.enqueue((ExecutableElement)e);
        }
        return added;
    }

    public boolean registerReflectiveConstructor(ConstructorElement e) {
        boolean added = this.reflectiveMethods.add((ExecutableElement)e);
        if (added) {
            this.ctxt.enqueue((ExecutableElement)e);
        }
        return added;
    }

    public boolean registerAutoQueuedElement(ExecutableElement e) {
        boolean added = this.autoQueuedMethods.add(e);
        if (added) {
            this.ctxt.enqueue(e);
        }
        return added;
    }

    public boolean registerDispatchTableEntry(ExecutableElement e) {
        return this.dispatchTableMethods.add(e);
    }

    public boolean registerReflectiveField(FieldElement f) {
        return this.reflectiveFields.add(f);
    }

    public static void processRootsForAnalyze(CompilationContext ctxt) {
        ReachabilityRoots roots = ReachabilityRoots.get(ctxt);
        ReachabilityInfo info = ReachabilityInfo.get(ctxt);
        for (ExecutableElement e : roots.autoQueuedMethods) {
            info.processRootReachableElement(e);
        }
        for (LoadedTypeDefinition ltd : roots.reflectiveClasses) {
            ReachabilityInfo.LOGGER.debugf("Reflectively accessed type %s made reachable", (Object)ltd.toString());
            info.getAnalysis().processReachableType(ltd, null);
        }
        for (ExecutableElement e : roots.reflectiveMethods) {
            info.processRootReachableElement(e);
        }
        for (FieldElement f : roots.reflectiveFields) {
            if (!f.isStatic()) continue;
            info.getAnalysis().processReachableStaticFieldAccess((StaticFieldElement)f, null);
        }
    }

    public static void processRootsForLower(CompilationContext ctxt) {
        ReachabilityRoots roots = ReachabilityRoots.get(ctxt);
        for (ExecutableElement e : roots.autoQueuedMethods) {
            if (!e.isStatic()) continue;
            ctxt.enqueue(e);
        }
        for (ExecutableElement e : roots.reflectiveMethods) {
            if (!e.isStatic()) continue;
            ctxt.enqueue(e);
        }
        for (ExecutableElement e : roots.dispatchTableMethods) {
            ctxt.enqueue(e);
        }
    }

    public Set<LoadedTypeDefinition> getReflectiveClasses() {
        return new HashSet<LoadedTypeDefinition>(this.reflectiveClasses);
    }

    public Set<FieldElement> getReflectiveFields() {
        return new HashSet<FieldElement>(this.reflectiveFields);
    }

    public Set<ExecutableElement> getReflectiveMethods() {
        return new HashSet<ExecutableElement>(this.reflectiveMethods);
    }
}

