/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reachability;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.atomic.WriteAccessMode;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmClassLoader;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmReferenceArray;
import org.qbicc.plugin.apploader.AppClassLoader;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.FieldElement;

public class ServiceLoaderAnalyzer {
    private static final AttachmentKey<ServiceLoaderAnalyzer> KEY = new AttachmentKey();
    private static final List<LoadedTypeDefinition> NONE = List.of();
    static final String SERVICE_DIR = "META-INF/services";
    private final CompilationContext ctxt;
    private final Map<LoadedTypeDefinition, List<LoadedTypeDefinition>> serviceProviders = new ConcurrentHashMap<LoadedTypeDefinition, List<LoadedTypeDefinition>>();

    private ServiceLoaderAnalyzer(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static ServiceLoaderAnalyzer get(CompilationContext ctxt) {
        ServiceLoaderAnalyzer appearing;
        ServiceLoaderAnalyzer info = (ServiceLoaderAnalyzer)ctxt.getAttachment(KEY);
        if (info == null && (appearing = (ServiceLoaderAnalyzer)ctxt.putAttachmentIfAbsent(KEY, (Object)(info = new ServiceLoaderAnalyzer(ctxt)))) != null) {
            info = appearing;
        }
        return info;
    }

    public List<LoadedTypeDefinition> getProviders(LoadedTypeDefinition service) {
        List<LoadedTypeDefinition> cachedProviders = this.serviceProviders.get(service);
        if (cachedProviders != null) {
            return cachedProviders;
        }
        ArrayList<LoadedTypeDefinition> providers = new ArrayList<LoadedTypeDefinition>();
        String pcName = "META-INF/services/" + service.getInternalName().replace('/', '.');
        ServiceLoaderAnalyzer.findProviders(pcName, this.ctxt.getBootstrapClassContext(), providers);
        VmClassLoader appCl = AppClassLoader.get((CompilationContext)this.ctxt).getAppClassLoader();
        if (appCl != null) {
            ServiceLoaderAnalyzer.findProviders(pcName, appCl.getClassContext(), providers);
        }
        List<LoadedTypeDefinition> result = providers.isEmpty() ? NONE : List.copyOf(providers);
        this.serviceProviders.put(service, result);
        return result;
    }

    private static void findProviders(String pcName, ClassContext classContext, ArrayList<LoadedTypeDefinition> providers) {
        List files = classContext.getResources(pcName);
        for (byte[] f : files) {
            String[] lines;
            String pc = new String(f, StandardCharsets.UTF_8);
            for (String line : lines = pc.split(System.lineSeparator())) {
                LoadedTypeDefinition ltd;
                DefinedTypeDefinition dtd;
                int commentStart = line.indexOf(35);
                if (commentStart != -1) {
                    line = line.substring(0, commentStart).trim();
                }
                if ((line = line.trim()).isBlank() || (dtd = classContext.findDefinedType(line.replace('.', '/'))) == null || providers.contains(ltd = dtd.load())) continue;
                providers.add(ltd);
            }
        }
    }

    public void serializeProviderConfig() {
        VmClass classClass = this.ctxt.getBootstrapClassContext().findDefinedType("java/lang/Class").load().getVmClass();
        Vm vm = this.ctxt.getVm();
        ArrayList<VmReferenceArray> accumulator = new ArrayList<VmReferenceArray>();
        for (Map.Entry<LoadedTypeDefinition, List<LoadedTypeDefinition>> e : this.serviceProviders.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            VmObject[] inner = new VmObject[e.getValue().size() + 1];
            inner[0] = e.getKey().getVmClass();
            int cursor = 1;
            for (LoadedTypeDefinition t : e.getValue()) {
                inner[cursor++] = t.getVmClass();
            }
            accumulator.add(vm.newArrayOf(classClass, inner));
        }
        VmReferenceArray runtimeArray = vm.newArrayOf(classClass.getArrayClass().getVmClass(), accumulator.toArray(new VmObject[accumulator.size()]));
        LoadedTypeDefinition supportType = this.ctxt.getBootstrapClassContext().findDefinedType("java/util/QbiccServiceLoaderSupport").load();
        VmClass supportClass = supportType.getVmClass();
        FieldElement f = supportType.findField("providerConfigurationMapping");
        supportClass.getStaticMemory().storeRef((long)supportClass.indexOfStatic(f), (VmObject)runtimeArray, (WriteAccessMode)AccessModes.SinglePlain);
    }
}

