/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reachability;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jboss.logging.Logger;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.facts.Fact;
import org.qbicc.facts.Facts;
import org.qbicc.interpreter.VmObject;
import org.qbicc.plugin.coreclasses.CoreClasses;
import org.qbicc.plugin.reachability.RapidTypeAnalysis;
import org.qbicc.plugin.reachability.ReachabilityAnalysis;
import org.qbicc.plugin.reachability.ReachabilityRoots;
import org.qbicc.plugin.reachability.ServiceLoaderAnalyzer;
import org.qbicc.plugin.reachability.TypeReachabilityFacts;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.InvokableElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.StaticMethodElement;

public class ReachabilityInfo {
    static final Logger LOGGER = Logger.getLogger((String)"org.qbicc.plugin.reachability");
    private static final AttachmentKey<ReachabilityInfo> KEY = new AttachmentKey();
    private final Map<LoadedTypeDefinition, Set<LoadedTypeDefinition>> classHierarchy = new ConcurrentHashMap<LoadedTypeDefinition, Set<LoadedTypeDefinition>>();
    private final Map<LoadedTypeDefinition, Set<LoadedTypeDefinition>> interfaceHierarchy = new ConcurrentHashMap<LoadedTypeDefinition, Set<LoadedTypeDefinition>>();
    private final Set<MethodElement> dispatchableMethods = ConcurrentHashMap.newKeySet();
    private final Set<MethodElement> invokableInstanceMethods = ConcurrentHashMap.newKeySet();
    private final Set<FieldElement> accessedStaticField = ConcurrentHashMap.newKeySet();
    private final ReachabilityAnalysis analysis;
    private final CompilationContext ctxt;

    private ReachabilityInfo(CompilationContext ctxt) {
        this.analysis = new RapidTypeAnalysis(this, ctxt);
        this.ctxt = ctxt;
    }

    public static ReachabilityInfo get(CompilationContext ctxt) {
        ReachabilityInfo appearing;
        ReachabilityInfo info = (ReachabilityInfo)ctxt.getAttachment(KEY);
        if (info == null && (appearing = (ReachabilityInfo)ctxt.putAttachmentIfAbsent(KEY, (Object)(info = new ReachabilityInfo(ctxt)))) != null) {
            info = appearing;
        }
        return info;
    }

    public static void clear(CompilationContext ctxt) {
        ReachabilityInfo info = ReachabilityInfo.get(ctxt);
        info.classHierarchy.clear();
        info.interfaceHierarchy.clear();
        info.dispatchableMethods.clear();
        info.invokableInstanceMethods.clear();
        info.accessedStaticField.clear();
        info.analysis.clear();
    }

    public static void reportStats(CompilationContext ctxt) {
        ReachabilityInfo info = ReachabilityInfo.get(ctxt);
        LOGGER.debug((Object)"Reachability Statistics");
        LOGGER.debugf("  Reachable interfaces:          %s", info.interfaceHierarchy.size());
        LOGGER.debugf("  Reachable classes:             %s", info.classHierarchy.size());
        LOGGER.debugf("  Reachable functions:           %s", ctxt.numberEnqueued());
        LOGGER.debugf("  Dispatchable instance methods: %s", info.dispatchableMethods.size());
        LOGGER.debugf("  Invokable instance methods:    %s", info.invokableInstanceMethods.size());
        LOGGER.debugf("  Accessed static fields:        %s", info.accessedStaticField.size());
        ReachabilityRoots.get(ctxt).reportStats();
        info.analysis.reportStats();
    }

    public static void forceCoreClassesReachable(CompilationContext ctxt) {
        ReachabilityInfo info = ReachabilityInfo.get(ctxt);
        CoreClasses cc = CoreClasses.get((CompilationContext)ctxt);
        LOGGER.debugf("Forcing all array types reachable/instantiated", new Object[0]);
        String[] desc = new String[]{"[Z", "[B", "[C", "[S", "[I", "[F", "[J", "[D", "[ref"};
        LoadedTypeDefinition obj = ctxt.getBootstrapClassContext().findDefinedType("java/lang/Object").load();
        LoadedTypeDefinition cloneable = ctxt.getBootstrapClassContext().findDefinedType("java/lang/Cloneable").load();
        LoadedTypeDefinition serializable = ctxt.getBootstrapClassContext().findDefinedType("java/io/Serializable").load();
        info.analysis.processInstantiatedClass(obj, false, null);
        info.addReachableInterface(cloneable);
        info.addReachableInterface(serializable);
        for (String d : desc) {
            LoadedTypeDefinition at = cc.getArrayLoadedTypeDefinition(d);
            info.addInterfaceEdge(at, cloneable);
            info.addInterfaceEdge(at, serializable);
            info.analysis.processInstantiatedClass(at, false, null);
        }
        LOGGER.debugf("Forcing java.lang.Class reachable/instantiated", new Object[0]);
        LoadedTypeDefinition clz = ctxt.getBootstrapClassContext().findDefinedType("java/lang/Class").load();
        info.analysis.processInstantiatedClass(clz, false, null);
        LOGGER.debugf("Forcing jdk.internal.misc.Unsafe reachable/instantiated", new Object[0]);
        LoadedTypeDefinition unsafe = ctxt.getBootstrapClassContext().findDefinedType("jdk/internal/misc/Unsafe").load();
        info.analysis.processInstantiatedClass(unsafe, false, null);
        LOGGER.debugf("Forcing java.lang.Thread reachable/instantiated", new Object[0]);
        LoadedTypeDefinition thr = ctxt.getBootstrapClassContext().findDefinedType("java/lang/Thread").load();
        info.analysis.processInstantiatedClass(thr, false, null);
    }

    public static void processReachableElement(ExecutableElement elem) {
        ReachabilityInfo info = ReachabilityInfo.get(elem.getEnclosingType().getContext().getCompilationContext());
        info.processRootReachableElement(elem);
    }

    public void processRootReachableElement(ExecutableElement elem) {
        if (elem instanceof StaticMethodElement) {
            StaticMethodElement me = (StaticMethodElement)elem;
            this.analysis.processReachableType(me.getEnclosingType().load(), null);
            this.analysis.processReachableExactInvocation((InvokableElement)me, null);
        } else if (elem instanceof InstanceMethodElement) {
            InstanceMethodElement me = (InstanceMethodElement)elem;
            this.analysis.processReachableDispatchedInvocation((MethodElement)me, null);
        } else if (elem instanceof ConstructorElement) {
            ConstructorElement ce = (ConstructorElement)elem;
            this.analysis.processInstantiatedClass(ce.getEnclosingType().load(), false, null);
            this.analysis.processReachableExactInvocation((InvokableElement)ce, null);
        }
    }

    public boolean isDispatchableMethod(MethodElement meth) {
        return this.dispatchableMethods.contains(meth);
    }

    public boolean isInvokableInstanceMethod(MethodElement meth) {
        return this.invokableInstanceMethods.contains(meth);
    }

    public boolean isAccessedStaticField(FieldElement field) {
        return this.accessedStaticField.contains(field);
    }

    public boolean isReachableClass(LoadedTypeDefinition type) {
        return this.classHierarchy.containsKey(type);
    }

    public boolean isReachableInterface(LoadedTypeDefinition type) {
        return this.interfaceHierarchy.containsKey(type);
    }

    public void visitReachableInterfaces(Consumer<LoadedTypeDefinition> function) {
        for (LoadedTypeDefinition i : this.interfaceHierarchy.keySet()) {
            function.accept(i);
        }
    }

    public void visitReachableImplementors(LoadedTypeDefinition type, Consumer<LoadedTypeDefinition> function) {
        Set<LoadedTypeDefinition> implementors = this.interfaceHierarchy.get(type);
        if (implementors == null) {
            return;
        }
        HashSet<LoadedTypeDefinition> toProcess = new HashSet<LoadedTypeDefinition>();
        this.collectImplementors(type, toProcess);
        for (LoadedTypeDefinition cls : toProcess) {
            function.accept(cls);
        }
    }

    private void collectImplementors(LoadedTypeDefinition type, Set<LoadedTypeDefinition> toProcess) {
        Set<LoadedTypeDefinition> implementors = this.interfaceHierarchy.get(type);
        if (implementors == null) {
            return;
        }
        for (LoadedTypeDefinition child : implementors) {
            toProcess.add(child);
            if (child.isInterface()) {
                this.collectImplementors(child, toProcess);
                continue;
            }
            this.visitReachableSubclassesPreOrder(child, toProcess::add);
        }
    }

    public void visitReachableSubclassesPreOrder(LoadedTypeDefinition type, Consumer<LoadedTypeDefinition> function) {
        Set<LoadedTypeDefinition> subclasses = this.classHierarchy.get(type);
        if (subclasses == null) {
            return;
        }
        for (LoadedTypeDefinition sc : subclasses) {
            function.accept(sc);
            this.visitReachableSubclassesPreOrder(sc, function);
        }
    }

    public void visitReachableSubclassesPostOrder(LoadedTypeDefinition type, Consumer<LoadedTypeDefinition> function) {
        Set<LoadedTypeDefinition> subclasses = this.classHierarchy.get(type);
        if (subclasses == null) {
            return;
        }
        for (LoadedTypeDefinition sc : subclasses) {
            this.visitReachableSubclassesPostOrder(sc, function);
            function.accept(sc);
        }
    }

    public void visitReachableTypes(Consumer<LoadedTypeDefinition> function) {
        for (LoadedTypeDefinition t : this.classHierarchy.keySet()) {
            function.accept(t);
        }
        for (LoadedTypeDefinition t : this.interfaceHierarchy.keySet()) {
            function.accept(t);
        }
    }

    ReachabilityAnalysis getAnalysis() {
        return this.analysis;
    }

    void processAsService(LoadedTypeDefinition type) {
        List<LoadedTypeDefinition> providers = ServiceLoaderAnalyzer.get(this.ctxt).getProviders(type);
        if (!providers.isEmpty()) {
            for (LoadedTypeDefinition pc : providers) {
                LOGGER.debugf("ServiceLoader[%s] ==> %s", (Object)type.getInternalName(), (Object)pc.getInternalName());
                this.analysis.processReachableType(pc, null);
                if (pc.isInterface()) continue;
                this.analysis.processInstantiatedClass(pc, true, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReachableInterface(LoadedTypeDefinition type) {
        if (this.isReachableInterface(type)) {
            return;
        }
        ReachabilityInfo reachabilityInfo = this;
        synchronized (reachabilityInfo) {
            this.interfaceHierarchy.computeIfAbsent(type, t -> ConcurrentHashMap.newKeySet());
            for (LoadedTypeDefinition loadedTypeDefinition : type.getInterfaces()) {
                this.addReachableInterface(loadedTypeDefinition);
                this.addInterfaceEdge(type, loadedTypeDefinition);
            }
            block4: for (LoadedTypeDefinition loadedTypeDefinition : type.getInstanceMethods()) {
                if (this.isDispatchableMethod((MethodElement)loadedTypeDefinition)) continue;
                for (LoadedTypeDefinition si : type.getInterfaces()) {
                    MethodElement sm = si.resolveMethodElementInterface(loadedTypeDefinition.getName(), loadedTypeDefinition.getDescriptor());
                    if (sm == null || !this.isDispatchableMethod(sm)) continue;
                    LOGGER.debugf("\tnewly reachable interface: dispatchable method:  %s", (Object)loadedTypeDefinition);
                    this.analysis.processReachableDispatchedInvocation((MethodElement)loadedTypeDefinition, null);
                    continue block4;
                }
            }
            this.analysis.processReachableObject((VmObject)type.getVmClass(), null);
            Facts.get((CompilationContext)this.ctxt).discover((Object)type, (Fact)TypeReachabilityFacts.HAS_CLASS);
            this.processAsService(type);
        }
    }

    private void addInterfaceEdge(LoadedTypeDefinition child, LoadedTypeDefinition parent) {
        this.interfaceHierarchy.computeIfAbsent(parent, t -> ConcurrentHashMap.newKeySet()).add(child);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addReachableClass(LoadedTypeDefinition type) {
        if (this.isReachableClass(type)) {
            return;
        }
        ReachabilityInfo reachabilityInfo = this;
        synchronized (reachabilityInfo) {
            this.classHierarchy.computeIfAbsent(type, t -> ConcurrentHashMap.newKeySet());
            LoadedTypeDefinition superClass = type.getSuperClass();
            if (superClass != null) {
                this.addReachableClass(superClass);
                this.classHierarchy.get(superClass).add(type);
            }
            for (LoadedTypeDefinition loadedTypeDefinition : type.getInterfaces()) {
                this.addReachableInterface(loadedTypeDefinition);
                this.addInterfaceEdge(type, loadedTypeDefinition);
            }
            type.getVmClass();
            block4: for (LoadedTypeDefinition loadedTypeDefinition : type.getInstanceMethods()) {
                MethodElement overiddenMethod;
                if (this.isDispatchableMethod((MethodElement)loadedTypeDefinition)) continue;
                if (type.hasSuperClass() && (overiddenMethod = type.getSuperClass().resolveMethodElementVirtual(type.getContext(), loadedTypeDefinition.getName(), loadedTypeDefinition.getDescriptor())) != null && this.isDispatchableMethod(overiddenMethod)) {
                    LOGGER.debugf("\tnewly reachable class: dispatchable method %s from %s", (Object)loadedTypeDefinition, (Object)type.getSuperClass());
                    this.analysis.processReachableDispatchedInvocation((MethodElement)loadedTypeDefinition, null);
                    continue;
                }
                for (LoadedTypeDefinition i : type.getInterfaces()) {
                    MethodElement sm = i.resolveMethodElementInterface(loadedTypeDefinition.getName(), loadedTypeDefinition.getDescriptor());
                    if (sm == null || !this.isDispatchableMethod(sm)) continue;
                    LOGGER.debugf("\tnewly reachable class: dispatchable method: %s from %s", (Object)loadedTypeDefinition, (Object)i);
                    this.analysis.processReachableDispatchedInvocation((MethodElement)loadedTypeDefinition, null);
                    continue block4;
                }
            }
            this.analysis.processReachableObject((VmObject)type.getVmClass(), null);
            Facts.get((CompilationContext)this.ctxt).discover((Object)type, (Fact)TypeReachabilityFacts.HAS_CLASS);
            this.processAsService(type);
        }
    }

    void addReachableType(LoadedTypeDefinition type) {
        if (type.isInterface()) {
            this.addReachableInterface(type);
        } else {
            this.addReachableClass(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDispatchableMethod(MethodElement meth) {
        if (this.dispatchableMethods.contains(meth)) {
            return;
        }
        ReachabilityInfo reachabilityInfo = this;
        synchronized (reachabilityInfo) {
            this.addReachableType(meth.getEnclosingType().load());
            this.dispatchableMethods.add(meth);
            LoadedTypeDefinition definingClass = meth.getEnclosingType().load();
            if (definingClass.isInterface()) {
                this.visitReachableImplementors(definingClass, c -> {
                    MethodElement cand = c.isInterface() ? c.resolveMethodElementInterface(meth.getName(), meth.getDescriptor()) : c.resolveMethodElementVirtual(definingClass.getContext(), meth.getName(), meth.getDescriptor());
                    if (cand != null && !this.isDispatchableMethod(cand)) {
                        LOGGER.debugf("\tnewly dispatchable method due to down propagation: %s", (Object)cand);
                        this.analysis.processReachableDispatchedInvocation(cand, null);
                    }
                });
            } else {
                this.visitReachableSubclassesPreOrder(definingClass, sc -> {
                    MethodElement cand = sc.resolveMethodElementVirtual(definingClass.getContext(), meth.getName(), meth.getDescriptor());
                    if (cand != null && !this.isDispatchableMethod(cand)) {
                        LOGGER.debugf("\tnewly dispatchable method due to down propagation: %s", (Object)cand);
                        this.analysis.processReachableDispatchedInvocation(cand, null);
                    }
                });
                for (LoadedTypeDefinition ancestor = definingClass.getSuperClass(); ancestor != null; ancestor = ancestor.getSuperClass()) {
                    MethodElement cand = ancestor.resolveMethodElementVirtual(definingClass.getContext(), meth.getName(), meth.getDescriptor());
                    if (cand == null || this.isDispatchableMethod(cand)) continue;
                    LOGGER.debugf("\tnewly dispatchable method due to up propagation: %s", (Object)cand);
                    this.analysis.processReachableDispatchedInvocation(cand, null);
                }
            }
        }
    }

    void addInvokableInstanceMethod(MethodElement meth) {
        this.invokableInstanceMethods.add(meth);
    }

    void addAccessedStaticField(FieldElement field) {
        this.accessedStaticField.add(field);
    }
}

