/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.plugin.reachability;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.CompilationContext;
import org.qbicc.plugin.reachability.ReachabilityInfo;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.StaticFieldElement;

public class ReachabilityRoots {
    private static final AttachmentKey<ReachabilityRoots> KEY = new AttachmentKey();
    private final CompilationContext ctxt;
    private final Set<ExecutableElement> reflectiveMethods = ConcurrentHashMap.newKeySet();
    private final Set<StaticFieldElement> heapRoots = ConcurrentHashMap.newKeySet();
    private final Set<ExecutableElement> autoQueuedMethods = ConcurrentHashMap.newKeySet();
    private final Set<ExecutableElement> dispatchTableMethods = ConcurrentHashMap.newKeySet();

    private ReachabilityRoots(CompilationContext ctxt) {
        this.ctxt = ctxt;
    }

    public static ReachabilityRoots get(CompilationContext ctxt) {
        ReachabilityRoots appearing;
        ReachabilityRoots info = (ReachabilityRoots)ctxt.getAttachment(KEY);
        if (info == null && (appearing = (ReachabilityRoots)ctxt.putAttachmentIfAbsent(KEY, (Object)(info = new ReachabilityRoots(ctxt)))) != null) {
            info = appearing;
        }
        return info;
    }

    public void reportStats() {
        ReachabilityInfo.LOGGER.debugf("  Auto-queued methods:           %s", this.autoQueuedMethods.size());
        ReachabilityInfo.LOGGER.debugf("  Reflectively accessed methods: %s", this.reflectiveMethods.size());
        ReachabilityInfo.LOGGER.debugf("  Reflective heap roots (statics): %s", this.heapRoots.size());
    }

    public boolean registerReflectiveEntrypoint(ExecutableElement e) {
        boolean added = this.reflectiveMethods.add(e);
        if (added) {
            this.ctxt.enqueue(e);
        }
        return added;
    }

    public boolean registerAutoQueuedElement(ExecutableElement e) {
        boolean added = this.autoQueuedMethods.add(e);
        if (added) {
            this.ctxt.enqueue(e);
        }
        return added;
    }

    public boolean registerDispatchTableEntry(ExecutableElement e) {
        return this.dispatchTableMethods.add(e);
    }

    public boolean registerHeapRoot(StaticFieldElement f) {
        return this.heapRoots.add(f);
    }

    public static void processRootsForAnalyze(CompilationContext ctxt) {
        ReachabilityRoots roots = ReachabilityRoots.get(ctxt);
        ReachabilityInfo info = ReachabilityInfo.get(ctxt);
        for (ExecutableElement e : roots.autoQueuedMethods) {
            info.processRootReachableElement(e);
        }
        for (ExecutableElement e : roots.reflectiveMethods) {
            info.processRootReachableElement(e);
        }
        for (StaticFieldElement f : roots.heapRoots) {
            info.getAnalysis().processReachableStaticFieldAccess(f, null);
        }
    }

    public static void processRootsForLower(CompilationContext ctxt) {
        ReachabilityRoots roots = ReachabilityRoots.get(ctxt);
        for (ExecutableElement e : roots.autoQueuedMethods) {
            if (!e.isStatic()) continue;
            ctxt.enqueue(e);
        }
        for (ExecutableElement e : roots.reflectiveMethods) {
            if (!e.isStatic()) continue;
            ctxt.enqueue(e);
        }
        for (ExecutableElement e : roots.dispatchTableMethods) {
            ctxt.enqueue(e);
        }
    }
}

