/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.runtime.linux;

import org.qbicc.runtime.CNative;
import org.qbicc.runtime.linux.SysSyscall;
import org.qbicc.runtime.stdc.Stdint;
import org.qbicc.runtime.stdc.Time;

@CNative.include(value="<linux/futex.h>")
public class Futex {
    public static final CNative.c_int FUTEX_PRIVATE_FLAG = (CNative.c_int)CNative.constant();
    public static final CNative.c_int FUTEX_CLOCK_REALTIME = (CNative.c_int)CNative.constant();
    public static final CNative.c_int FUTEX_WAIT = (CNative.c_int)CNative.constant();
    public static final CNative.c_int FUTEX_WAIT_BITSET = (CNative.c_int)CNative.constant();
    public static final CNative.c_int FUTEX_WAKE = (CNative.c_int)CNative.constant();
    public static final Stdint.uint32_t FUTEX_BITSET_MATCH_ANY = (Stdint.uint32_t)CNative.constant();

    private static CNative.c_long futex(Stdint.uint32_t_ptr uaddr, CNative.c_int futex_op, Stdint.uint32_t val, Time.const_struct_timespec_ptr timeout, Stdint.uint32_t_ptr uaddr2, Stdint.uint32_t val3) {
        return SysSyscall.syscall(SysSyscall.SYS_futex, new CNative.object[]{uaddr, futex_op, val, timeout, uaddr2, val3});
    }

    public static boolean futex_wait(Stdint.uint32_t_ptr uaddr, Stdint.uint32_t val, Time.const_struct_timespec_ptr timeout) {
        return Futex.futex(uaddr, (CNative.c_int)CNative.word((int)(FUTEX_WAIT.intValue() | FUTEX_PRIVATE_FLAG.intValue())), val, timeout, (Stdint.uint32_t_ptr)CNative.zero(), (Stdint.uint32_t)CNative.zero()).longValue() != -1L;
    }

    public static boolean futex_wait_absolute(Stdint.uint32_t_ptr uaddr, Stdint.uint32_t val, Time.const_struct_timespec_ptr timeout) {
        return Futex.futex(uaddr, (CNative.c_int)CNative.word((int)(FUTEX_WAIT_BITSET.intValue() | FUTEX_PRIVATE_FLAG.intValue())), val, timeout, (Stdint.uint32_t_ptr)CNative.zero(), FUTEX_BITSET_MATCH_ANY).longValue() != -1L;
    }

    public static boolean futex_wake_single(Stdint.uint32_t_ptr uaddr) {
        return Futex.futex(uaddr, (CNative.c_int)CNative.word((int)(FUTEX_WAKE.intValue() | FUTEX_PRIVATE_FLAG.intValue())), (Stdint.uint32_t)CNative.word((int)1), (Time.const_struct_timespec_ptr)CNative.zero(), (Stdint.uint32_t_ptr)CNative.zero(), (Stdint.uint32_t)CNative.zero()).longValue() != -1L;
    }

    public static boolean futex_wake_all(Stdint.uint32_t_ptr uaddr) {
        return Futex.futex(uaddr, (CNative.c_int)CNative.word((int)(FUTEX_WAKE.intValue() | FUTEX_PRIVATE_FLAG.intValue())), (Stdint.uint32_t)CNative.word((int)Integer.MAX_VALUE), (Time.const_struct_timespec_ptr)CNative.zero(), (Stdint.uint32_t_ptr)CNative.zero(), (Stdint.uint32_t)CNative.zero()).longValue() != -1L;
    }
}

