/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.test;

import io.smallrye.common.constraint.Assert;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Optional;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.driver.BaseDiagnosticContext;
import org.qbicc.driver.Driver;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.machine.arch.ObjectType;
import org.qbicc.machine.arch.Platform;
import org.qbicc.machine.object.ObjectFileProvider;
import org.qbicc.machine.tool.CToolChain;
import org.qbicc.tool.llvm.LlvmToolChain;
import org.qbicc.type.TypeSystem;

public abstract class AbstractCompilerTestCase {
    public static CompilationContext ctxt;
    public static ClassContext bootClassContext;
    public static TypeSystem ts;
    public static LiteralFactory lf;
    private static Driver driver;

    @BeforeAll
    protected static void setUp() {
        Driver.Builder builder = Driver.builder();
        builder.setInitialContext(new BaseDiagnosticContext());
        builder.setOutputDirectory(Path.of(System.getProperty("user.dir", "."), "target", "test-fwk"));
        Platform platform = AbstractCompilerTestCase.getPlatform();
        builder.setTargetPlatform(platform);
        Optional ofp = ObjectFileProvider.findProvider((ObjectType)platform.getObjectType(), (ClassLoader)AbstractCompilerTestCase.class.getClassLoader());
        if (ofp.isEmpty()) {
            Assertions.fail((String)("No object file provider found for " + platform));
            throw Assert.unreachableCode();
        }
        builder.setObjectFileProvider((ObjectFileProvider)ofp.get());
        Iterator toolChains = CToolChain.findAllCToolChains((Platform)platform, t -> true, (ClassLoader)AbstractCompilerTestCase.class.getClassLoader()).iterator();
        if (!toolChains.hasNext()) {
            Assertions.fail((String)("No tool chains found for " + platform));
            throw Assert.unreachableCode();
        }
        builder.setToolChain((CToolChain)toolChains.next());
        Iterator llvmTools = LlvmToolChain.findAllLlvmToolChains((Platform)platform, t -> true, (ClassLoader)AbstractCompilerTestCase.class.getClassLoader()).iterator();
        LlvmToolChain llvmToolChain = null;
        while (llvmTools.hasNext() && (llvmToolChain = (LlvmToolChain)llvmTools.next()).compareVersionTo("12") < 0) {
            llvmToolChain = null;
        }
        if (llvmToolChain == null) {
            Assertions.fail((String)"No LLVM tool chain found");
            throw Assert.unreachableCode();
        }
        builder.setLlvmToolChain(llvmToolChain);
        TypeSystem.Builder tsBuilder = TypeSystem.builder();
        TypeSystem ts = tsBuilder.build();
        builder.setTypeSystem(ts);
        AbstractCompilerTestCase.ts = ts;
        builder.setVmFactory(CompilationContext::getVm);
        Driver driver = builder.build();
        ctxt = driver.getCompilationContext();
        bootClassContext = ctxt.getBootstrapClassContext();
        lf = ctxt.getLiteralFactory();
        AbstractCompilerTestCase.driver = driver;
    }

    @AfterAll
    protected static void cleanUp() {
        driver.close();
    }

    static Platform getPlatform() {
        return Platform.HOST_PLATFORM;
    }
}

