/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DateBased {
    private static Class<?>[] TYPES = new Class[]{Calendar.class, Date.class, GregorianCalendar.class, XMLGregorianCalendar.class};
    private static Set<Class<?>> TYPES_SET = new HashSet(Arrays.asList(TYPES));
    private final Set<Class<?>> _checkerFalse = new HashSet();
    private final Set<Class<?>> _checkerTrue = new HashSet();
    private Checker checker = type -> {
        if (this._checkerTrue.contains(type)) {
            return true;
        }
        if (this._checkerFalse.contains(type)) {
            return false;
        }
        for (Class<?> e : TYPES_SET) {
            if (!e.isAssignableFrom(type)) continue;
            this._checkerTrue.add(type);
            return true;
        }
        this._checkerFalse.add(type);
        return false;
    };
    private ToBson toBson = value -> {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (Date.class.isAssignableFrom(type)) {
            return (Date)value;
        }
        if (GregorianCalendar.class.isAssignableFrom(type)) {
            return ((GregorianCalendar)value).getTime();
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(type)) {
            return ((XMLGregorianCalendar)value).toGregorianCalendar().getTime();
        }
        throw new IllegalStateException("Failed to convert value to Bson: " + value);
    };
    private ToObject toObject = (type, value) -> {
        if (value == null) {
            return null;
        }
        if (Date.class.isAssignableFrom(type)) {
            return value;
        }
        if (GregorianCalendar.class.isAssignableFrom(type)) {
            GregorianCalendar ret = new GregorianCalendar();
            ret.setTime(value);
            return ret;
        }
        if (Calendar.class.isAssignableFrom(type)) {
            Calendar ret = Calendar.getInstance();
            ret.setTime(value);
            return ret;
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(type)) {
            try {
                GregorianCalendar ret = new GregorianCalendar();
                ret.setTime(value);
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(ret);
            }
            catch (DatatypeConfigurationException e) {
                throw new IllegalStateException("Failed to convert value to Java XMLGregorianCalendar object: " + value, e);
            }
        }
        throw new IllegalStateException("Failed to convert value to Java object: " + value);
    };

    public Checker getChecker() {
        return this.checker;
    }

    public ToBson getToBson() {
        return this.toBson;
    }

    public ToObject getToObject() {
        return this.toObject;
    }

    public void setChecker(Checker checker) {
        this.checker = Objects.requireNonNull(checker);
    }

    public void setToBson(ToBson toBson) {
        this.toBson = Objects.requireNonNull(toBson);
    }

    public void setToObject(ToObject toObject) {
        this.toObject = Objects.requireNonNull(toObject);
    }

    @FunctionalInterface
    public static interface Checker {
        public boolean check(Class<?> var1);
    }

    @FunctionalInterface
    public static interface ToBson {
        public Date convert(Object var1);
    }

    @FunctionalInterface
    public static interface ToObject {
        public Object convert(Class<?> var1, Date var2);
    }
}

