/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.bson.types.Binary;
import org.bson.types.ObjectId;
import org.qnixyz.jbson.JaxBsonConfiguration;

public class JaxBsonToBson {
    private BinaryCollectionToBson binaryCollectionToBson = (cfg, destField, src) -> {
        ArrayList ret = new ArrayList();
        src.forEach(e -> ret.add(cfg.getToBson().getBinaryToBson().convert(cfg, destField, (Binary)e)));
        return ret;
    };
    private BinaryToBson binaryToBson = (cfg, destField, src) -> src;
    private BooleanArrayToBson booleanArrayToBson = (cfg, destField, src) -> {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Boolean e : src) {
            ret.add(cfg.getToBson().getBooleanToBson().convert(cfg, destField, e));
        }
        return ret;
    };
    private BooleanCollectionToBson booleanCollectionToBson = (cfg, destField, src) -> {
        ArrayList ret = new ArrayList();
        src.forEach(e -> ret.add(cfg.getToBson().getBooleanToBson().convert(cfg, destField, (Boolean)e)));
        return ret;
    };
    private BooleanPrimArrayToBson booleanPrimArrayToBson = (cfg, destField, src) -> Arrays.asList(ArrayUtils.toObject((boolean[])src));
    private BooleanPrimToBson booleanPrimToBson = (cfg, destField, src) -> src;
    private BooleanToBson booleanToBson = (cfg, destField, src) -> src;
    private ByteArrayToBson byteArrayToBson = (cfg, destField, src) -> new Binary(ArrayUtils.toPrimitive((Byte[])src));
    private ByteCollectionToBson byteCollectionToBson = (cfg, destField, src) -> {
        byte[] ret = new byte[src.size()];
        int i = 0;
        for (Byte e : src) {
            if (e != null) {
                ret[i] = e;
            }
            ++i;
        }
        return new Binary(ret);
    };
    private BytePrimArrayToBson bytePrimArrayToBson = (cfg, destField, src) -> new Binary(src);
    private BytePrimToBson bytePrimToBson = (cfg, destField, src) -> new Binary(new byte[]{src});
    private ByteToBson byteToBson = (cfg, destField, src) -> new Binary(new byte[]{src});
    private CharacterArrayToBson characterArrayToBson = (cfg, destField, src) -> new String(ArrayUtils.toPrimitive((Character[])src));
    private CharacterCollectionToBson characterCollectionToBson = (cfg, destField, src) -> {
        char[] ret = new char[src.size()];
        int i = 0;
        for (Character e : src) {
            if (e != null) {
                ret[i] = e.charValue();
            }
            ++i;
        }
        return new String(ret);
    };
    private CharacterPrimArrayToBson characterPrimArrayToBson = (cfg, destField, src) -> new String(src);
    private CharacterPrimToBson characterPrimToBson = (cfg, destField, src) -> Character.valueOf(src).toString();
    private CharacterToBson characterToBson = (cfg, destField, src) -> src.toString();
    private DateBasedArrayToBson dateBasedArrayToBson = (cfg, destField, src) -> {
        ArrayList<Date> ret = new ArrayList<Date>();
        for (Object e : src) {
            ret.add(cfg.getDateBased().getToBson().convert(e));
        }
        return ret;
    };
    private DateBasedCollectionToBson dateBasedCollectionToBson = (cfg, destField, src) -> {
        ArrayList ret = new ArrayList();
        src.forEach(e -> ret.add(cfg.getDateBased().getToBson().convert(e)));
        return ret;
    };
    private DateBasedToBson dateBasedToBson = (cfg, destField, src) -> cfg.getDateBased().getToBson().convert(src);
    private DoublePrimArrayToBson doublePrimArrayToBson = (cfg, destField, src) -> Arrays.asList(ArrayUtils.toObject((double[])src));
    private EnumArrayToBson enumArrayToBson = (cfg, destField, enumType, src) -> {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Enum e : src) {
            ret.add(cfg.getToBson().getEnumToBson().convert(cfg, destField, enumType, e));
        }
        return ret;
    };
    private EnumCollectionToBson enumCollectionToBson = (cfg, destField, enumType, src) -> {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Enum e : src) {
            ret.add(cfg.getToBson().getEnumToBson().convert(cfg, destField, enumType, e));
        }
        return ret;
    };
    private EnumToBson enumToBson = (cfg, destField, enumType, src) -> cfg.getIndexedEnum(enumType).enumToString(src);
    private FloatPrimArrayToBson floatPrimArrayToBson = (cfg, destField, src) -> {
        ArrayList<Object> ret = new ArrayList<Object>();
        float[] fArray = src;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float e = Float.valueOf(fArray[i]);
            ret.add(cfg.getToBson().getFloatPrimToBson().convert(cfg, destField, e.floatValue()));
        }
        return ret;
    };
    private FloatPrimToBson floatPrimToBson = (cfg, destField, src) -> Float.valueOf(src).doubleValue();
    private IntegerPrimArrayToBson integerPrimArrayToBson = (cfg, destField, src) -> Arrays.asList(ArrayUtils.toObject((int[])src));
    private LongPrimArrayToBson longPrimArrayToBson = (cfg, destField, src) -> Arrays.asList(ArrayUtils.toObject((long[])src));
    private NumberBasedArrayToBson numberBasedArrayToBson = (cfg, destField, src) -> {
        ArrayList<Number> ret = new ArrayList<Number>();
        for (Object e : src) {
            ret.add(cfg.getNumberBased().getToBson().convert(e).getValue());
        }
        return ret;
    };
    private NumberBasedCollectionToBson numberBasedCollectionToBson = (cfg, destField, src) -> {
        ArrayList ret = new ArrayList();
        src.forEach(e -> ret.add(cfg.getNumberBased().getToBson().convert(e).getValue()));
        return ret;
    };
    private NumberBasedToBson numberBasedToBson = (cfg, destField, src) -> cfg.getNumberBased().getToBson().convert(src).getValue();
    private ObjectIdArrayToBson objectIdArrayToBson = (cfg, destField, src) -> Arrays.asList(src);
    private ObjectIdCollectionToBson objectIdCollectionToBson = (cfg, destField, src) -> src;
    private ObjectIdToBson objectIdToBson = (cfg, destField, src) -> src;
    private ShortPrimArrayToBson shortPrimArrayToBson = (cfg, destField, src) -> {
        ArrayList<Object> ret = new ArrayList<Object>();
        short[] sArray = src;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            Short e = sArray[i];
            ret.add(cfg.getToBson().getShortPrimToBson().convert(cfg, destField, e));
        }
        return ret;
    };
    private ShortPrimToBson shortPrimToBson = (cfg, destField, src) -> Short.valueOf(src).intValue();
    private StringBasedArrayToBson stringBasedArrayToBson = (cfg, destField, src) -> {
        ArrayList<String> ret = new ArrayList<String>();
        for (Object e : src) {
            ret.add(cfg.getStringBased().getToBson().convert(e));
        }
        return ret;
    };
    private StringBasedCollectionToBson stringBasedCollectionToBson = (cfg, destField, src) -> {
        ArrayList ret = new ArrayList();
        src.forEach(e -> ret.add(cfg.getStringBased().getToBson().convert(e)));
        return ret;
    };
    private StringBasedToBson stringBasedToBson = (cfg, destField, src) -> cfg.getStringBased().getToBson().convert(src);

    public BinaryCollectionToBson getBinaryCollectionToBson() {
        return this.binaryCollectionToBson;
    }

    public BinaryToBson getBinaryToBson() {
        return this.binaryToBson;
    }

    public BooleanArrayToBson getBooleanArrayToBson() {
        return this.booleanArrayToBson;
    }

    public BooleanCollectionToBson getBooleanCollectionToBson() {
        return this.booleanCollectionToBson;
    }

    public BooleanPrimArrayToBson getBooleanPrimArrayToBson() {
        return this.booleanPrimArrayToBson;
    }

    public BooleanPrimToBson getBooleanPrimToBson() {
        return this.booleanPrimToBson;
    }

    public BooleanToBson getBooleanToBson() {
        return this.booleanToBson;
    }

    public ByteArrayToBson getByteArrayToBson() {
        return this.byteArrayToBson;
    }

    public ByteCollectionToBson getByteCollectionToBson() {
        return this.byteCollectionToBson;
    }

    public BytePrimArrayToBson getBytePrimArrayToBson() {
        return this.bytePrimArrayToBson;
    }

    public BytePrimToBson getBytePrimToBson() {
        return this.bytePrimToBson;
    }

    public ByteToBson getByteToBson() {
        return this.byteToBson;
    }

    public CharacterArrayToBson getCharacterArrayToBson() {
        return this.characterArrayToBson;
    }

    public CharacterCollectionToBson getCharacterCollectionToBson() {
        return this.characterCollectionToBson;
    }

    public CharacterPrimArrayToBson getCharacterPrimArrayToBson() {
        return this.characterPrimArrayToBson;
    }

    public CharacterPrimToBson getCharacterPrimToBson() {
        return this.characterPrimToBson;
    }

    public CharacterToBson getCharacterToBson() {
        return this.characterToBson;
    }

    public DateBasedArrayToBson getDateBasedArrayToBson() {
        return this.dateBasedArrayToBson;
    }

    public DateBasedCollectionToBson getDateBasedCollectionToBson() {
        return this.dateBasedCollectionToBson;
    }

    public DateBasedToBson getDateBasedToBson() {
        return this.dateBasedToBson;
    }

    public DoublePrimArrayToBson getDoublePrimArrayToBson() {
        return this.doublePrimArrayToBson;
    }

    public EnumArrayToBson getEnumArrayToBson() {
        return this.enumArrayToBson;
    }

    public EnumCollectionToBson getEnumCollectionToBson() {
        return this.enumCollectionToBson;
    }

    public EnumToBson getEnumToBson() {
        return this.enumToBson;
    }

    public FloatPrimArrayToBson getFloatPrimArrayToBson() {
        return this.floatPrimArrayToBson;
    }

    public FloatPrimToBson getFloatPrimToBson() {
        return this.floatPrimToBson;
    }

    public IntegerPrimArrayToBson getIntegerPrimArrayToBson() {
        return this.integerPrimArrayToBson;
    }

    public LongPrimArrayToBson getLongPrimArrayToBson() {
        return this.longPrimArrayToBson;
    }

    public NumberBasedArrayToBson getNumberBasedArrayToBson() {
        return this.numberBasedArrayToBson;
    }

    public NumberBasedCollectionToBson getNumberBasedCollectionToBson() {
        return this.numberBasedCollectionToBson;
    }

    public NumberBasedToBson getNumberBasedToBson() {
        return this.numberBasedToBson;
    }

    public ObjectIdArrayToBson getObjectIdArrayToBson() {
        return this.objectIdArrayToBson;
    }

    public ObjectIdCollectionToBson getObjectIdCollectionToBson() {
        return this.objectIdCollectionToBson;
    }

    public ObjectIdToBson getObjectIdToBson() {
        return this.objectIdToBson;
    }

    public ShortPrimArrayToBson getShortPrimArrayToBson() {
        return this.shortPrimArrayToBson;
    }

    public ShortPrimToBson getShortPrimToBson() {
        return this.shortPrimToBson;
    }

    public StringBasedArrayToBson getStringBasedArrayToBson() {
        return this.stringBasedArrayToBson;
    }

    public StringBasedCollectionToBson getStringBasedCollectionToBson() {
        return this.stringBasedCollectionToBson;
    }

    public StringBasedToBson getStringBasedToBson() {
        return this.stringBasedToBson;
    }

    public void setBinaryCollectionToBson(BinaryCollectionToBson binaryCollectionToBson) {
        this.binaryCollectionToBson = Objects.requireNonNull(binaryCollectionToBson);
    }

    public void setBinaryToBson(BinaryToBson binaryToBson) {
        this.binaryToBson = Objects.requireNonNull(binaryToBson);
    }

    public void setBooleanArrayToBson(BooleanArrayToBson booleanArrayToBson) {
        this.booleanArrayToBson = Objects.requireNonNull(booleanArrayToBson);
    }

    public void setBooleanCollectionToBson(BooleanCollectionToBson booleanCollectionToBson) {
        this.booleanCollectionToBson = Objects.requireNonNull(booleanCollectionToBson);
    }

    public void setBooleanPrimArrayToBson(BooleanPrimArrayToBson booleanPrimArrayToBson) {
        this.booleanPrimArrayToBson = Objects.requireNonNull(booleanPrimArrayToBson);
    }

    public void setBooleanPrimToBson(BooleanPrimToBson booleanPrimToBson) {
        this.booleanPrimToBson = Objects.requireNonNull(booleanPrimToBson);
    }

    public void setBooleanToBson(BooleanToBson booleanToBson) {
        this.booleanToBson = Objects.requireNonNull(booleanToBson);
    }

    public void setByteArrayToBson(ByteArrayToBson byteArrayToBson) {
        this.byteArrayToBson = Objects.requireNonNull(byteArrayToBson);
    }

    public void setByteCollectionToBson(ByteCollectionToBson byteCollectionToBson) {
        this.byteCollectionToBson = Objects.requireNonNull(byteCollectionToBson);
    }

    public void setBytePrimArrayToBson(BytePrimArrayToBson bytePrimArrayToBson) {
        this.bytePrimArrayToBson = Objects.requireNonNull(bytePrimArrayToBson);
    }

    public void setBytePrimToBson(BytePrimToBson bytePrimToBson) {
        this.bytePrimToBson = Objects.requireNonNull(bytePrimToBson);
    }

    public void setByteToBson(ByteToBson byteToBson) {
        this.byteToBson = Objects.requireNonNull(byteToBson);
    }

    public void setCharacterArrayToBson(CharacterArrayToBson characterArrayToBson) {
        this.characterArrayToBson = Objects.requireNonNull(characterArrayToBson);
    }

    public void setCharacterCollectionToBson(CharacterCollectionToBson characterCollectionToBson) {
        this.characterCollectionToBson = Objects.requireNonNull(characterCollectionToBson);
    }

    public void setCharacterPrimArrayToBson(CharacterPrimArrayToBson characterPrimArrayToBson) {
        this.characterPrimArrayToBson = Objects.requireNonNull(characterPrimArrayToBson);
    }

    public void setCharacterPrimToBson(CharacterPrimToBson characterPrimToBson) {
        this.characterPrimToBson = Objects.requireNonNull(characterPrimToBson);
    }

    public void setCharacterToBson(CharacterToBson characterToBson) {
        this.characterToBson = Objects.requireNonNull(characterToBson);
    }

    public void setDateBasedArrayToBson(DateBasedArrayToBson dateBasedArrayToBson) {
        this.dateBasedArrayToBson = Objects.requireNonNull(dateBasedArrayToBson);
    }

    public void setDateBasedCollectionToBson(DateBasedCollectionToBson dateBasedCollectionToBson) {
        this.dateBasedCollectionToBson = Objects.requireNonNull(dateBasedCollectionToBson);
    }

    public void setDateBasedToBson(DateBasedToBson dateBasedToBson) {
        this.dateBasedToBson = Objects.requireNonNull(dateBasedToBson);
    }

    public void setDoublePrimArrayToBson(DoublePrimArrayToBson doublePrimArrayToBson) {
        this.doublePrimArrayToBson = Objects.requireNonNull(doublePrimArrayToBson);
    }

    public void setEnumArrayToBson(EnumArrayToBson enumArrayToBson) {
        this.enumArrayToBson = Objects.requireNonNull(enumArrayToBson);
    }

    public void setEnumCollectionToBson(EnumCollectionToBson enumCollectionToBson) {
        this.enumCollectionToBson = Objects.requireNonNull(enumCollectionToBson);
    }

    public void setEnumToBson(EnumToBson enumToBson) {
        this.enumToBson = Objects.requireNonNull(enumToBson);
    }

    public void setFloatPrimArrayToBson(FloatPrimArrayToBson floatPrimArrayToBson) {
        this.floatPrimArrayToBson = Objects.requireNonNull(floatPrimArrayToBson);
    }

    public void setFloatPrimToBson(FloatPrimToBson floatPrimToBson) {
        this.floatPrimToBson = Objects.requireNonNull(floatPrimToBson);
    }

    public void setIntegerPrimArrayToBson(IntegerPrimArrayToBson integerPrimArrayToBson) {
        this.integerPrimArrayToBson = Objects.requireNonNull(integerPrimArrayToBson);
    }

    public void setLongPrimArrayToBson(LongPrimArrayToBson longPrimArrayToBson) {
        this.longPrimArrayToBson = Objects.requireNonNull(longPrimArrayToBson);
    }

    public void setNumberBasedArrayToBson(NumberBasedArrayToBson numberBasedArrayToBson) {
        this.numberBasedArrayToBson = Objects.requireNonNull(numberBasedArrayToBson);
    }

    public void setNumberBasedCollectionToBson(NumberBasedCollectionToBson numberBasedCollectionToBson) {
        this.numberBasedCollectionToBson = Objects.requireNonNull(numberBasedCollectionToBson);
    }

    public void setNumberBasedToBson(NumberBasedToBson numberBasedToBson) {
        this.numberBasedToBson = Objects.requireNonNull(numberBasedToBson);
    }

    public void setObjectIdArrayToBson(ObjectIdArrayToBson objectIdArrayToBson) {
        this.objectIdArrayToBson = Objects.requireNonNull(objectIdArrayToBson);
    }

    public void setObjectIdCollectionToBson(ObjectIdCollectionToBson objectIdCollectionToBson) {
        this.objectIdCollectionToBson = Objects.requireNonNull(objectIdCollectionToBson);
    }

    public void setObjectIdToBson(ObjectIdToBson objectIdToBson) {
        this.objectIdToBson = Objects.requireNonNull(objectIdToBson);
    }

    public void setShortPrimArrayToBson(ShortPrimArrayToBson shortPrimArrayToBson) {
        this.shortPrimArrayToBson = Objects.requireNonNull(shortPrimArrayToBson);
    }

    public void setShortPrimToBson(ShortPrimToBson shortPrimToBson) {
        this.shortPrimToBson = Objects.requireNonNull(shortPrimToBson);
    }

    public void setStringBasedArrayToBson(StringBasedArrayToBson stringBasedArrayToBson) {
        this.stringBasedArrayToBson = Objects.requireNonNull(stringBasedArrayToBson);
    }

    public void setStringBasedCollectionToBson(StringBasedCollectionToBson stringBasedCollectionToBson) {
        this.stringBasedCollectionToBson = Objects.requireNonNull(stringBasedCollectionToBson);
    }

    public void setStringBasedToBson(StringBasedToBson stringBasedToBson) {
        this.stringBasedToBson = Objects.requireNonNull(stringBasedToBson);
    }

    @FunctionalInterface
    public static interface BinaryCollectionToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Collection<Binary> var3);
    }

    @FunctionalInterface
    public static interface BinaryToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Binary var3);
    }

    @FunctionalInterface
    public static interface BooleanArrayToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Boolean[] var3);
    }

    @FunctionalInterface
    public static interface BooleanCollectionToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Collection<Boolean> var3);
    }

    @FunctionalInterface
    public static interface BooleanPrimArrayToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, boolean[] var3);
    }

    @FunctionalInterface
    public static interface BooleanPrimToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, boolean var3);
    }

    @FunctionalInterface
    public static interface BooleanToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Boolean var3);
    }

    @FunctionalInterface
    public static interface ByteArrayToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Byte[] var3);
    }

    @FunctionalInterface
    public static interface ByteCollectionToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Collection<Byte> var3);
    }

    @FunctionalInterface
    public static interface BytePrimArrayToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, byte[] var3);
    }

    @FunctionalInterface
    public static interface BytePrimToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, byte var3);
    }

    @FunctionalInterface
    public static interface ByteToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Byte var3);
    }

    @FunctionalInterface
    public static interface CharacterArrayToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Character[] var3);
    }

    @FunctionalInterface
    public static interface CharacterCollectionToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Collection<Character> var3);
    }

    @FunctionalInterface
    public static interface CharacterPrimArrayToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, char[] var3);
    }

    @FunctionalInterface
    public static interface CharacterPrimToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, char var3);
    }

    @FunctionalInterface
    public static interface CharacterToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Character var3);
    }

    @FunctionalInterface
    public static interface DateBasedArrayToBson {
        public List<Date> convert(JaxBsonConfiguration var1, Field var2, Object[] var3);
    }

    @FunctionalInterface
    public static interface DateBasedCollectionToBson {
        public List<Date> convert(JaxBsonConfiguration var1, Field var2, Collection<Object> var3);
    }

    @FunctionalInterface
    public static interface DateBasedToBson {
        public Date convert(JaxBsonConfiguration var1, Field var2, Object var3);
    }

    @FunctionalInterface
    public static interface DoublePrimArrayToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, double[] var3);
    }

    @FunctionalInterface
    public static interface EnumArrayToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Class<?> var3, Enum<?>[] var4);
    }

    @FunctionalInterface
    public static interface EnumCollectionToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Class<?> var3, Collection<Enum<?>> var4);
    }

    @FunctionalInterface
    public static interface EnumToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Class<?> var3, Enum<?> var4);
    }

    @FunctionalInterface
    public static interface FloatPrimArrayToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, float[] var3);
    }

    @FunctionalInterface
    public static interface FloatPrimToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, float var3);
    }

    @FunctionalInterface
    public static interface IntegerPrimArrayToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, int[] var3);
    }

    @FunctionalInterface
    public static interface LongPrimArrayToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, long[] var3);
    }

    @FunctionalInterface
    public static interface NumberBasedArrayToBson {
        public List<Number> convert(JaxBsonConfiguration var1, Field var2, Object[] var3);
    }

    @FunctionalInterface
    public static interface NumberBasedCollectionToBson {
        public List<Number> convert(JaxBsonConfiguration var1, Field var2, Collection<Object> var3);
    }

    @FunctionalInterface
    public static interface NumberBasedToBson {
        public Number convert(JaxBsonConfiguration var1, Field var2, Object var3);
    }

    @FunctionalInterface
    public static interface ObjectIdArrayToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, ObjectId[] var3);
    }

    @FunctionalInterface
    public static interface ObjectIdCollectionToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, Collection<ObjectId> var3);
    }

    @FunctionalInterface
    public static interface ObjectIdToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, ObjectId var3);
    }

    @FunctionalInterface
    public static interface ShortPrimArrayToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, short[] var3);
    }

    @FunctionalInterface
    public static interface ShortPrimToBson {
        public Object convert(JaxBsonConfiguration var1, Field var2, short var3);
    }

    @FunctionalInterface
    public static interface StringBasedArrayToBson {
        public List<String> convert(JaxBsonConfiguration var1, Field var2, Object[] var3);
    }

    @FunctionalInterface
    public static interface StringBasedCollectionToBson {
        public List<String> convert(JaxBsonConfiguration var1, Field var2, Collection<Object> var3);
    }

    @FunctionalInterface
    public static interface StringBasedToBson {
        public String convert(JaxBsonConfiguration var1, Field var2, Object var3);
    }
}

