/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.bson.types.Decimal128;

public class NumberBased {
    private static Class<?>[] OBJECT_TYPES = new Class[]{BigDecimal.class, BigInteger.class, Decimal128.class, Double.class, Double.TYPE, Float.class, Float.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE};
    private static final Set<Class<?>> OBJECT_TYPES_SET = new HashSet(Arrays.asList(OBJECT_TYPES));
    private final Set<Class<?>> _checkerFalse = new HashSet();
    private final Set<Class<?>> _checkerTrue = new HashSet();
    private Checker checker = type -> {
        if (this._checkerTrue.contains(type)) {
            return true;
        }
        if (this._checkerFalse.contains(type)) {
            return false;
        }
        for (Class<?> e : OBJECT_TYPES_SET) {
            if (!e.isAssignableFrom(type)) continue;
            this._checkerTrue.add(type);
            return true;
        }
        this._checkerFalse.add(type);
        return false;
    };
    private ToBson toBson = value -> {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (BigDecimal.class.isAssignableFrom(type)) {
            return new BsonNumber(new Decimal128((BigDecimal)value));
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return new BsonNumber(new Decimal128(new BigDecimal((BigInteger)value)));
        }
        if (Decimal128.class.isAssignableFrom(type)) {
            return new BsonNumber((Decimal128)value);
        }
        if (Double.class.isAssignableFrom(type)) {
            return new BsonNumber((Double)value);
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return new BsonNumber((Double)value);
        }
        if (Float.class.isAssignableFrom(type)) {
            return new BsonNumber(((Float)value).doubleValue());
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return new BsonNumber(((Float)value).doubleValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return new BsonNumber((Integer)value);
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return new BsonNumber((Integer)value);
        }
        if (Long.class.isAssignableFrom(type)) {
            return new BsonNumber((Long)value);
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return new BsonNumber((Long)value);
        }
        if (Short.class.isAssignableFrom(type)) {
            return new BsonNumber(((Short)value).intValue());
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return new BsonNumber(((Short)value).intValue());
        }
        throw new IllegalStateException("Failed to convert value to Bson: " + value);
    };
    private ToObject toObject = (type, value) -> {
        if (value == null) {
            return null;
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            if (Decimal128.class.isAssignableFrom(type)) {
                return ((Decimal128)value).bigDecimalValue();
            }
            return new BigDecimal(value.doubleValue());
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            if (Decimal128.class.isAssignableFrom(type)) {
                return ((Decimal128)value).bigDecimalValue().toBigInteger();
            }
            return BigInteger.valueOf(value.longValue());
        }
        if (Decimal128.class.isAssignableFrom(type)) {
            if (value instanceof Decimal128) {
                return value;
            }
            return new Decimal128(value.longValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            return value.doubleValue();
        }
        if (Double.TYPE.isAssignableFrom(type)) {
            return value.doubleValue();
        }
        if (Float.class.isAssignableFrom(type)) {
            return Float.valueOf(value.floatValue());
        }
        if (Float.TYPE.isAssignableFrom(type)) {
            return Float.valueOf(value.floatValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return value.intValue();
        }
        if (Integer.TYPE.isAssignableFrom(type)) {
            return value.intValue();
        }
        if (Long.class.isAssignableFrom(type)) {
            return value.longValue();
        }
        if (Long.TYPE.isAssignableFrom(type)) {
            return value.longValue();
        }
        if (Short.class.isAssignableFrom(type)) {
            return value.shortValue();
        }
        if (Short.TYPE.isAssignableFrom(type)) {
            return value.shortValue();
        }
        throw new IllegalStateException("Failed to convert value to Java object: " + value);
    };

    public Checker getChecker() {
        return this.checker;
    }

    public ToBson getToBson() {
        return this.toBson;
    }

    public ToObject getToObject() {
        return this.toObject;
    }

    public void setChecker(Checker checker) {
        this.checker = Objects.requireNonNull(checker);
    }

    public void setToBson(ToBson toBson) {
        this.toBson = Objects.requireNonNull(toBson);
    }

    public void setToObject(ToObject toObject) {
        this.toObject = Objects.requireNonNull(toObject);
    }

    @FunctionalInterface
    public static interface Checker {
        public boolean check(Class<?> var1);
    }

    @FunctionalInterface
    public static interface ToBson {
        public BsonNumber convert(Object var1);
    }

    @FunctionalInterface
    public static interface ToObject {
        public Object convert(Class<?> var1, Number var2);
    }

    public static class BsonNumber {
        private final Number value;

        public BsonNumber(Decimal128 value) {
            this.value = value;
        }

        public BsonNumber(Double value) {
            this.value = value;
        }

        public BsonNumber(Integer value) {
            this.value = value;
        }

        public BsonNumber(Long value) {
            this.value = value;
        }

        public Number getValue() {
            return this.value;
        }
    }
}

