/*
 * Decompiled with CFR 0.152.
 */
package org.qnixyz.jbson;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class StringBased {
    private static Class<?>[] TYPES = new Class[]{File.class, String.class, URI.class, URL.class};
    private static Set<Class<?>> TYPES_SET = new HashSet(Arrays.asList(TYPES));
    private final Set<Class<?>> _checkerFalse = new HashSet();
    private final Set<Class<?>> _checkerTrue = new HashSet();
    private Checker checker = type -> {
        if (this._checkerTrue.contains(type)) {
            return true;
        }
        if (this._checkerFalse.contains(type)) {
            return false;
        }
        for (Class<?> e : TYPES_SET) {
            if (!e.isAssignableFrom(type)) continue;
            this._checkerTrue.add(type);
            return true;
        }
        this._checkerFalse.add(type);
        return false;
    };
    private ToBson toBson = value -> {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (String.class.isAssignableFrom(type)) {
            return (String)value;
        }
        if (File.class.isAssignableFrom(type)) {
            return value.toString();
        }
        if (URI.class.isAssignableFrom(type)) {
            return value.toString();
        }
        if (URL.class.isAssignableFrom(type)) {
            return value.toString();
        }
        throw new IllegalStateException("Failed to convert value to Bson: " + value);
    };
    private ToObject toObject = (type, value) -> {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return value;
        }
        if (File.class.isAssignableFrom(type)) {
            return new File(value);
        }
        if (URI.class.isAssignableFrom(type)) {
            try {
                return new URI(value);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Failed to convert value to Java URI object: " + value, e);
            }
        }
        if (URL.class.isAssignableFrom(type)) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Failed to convert value to Java URL object: " + value, e);
            }
        }
        throw new IllegalStateException("Failed to convert value to Java object: " + value);
    };

    public Checker getChecker() {
        return this.checker;
    }

    public ToBson getToBson() {
        return this.toBson;
    }

    public ToObject getToObject() {
        return this.toObject;
    }

    public void setChecker(Checker checker) {
        this.checker = Objects.requireNonNull(checker);
    }

    public void setToBson(ToBson toBson) {
        this.toBson = Objects.requireNonNull(toBson);
    }

    public void setToObject(ToObject toObject) {
        this.toObject = Objects.requireNonNull(toObject);
    }

    @FunctionalInterface
    public static interface Checker {
        public boolean check(Class<?> var1);
    }

    @FunctionalInterface
    public static interface ToBson {
        public String convert(Object var1);
    }

    @FunctionalInterface
    public static interface ToObject {
        public Object convert(Class<?> var1, String var2);
    }
}

